/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.misc;

import com.sun.corba.ee.spi.orbutil.misc.DprintUtil;
import com.sun.corba.ee.spi.orbutil.misc.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.misc.OperationTracer;
import java.util.Map;
import java.util.WeakHashMap;

public class MethodMonitorFactory {
    private static final MethodMonitor noopImpl = new MethodMonitorBase("NoOpImpl"){

        @Override
        public void enter(boolean enabled, String name, Object ... args) {
        }

        @Override
        public void exit(boolean enabled, Object result) {
        }
    };
    public static final MethodMonitor operationTracer = new MethodMonitorBase("OperationTracer"){

        @Override
        public void enter(boolean enabled, String name, Object ... args) {
            OperationTracer.enter(name, args);
        }

        @Override
        public void exit(boolean enabled, Object result) {
            OperationTracer.exit();
        }

        @Override
        public void clear() {
            OperationTracer.clear();
        }
    };
    private static Map<Class<?>, MethodMonitor> stdMap = new WeakHashMap();

    private MethodMonitorFactory() {
    }

    public static MethodMonitor getNoOp() {
        return noopImpl;
    }

    public static MethodMonitor compose(final MethodMonitor ... mms) {
        return new MethodMonitorBase("ComposeImpl"){

            @Override
            public void enter(boolean enabled, String name, Object ... args) {
                for (MethodMonitor mm : mms) {
                    mm.enter(enabled, name, args);
                }
            }

            @Override
            public void info(boolean enabled, Object ... args) {
                for (MethodMonitor mm : mms) {
                    mm.info(enabled, args);
                }
            }

            @Override
            public void exit(boolean enabled, Object result) {
                for (MethodMonitor mm : mms) {
                    mm.exit(enabled, result);
                }
            }
        };
    }

    public static MethodMonitor dprintUtil(Class cls) {
        final DprintUtil dputil = DprintUtil.getDprintUtil(cls);
        return new MethodMonitorBase("DprintUtil"){

            @Override
            public void enter(boolean enabled, String name, Object ... args) {
                if (enabled) {
                    dputil.enter(name, args);
                }
            }

            @Override
            public void info(boolean enabled, Object ... args) {
                if (enabled) {
                    dputil.info(args);
                }
            }

            @Override
            public void exit(boolean enabled, Object result) {
                if (enabled) {
                    dputil.exit(result);
                }
            }
        };
    }

    private static MethodMonitor standardImpl(Class cls) {
        final DprintUtil dputil = DprintUtil.getDprintUtil(cls);
        return new MethodMonitorBase("StandardImpl"){

            @Override
            public void enter(boolean enabled, String name, Object ... args) {
                OperationTracer.enter(name, args);
                if (enabled) {
                    dputil.enter(name, args);
                }
            }

            @Override
            public void info(boolean enabled, Object ... args) {
                if (enabled) {
                    dputil.info(args);
                }
            }

            @Override
            public void exit(boolean enabled, Object result) {
                OperationTracer.exit();
                if (enabled) {
                    dputil.exit(result);
                }
            }

            @Override
            public void clear() {
                OperationTracer.clear();
            }
        };
    }

    public static MethodMonitor makeStandard(Class cls) {
        MethodMonitor result = stdMap.get(cls);
        if (result == null) {
            result = MethodMonitorFactory.standardImpl(cls);
            stdMap.put(cls, result);
        }
        return result;
    }

    private static abstract class MethodMonitorBase
    implements MethodMonitor {
        private String name;

        MethodMonitorBase(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public abstract void enter(boolean var1, String var2, Object ... var3);

        @Override
        public void info(boolean enabled, Object ... args) {
        }

        @Override
        public abstract void exit(boolean var1, Object var2);

        @Override
        public void exit(boolean enabled) {
            this.exit(enabled, null);
        }

        @Override
        public void clear() {
        }
    }
}

