/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.ClassSerializer;
import com.googlecode.jtype.ClassSerializers;
import com.googlecode.jtype.ClassUtils;
import com.googlecode.jtype.DefaultGenericArrayType;
import com.googlecode.jtype.DefaultParameterizedType;
import com.googlecode.jtype.DefaultTypeVariable;
import com.googlecode.jtype.DefaultWildcardType;
import com.googlecode.jtype.Types;
import com.googlecode.jtype.Utils;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeUtils {
    private static final Map<Class<?>, Set<Class<?>>> SUBTYPES_BY_PRIMITIVE;

    private TypeUtils() {
        throw new AssertionError();
    }

    public static boolean isAssignable(Type supertype, Type type2) {
        Utils.checkNotNull(supertype, "supertype");
        Utils.checkNotNull(type2, "type");
        if (supertype.equals(type2)) {
            return true;
        }
        if (supertype instanceof Class) {
            if (type2 instanceof Class) {
                return TypeUtils.isClassAssignable((Class)supertype, (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                return TypeUtils.isAssignable(supertype, ((ParameterizedType)type2).getRawType());
            }
            if (type2 instanceof TypeVariable) {
                return TypeUtils.isTypeVariableAssignable(supertype, (TypeVariable)type2);
            }
            if (type2 instanceof GenericArrayType) {
                if (((Class)supertype).isArray()) {
                    return TypeUtils.isAssignable(TypeUtils.getComponentType(supertype), TypeUtils.getComponentType(type2));
                }
                return TypeUtils.isArraySupertype((Class)supertype);
            }
            return false;
        }
        if (supertype instanceof ParameterizedType) {
            if (type2 instanceof Class) {
                return TypeUtils.isSuperAssignable(supertype, type2);
            }
            if (type2 instanceof ParameterizedType) {
                return TypeUtils.isParameterizedTypeAssignable((ParameterizedType)supertype, (ParameterizedType)type2);
            }
            return false;
        }
        if (type2 instanceof TypeVariable) {
            return TypeUtils.isTypeVariableAssignable(supertype, (TypeVariable)type2);
        }
        if (supertype instanceof GenericArrayType) {
            if (TypeUtils.isArray(type2)) {
                return TypeUtils.isAssignable(TypeUtils.getComponentType(supertype), TypeUtils.getComponentType(type2));
            }
            return false;
        }
        if (supertype instanceof WildcardType) {
            return TypeUtils.isWildcardTypeAssignable((WildcardType)supertype, type2);
        }
        return false;
    }

    public static boolean isInstance(Type type2, Object object) {
        return TypeUtils.getErasedReferenceType(type2).isInstance(object);
    }

    public static Type getErasedType(Type type2) {
        if (type2 instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type2).getRawType();
            return TypeUtils.getErasedType(rawType);
        }
        if (TypeUtils.isArray(type2)) {
            Type componentType = TypeUtils.getComponentType(type2);
            Type erasedComponentType = TypeUtils.getErasedType(componentType);
            return TypeUtils.getArrayType(erasedComponentType);
        }
        if (type2 instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type2).getBounds();
            return TypeUtils.getErasedType(bounds[0]);
        }
        return type2;
    }

    public static Class<?> getErasedReferenceType(Type type2) {
        Utils.checkTrue(TypeUtils.isReferenceType(type2), "type is not a reference type: ", type2);
        return (Class)TypeUtils.getErasedType(type2);
    }

    @Deprecated
    public static Class<?> getRawType(Type type2) {
        return TypeUtils.getErasedReferenceType(type2);
    }

    public static boolean isArray(Type type2) {
        return type2 instanceof Class && ((Class)type2).isArray() || type2 instanceof GenericArrayType;
    }

    public static Type getComponentType(Type type2) {
        if (type2 instanceof Class) {
            Class klass = (Class)type2;
            return klass.isArray() ? klass.getComponentType() : null;
        }
        if (type2 instanceof GenericArrayType) {
            return ((GenericArrayType)type2).getGenericComponentType();
        }
        return null;
    }

    public static Type getArrayType(Type componentType) {
        Utils.checkNotNull(componentType, "componentType");
        if (componentType instanceof Class) {
            return ClassUtils.getArrayType((Class)componentType);
        }
        return Types.genericArrayType(componentType);
    }

    public static boolean isSimpleParameterizedType(Type type2, Class<?> rawType) {
        Utils.checkNotNull(type2, "type");
        Utils.checkNotNull(rawType, "rawType");
        if (!(type2 instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType paramType = (ParameterizedType)type2;
        Type paramRawType = paramType.getRawType();
        if (!(paramRawType instanceof Class)) {
            return false;
        }
        Class paramRawClass = (Class)paramRawType;
        if (!rawType.isAssignableFrom(paramRawClass)) {
            return false;
        }
        Type[] typeArgs = paramType.getActualTypeArguments();
        return typeArgs.length == 1;
    }

    public static Type getActualTypeArgument(Type type2) {
        Utils.checkNotNull(type2, "type");
        ParameterizedType paramType = (ParameterizedType)type2;
        Type[] typeArgs = paramType.getActualTypeArguments();
        Utils.checkTrue(typeArgs.length == 1, "type must be a ParameterizedType with one actual type argument: ", type2);
        return typeArgs[0];
    }

    public static Type getResolvedSuperclass(Type type2) {
        Utils.checkNotNull(type2, "type");
        Class<?> rawType = TypeUtils.getErasedReferenceType(type2);
        Type supertype = rawType.getGenericSuperclass();
        if (supertype == null) {
            return null;
        }
        return TypeUtils.resolveTypeVariables(supertype, type2);
    }

    public static Type[] getResolvedInterfaces(Type type2) {
        Utils.checkNotNull(type2, "type");
        Class<?> rawType = TypeUtils.getErasedReferenceType(type2);
        Type[] interfaces = rawType.getGenericInterfaces();
        Type[] resolvedInterfaces = new Type[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            resolvedInterfaces[i] = TypeUtils.resolveTypeVariables(interfaces[i], type2);
        }
        return resolvedInterfaces;
    }

    public static String toString(Type type2) {
        return TypeUtils.toString(type2, ClassSerializers.QUALIFIED);
    }

    public static String toString(Type type2, ClassSerializer serializer) {
        if (type2 instanceof Class) {
            Class klass = (Class)type2;
            if (klass.isArray()) {
                return TypeUtils.toString(klass.getComponentType(), serializer) + "[]";
            }
            return serializer.toString(klass);
        }
        if (type2 instanceof TypeVariable) {
            return DefaultTypeVariable.toString((TypeVariable)type2, serializer);
        }
        if (type2 instanceof GenericArrayType) {
            return DefaultGenericArrayType.toString((GenericArrayType)type2, serializer);
        }
        if (type2 instanceof ParameterizedType) {
            return DefaultParameterizedType.toString((ParameterizedType)type2, serializer);
        }
        if (type2 instanceof WildcardType) {
            return DefaultWildcardType.toString((WildcardType)type2, serializer);
        }
        return String.valueOf(type2);
    }

    public static String toUnqualifiedString(Type type2) {
        return TypeUtils.toString(type2, ClassSerializers.UNQUALIFIED);
    }

    public static String toSimpleString(Type type2) {
        return TypeUtils.toString(type2, ClassSerializers.SIMPLE);
    }

    static StringBuilder appendBounds(StringBuilder builder, Type[] bounds, ClassSerializer serializer) {
        for (int i = 0; i < bounds.length; ++i) {
            if (i > 0) {
                builder.append(" & ");
            }
            builder.append(TypeUtils.toString(bounds[i], serializer));
        }
        return builder;
    }

    private static void putPrimitiveSubtypes(Map<Class<?>, Set<Class<?>>> subtypesByPrimitive, Class<?> primitiveType, Class<?> ... directSubtypes) {
        HashSet subtypes = new HashSet();
        for (Class<?> directSubtype : directSubtypes) {
            subtypes.add(directSubtype);
            subtypes.addAll((Collection)subtypesByPrimitive.get(directSubtype));
        }
        subtypesByPrimitive.put(primitiveType, Collections.unmodifiableSet(subtypes));
    }

    private static boolean isClassAssignable(Class<?> supertype, Class<?> type2) {
        if (supertype.isPrimitive() && type2.isPrimitive()) {
            return SUBTYPES_BY_PRIMITIVE.get(supertype).contains(type2);
        }
        return supertype.isAssignableFrom(type2);
    }

    private static boolean isParameterizedTypeAssignable(ParameterizedType supertype, ParameterizedType type2) {
        Type[] typeArgs;
        Type rawType;
        Type rawSupertype = supertype.getRawType();
        if (!rawSupertype.equals(rawType = type2.getRawType())) {
            if (rawSupertype instanceof Class && rawType instanceof Class && !((Class)rawSupertype).isAssignableFrom((Class)rawType)) {
                return false;
            }
            return TypeUtils.isSuperAssignable(supertype, type2);
        }
        Type[] supertypeArgs = supertype.getActualTypeArguments();
        if (supertypeArgs.length != (typeArgs = type2.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < supertypeArgs.length; ++i) {
            Type supertypeArg = supertypeArgs[i];
            Type typeArg = typeArgs[i];
            if (!(supertypeArg instanceof WildcardType ? !TypeUtils.isWildcardTypeAssignable((WildcardType)supertypeArg, typeArg) : !supertypeArg.equals(typeArg))) continue;
            return false;
        }
        return true;
    }

    private static boolean isTypeVariableAssignable(Type supertype, TypeVariable<?> type2) {
        for (Type bound : type2.getBounds()) {
            if (!TypeUtils.isAssignable(supertype, bound)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWildcardTypeAssignable(WildcardType supertype, Type type2) {
        for (Type upperBound : supertype.getUpperBounds()) {
            if (TypeUtils.isAssignable(upperBound, type2)) continue;
            return false;
        }
        for (Type lowerBound : supertype.getLowerBounds()) {
            if (TypeUtils.isAssignable(type2, lowerBound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSuperAssignable(Type supertype, Type type2) {
        Type superclass = TypeUtils.getResolvedSuperclass(type2);
        if (superclass != null && TypeUtils.isAssignable(supertype, superclass)) {
            return true;
        }
        for (Type interphace : TypeUtils.getResolvedInterfaces(type2)) {
            if (!TypeUtils.isAssignable(supertype, interphace)) continue;
            return true;
        }
        return false;
    }

    private static boolean isReferenceType(Type type2) {
        return type2 == null || type2 instanceof Class || type2 instanceof ParameterizedType || type2 instanceof TypeVariable || type2 instanceof GenericArrayType;
    }

    private static boolean isArraySupertype(Class<?> type2) {
        return Object.class.equals(type2) || Cloneable.class.equals(type2) || Serializable.class.equals(type2);
    }

    private static Type resolveTypeVariables(Type type2, Type subtype) {
        if (!(type2 instanceof ParameterizedType)) {
            return type2;
        }
        Map<Type, Type> actualTypeArgumentsByParameter = TypeUtils.getActualTypeArgumentsByParameter(type2, subtype);
        Class<?> rawType = TypeUtils.getErasedReferenceType(type2);
        return TypeUtils.parameterizeClass(rawType, actualTypeArgumentsByParameter);
    }

    private static Map<Type, Type> getActualTypeArgumentsByParameter(Type ... types) {
        LinkedHashMap<Type, Type> actualTypeArgumentsByParameter = new LinkedHashMap<Type, Type>();
        for (Type type2 : types) {
            actualTypeArgumentsByParameter.putAll(TypeUtils.getActualTypeArgumentsByParameterInternal(type2));
        }
        return TypeUtils.normalize(actualTypeArgumentsByParameter);
    }

    private static Map<Type, Type> getActualTypeArgumentsByParameterInternal(Type type2) {
        Type[] typeArguments;
        if (!(type2 instanceof ParameterizedType)) {
            return Collections.emptyMap();
        }
        TypeVariable<Class<?>>[] typeParameters = TypeUtils.getErasedReferenceType(type2).getTypeParameters();
        if (typeParameters.length != (typeArguments = ((ParameterizedType)type2).getActualTypeArguments()).length) {
            throw new MalformedParameterizedTypeException();
        }
        LinkedHashMap<Type, Type> actualTypeArgumentsByParameter = new LinkedHashMap<Type, Type>();
        for (int i = 0; i < typeParameters.length; ++i) {
            actualTypeArgumentsByParameter.put(typeParameters[i], typeArguments[i]);
        }
        return actualTypeArgumentsByParameter;
    }

    private static ParameterizedType parameterizeClass(Class<?> type2, Map<Type, Type> actualTypeArgumentsByParameter) {
        return TypeUtils.parameterizeClassCapture(type2, actualTypeArgumentsByParameter);
    }

    private static <T> ParameterizedType parameterizeClassCapture(Class<T> type2, Map<Type, Type> actualTypeArgumentsByParameter) {
        TypeVariable<Class<T>>[] typeParameters = type2.getTypeParameters();
        Type[] actualTypeArguments = new Type[typeParameters.length];
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable<Class<T>> typeParameter = typeParameters[i];
            Type actualTypeArgument = actualTypeArgumentsByParameter.get(typeParameter);
            if (actualTypeArgument == null) {
                throw new IllegalArgumentException("Missing actual type argument for type parameter: " + typeParameter);
            }
            actualTypeArguments[i] = actualTypeArgument;
        }
        return Types.parameterizedType(TypeUtils.getErasedReferenceType(type2), actualTypeArguments);
    }

    private static <K, V> Map<K, V> normalize(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            while (map.containsKey(value)) {
                value = map.get(value);
            }
            map.put(key, value);
        }
        return map;
    }

    static {
        HashMap subtypesByPrimitive = new HashMap();
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Void.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Boolean.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Byte.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Character.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Short.TYPE, Byte.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Integer.TYPE, Character.TYPE, Short.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Long.TYPE, Integer.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Float.TYPE, Long.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Double.TYPE, Float.TYPE);
        SUBTYPES_BY_PRIMITIVE = Collections.unmodifiableMap(subtypesByPrimitive);
    }
}

