/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.hk2.component.InhabitantParser;
import com.sun.hk2.component.InhabitantsParser;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.osgiadapter.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class OSGiInhabitantsParser
extends InhabitantsParser {
    public static final String SERVICE_NAME = "ServiceName";
    private BundleContext osgiCtx;

    public OSGiInhabitantsParser(Habitat habitat, BundleContext ctx) {
        super(habitat);
        this.osgiCtx = ctx;
    }

    protected void add(Inhabitant i, InhabitantParser parser) {
        super.add(i, parser);
        ArrayList<String> fqcnContractNames = new ArrayList<String>();
        for (String contract : parser.getIndexes()) {
            int idx = contract.indexOf(58);
            if (idx == -1) {
                fqcnContractNames.add(contract);
                continue;
            }
            fqcnContractNames.add(contract.substring(0, idx));
        }
        fqcnContractNames.add(i.typeName());
        Properties props = new Properties();
        ServiceRegistration reg = this.osgiCtx.registerService(fqcnContractNames.toArray(new String[0]), (Object)new InhabitantServiceFactory(i), (Dictionary)props);
        Logger.logger.logp(Level.INFO, "InhabitantsParser", "registerOSGiService", "reg = {0}", reg);
    }

    static class InhabitantServiceFactory
    implements ServiceFactory {
        private Inhabitant i;

        public InhabitantServiceFactory(Inhabitant i) {
            this.i = i;
        }

        public Object getService(Bundle bundle2, ServiceRegistration registration) {
            return this.i.get();
        }

        public void ungetService(Bundle bundle2, ServiceRegistration registration, Object service) {
            this.i = null;
        }
    }
}

