/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;

class Recorder
implements InhabitantListener {
    private final int runLevel;
    private final Stack<Inhabitant<?>> activations = new Stack();
    private final Class<?> targetEnv;

    Recorder(int runLevel, Class<?> targetEnv) {
        this(new ArrayList(), runLevel, targetEnv);
    }

    Recorder(List<Inhabitant<?>> list, int runLevel) {
        this(new ArrayList(), runLevel, Void.class);
    }

    Recorder(List<Inhabitant<?>> list, int runLevel, Class<?> targetEnv) {
        this.activations.addAll(list);
        this.runLevel = runLevel;
        this.targetEnv = targetEnv;
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    List<Inhabitant<?>> getActivations() {
        return Collections.unmodifiableList(this.activations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(Inhabitant<?> inhabitant) {
        Stack<Inhabitant<?>> stack = this.activations;
        synchronized (stack) {
            this.activations.add(inhabitant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Inhabitant<?> pop() {
        Stack<Inhabitant<?>> stack = this.activations;
        synchronized (stack) {
            return this.activations.isEmpty() ? null : this.activations.pop();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.runLevel + ", " + this.activations + ")\n";
    }

    @Override
    public synchronized boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        if (InhabitantListener.EventType.INHABITANT_ACTIVATED == eventType) {
            assert (inhabitant.isInstantiated());
            assert (AbstractInhabitantImpl.class.isInstance(inhabitant));
            RunLevel rl = ((AbstractInhabitantImpl)inhabitant).getAnnotation(RunLevel.class);
            if (null != rl && this.targetEnv == rl.environment()) {
                this.push(inhabitant);
                if (rl.value() > this.runLevel) {
                    throw new ComponentException("Invalid RunLevel dependency to: " + inhabitant);
                }
            }
        }
        return true;
    }
}

