/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.bean.interceptor.WeldInterceptorInstantiator;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.ProxyClassConstructorInjectionPointWrapper;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.interceptor.proxy.DefaultInvocationContextFactory;
import org.jboss.weld.interceptor.proxy.InterceptorProxyCreatorImpl;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBean<T>
extends AbstractClassBean<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Category.BEAN);
    private Set<WeldInjectionPoint<?, ?>> ejbInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> resourceInjectionPoints;
    private ManagedBean<?> specializedBean;
    private boolean passivationCapableBean;
    private boolean passivationCapableDependency;
    private final boolean proxiable;

    public static <T> ManagedBean<T> of(WeldClass<T> clazz, BeanManagerImpl beanManager, ServiceRegistry services) {
        if (clazz.isDiscovered()) {
            return new ManagedBean<T>(clazz, ManagedBean.createSimpleId(ManagedBean.class.getSimpleName(), clazz), beanManager, services);
        }
        return new ManagedBean<T>(clazz, ManagedBean.createId(ManagedBean.class.getSimpleName(), clazz), beanManager, services);
    }

    protected static String createSimpleId(String beanType, WeldClass<?> clazz) {
        return beanType + "-" + clazz.getBaseType();
    }

    protected static String createId(String beanType, WeldClass<?> clazz) {
        return beanType + "-" + AnnotatedTypes.createTypeId(clazz);
    }

    protected ManagedBean(WeldClass<T> type2, String idSuffix, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(type2, idSuffix, beanManager, services);
        this.initType();
        this.initTypes();
        this.initQualifiers();
        this.initConstructor();
        this.proxiable = Proxies.isTypesProxyable(type2.getTypeClosure());
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = this.getInjectionTarget().produce(creationalContext);
        this.getInjectionTarget().inject(instance, creationalContext);
        this.getInjectionTarget().postConstruct(instance);
        return instance;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.getInjectionTarget().preDestroy(instance);
            if (creationalContext instanceof CreationalContextImpl) {
                ((CreationalContextImpl)creationalContext).release(this, instance);
            } else {
                creationalContext.release();
            }
        }
        catch (Exception e) {
            log.error(BeanMessage.ERROR_DESTROYING, this, instance);
            xLog.throwing(XLogger.Level.DEBUG, e);
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            this.checkConstructor();
            super.initialize(environment);
            this.initPostConstruct();
            this.initPreDestroy();
            this.initEEInjectionPoints();
            this.initPassivationCapable();
            this.setInjectionTarget(new ManagedBeanInjectionTarget(this));
        }
    }

    protected T createInstance(CreationalContext<T> ctx) {
        if (!this.isSubclassed()) {
            return this.getConstructor().newInstance(this.beanManager, ctx);
        }
        ProxyClassConstructorInjectionPointWrapper constructorInjectionPointWrapper = new ProxyClassConstructorInjectionPointWrapper(this, this.constructorForEnhancedSubclass, this.getConstructor());
        return constructorInjectionPointWrapper.newInstance(this.beanManager, ctx);
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.initInterceptorsIfNeeded();
        if (this.passivationCapableBean && this.hasDecorators()) {
            for (Decorator<?> decorator : this.getDecorators()) {
                if (PassivationCapable.class.isAssignableFrom(decorator.getClass()) && ((WeldDecorator)decorator).getWeldAnnotated().isSerializable()) continue;
                this.passivationCapableBean = false;
                break;
            }
        }
        if (this.passivationCapableBean && this.hasInterceptors()) {
            for (InterceptorMetadata interceptorMetadata : this.getBeanManager().getInterceptorModelRegistry().get(this.getType()).getAllInterceptors()) {
                if (Reflections.isSerializable(interceptorMetadata.getInterceptorClass().getJavaClass())) continue;
                this.passivationCapableBean = false;
                break;
            }
        }
        super.initializeAfterBeanDiscovery();
    }

    private void initPassivationCapable() {
        this.passivationCapableBean = this.getWeldAnnotated().isSerializable();
        this.passivationCapableDependency = Container.instance().services().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isNormal() ? true : this.getScope().equals(Dependent.class) && this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return this.passivationCapableDependency;
    }

    private void initEEInjectionPoints() {
        this.ejbInjectionPoints = Beans.getEjbInjectionPoints(this, this.getWeldAnnotated(), this.getBeanManager());
        this.persistenceContextInjectionPoints = Beans.getPersistenceContextInjectionPoints(this, this.getWeldAnnotated(), this.getBeanManager());
        this.persistenceUnitInjectionPoints = Beans.getPersistenceUnitInjectionPoints(this, this.getWeldAnnotated(), this.getBeanManager());
        this.resourceInjectionPoints = Beans.getResourceInjectionPoints(this, this.getWeldAnnotated(), this.beanManager);
    }

    @Override
    protected void checkType() {
        if (this.getWeldAnnotated().isAnonymousClass() || this.getWeldAnnotated().isMemberClass() && !this.getWeldAnnotated().isStatic()) {
            throw new DefinitionException(BeanMessage.SIMPLE_BEAN_AS_NON_STATIC_INNER_CLASS_NOT_ALLOWED, this.type);
        }
        if (!this.isDependent() && this.getWeldAnnotated().isParameterizedType()) {
            throw new DefinitionException(BeanMessage.BEAN_MUST_BE_DEPENDENT, this.type);
        }
        boolean passivating = this.beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.scope).isPassivating();
        if (passivating && !this.isPassivationCapableBean()) {
            throw new DefinitionException(BeanMessage.PASSIVATING_BEAN_NEEDS_SERIALIZABLE_IMPL, this);
        }
        if (this.hasDecorators()) {
            if (this.getWeldAnnotated().isFinal()) {
                throw new DefinitionException(BeanMessage.FINAL_BEAN_CLASS_WITH_DECORATORS_NOT_ALLOWED, this);
            }
            for (Decorator<?> decorator : this.getDecorators()) {
                WeldClass<?> decoratorClass;
                if (decorator instanceof DecoratorImpl) {
                    DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                    decoratorClass = decoratorBean.getWeldAnnotated();
                } else if (decorator instanceof CustomDecoratorWrapper) {
                    decoratorClass = ((CustomDecoratorWrapper)decorator).getWeldAnnotated();
                } else {
                    throw new IllegalStateException(BeanMessage.NON_CONTAINER_DECORATOR, decorator);
                }
                for (WeldMethod<?, ?> decoratorMethod : decoratorClass.getWeldMethods()) {
                    WeldMethod method = this.getWeldAnnotated().getWeldMethod(decoratorMethod.getSignature());
                    if (method == null || method.isStatic() || method.isPrivate() || !method.isFinal()) continue;
                    throw new DefinitionException(BeanMessage.FINAL_BEAN_CLASS_WITH_INTERCEPTORS_NOT_ALLOWED, method, decoratorMethod);
                }
            }
        }
    }

    @Override
    protected void checkBeanImplementation() {
        super.checkBeanImplementation();
        if (this.isNormalScoped()) {
            for (WeldField<?, ?> field : this.getWeldAnnotated().getWeldFields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                throw new DefinitionException(BeanMessage.PUBLIC_FIELD_ON_NORMAL_SCOPED_BEAN_NOT_ALLOWED, this.getWeldAnnotated());
            }
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        if (closure.isEJB(this.getWeldAnnotated().getWeldSuperclass())) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        Bean<?> specializedBean = closure.getClassBean(this.getWeldAnnotated().getWeldSuperclass());
        if (specializedBean == null) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
        if (!(specializedBean instanceof ManagedBean)) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
        this.specializedBean = (ManagedBean)specializedBean;
    }

    @Override
    public ManagedBean<?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected boolean isInterceptionCandidate() {
        return !Beans.isInterceptor(this.getWeldAnnotated()) && !Beans.isDecorator(this.getWeldAnnotated());
    }

    protected T applyInterceptors(T instance, CreationalContext<T> creationalContext) {
        try {
            WeldInterceptorInstantiator<T> interceptorInstantiator = new WeldInterceptorInstantiator<T>(this.beanManager, creationalContext);
            InterceptorProxyCreatorImpl interceptorProxyCreator = new InterceptorProxyCreatorImpl(interceptorInstantiator, new DefaultInvocationContextFactory(), this.beanManager.getInterceptorModelRegistry().get(this.getType()));
            MethodHandler methodHandler = interceptorProxyCreator.createSubclassingMethodHandler(null, WeldInterceptorClassMetadata.of(this.getWeldAnnotated()));
            CombinedInterceptorAndDecoratorStackMethodHandler wrapperMethodHandler = (CombinedInterceptorAndDecoratorStackMethodHandler)((ProxyObject)instance).getHandler();
            wrapperMethodHandler.setInterceptorMethodHandler(methodHandler);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return instance;
    }

    @Override
    public String toString() {
        return "Managed Bean [" + this.getBeanClass().toString() + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }

    @Override
    public boolean hasDefaultProducer() {
        return this.getInjectionTarget() instanceof ManagedBeanInjectionTarget;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedBeanInjectionTarget<T>
    implements InjectionTarget<T> {
        private final ManagedBean<T> bean;

        private ManagedBeanInjectionTarget(ManagedBean<T> bean) {
            this.bean = bean;
        }

        protected ManagedBean<T> getBean() {
            return this.bean;
        }

        @Override
        public void inject(final T instance, final CreationalContext<T> ctx) {
            new FixInjectionPoint<T>(this.bean){

                @Override
                protected T work() {
                    new InjectionContextImpl<T>(ManagedBeanInjectionTarget.this.bean.getBeanManager(), ManagedBeanInjectionTarget.this, (AnnotatedType)((Object)ManagedBeanInjectionTarget.this.getBean().getWeldAnnotated()), instance){

                        @Override
                        public void proceed() {
                            Beans.injectEEFields(instance, ManagedBeanInjectionTarget.this.bean.getBeanManager(), ManagedBeanInjectionTarget.this.bean.ejbInjectionPoints, ManagedBeanInjectionTarget.this.bean.persistenceContextInjectionPoints, ManagedBeanInjectionTarget.this.bean.persistenceUnitInjectionPoints, ManagedBeanInjectionTarget.this.bean.resourceInjectionPoints);
                            Beans.injectFieldsAndInitializers(instance, ctx, ManagedBeanInjectionTarget.this.bean.getBeanManager(), ManagedBeanInjectionTarget.this.bean.getInjectableFields(), ManagedBeanInjectionTarget.this.bean.getInitializerMethods());
                        }
                    }.run();
                    return null;
                }
            }.run();
        }

        @Override
        public void postConstruct(T instance) {
            if (this.bean.hasInterceptors()) {
                InterceptionUtils.executePostConstruct(instance);
            } else {
                this.bean.defaultPostConstruct(instance);
            }
        }

        @Override
        public void preDestroy(T instance) {
            if (this.bean.hasInterceptors()) {
                InterceptionUtils.executePredestroy(instance);
            } else {
                this.bean.defaultPreDestroy(instance);
            }
        }

        @Override
        public void dispose(T instance) {
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return (Set)Reflections.cast(this.bean.getWeldInjectionPoints());
        }

        @Override
        public T produce(final CreationalContext<T> ctx) {
            T instance;
            if (!this.bean.hasDecorators()) {
                instance = this.bean.createInstance(ctx);
                if (!this.bean.isDependent()) {
                    ctx.push(instance);
                }
            } else {
                instance = new FixInjectionPoint<T>(this.bean){

                    @Override
                    protected T work() {
                        Object undecoratedInstance = ManagedBeanInjectionTarget.this.bean.createInstance(ctx);
                        return ManagedBeanInjectionTarget.this.bean.applyDecorators(undecoratedInstance, ctx, this.getOriginalInjectionPoint());
                    }
                }.run();
            }
            if (this.bean.hasInterceptors()) {
                return this.bean.applyInterceptors(instance, ctx);
            }
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class FixInjectionPoint<T> {
        private final AbstractClassBean<T> bean;
        private InjectionPoint originalInjectionPoint;

        private FixInjectionPoint(AbstractClassBean<T> bean) {
            this.bean = bean;
        }

        protected abstract T work();

        private void setup() {
            if (this.bean.hasDecorators()) {
                Decorator<?> decorator = this.bean.getDecorators().get(this.bean.getDecorators().size() - 1);
                InjectionPoint outerDelegateInjectionPoint = Beans.getDelegateInjectionPoint(decorator);
                if (outerDelegateInjectionPoint == null) {
                    throw new IllegalStateException(BeanMessage.DELEGATE_INJECTION_POINT_NOT_FOUND, decorator);
                }
                CurrentInjectionPoint currentInjectionPoint = Container.instance().services().get(CurrentInjectionPoint.class);
                if (currentInjectionPoint.peek() != null) {
                    this.originalInjectionPoint = currentInjectionPoint.pop();
                    currentInjectionPoint.push(outerDelegateInjectionPoint);
                } else {
                    currentInjectionPoint.push(outerDelegateInjectionPoint);
                }
            }
        }

        public InjectionPoint getOriginalInjectionPoint() {
            return this.originalInjectionPoint;
        }

        private void cleanup() {
            if (this.bean.hasDecorators()) {
                CurrentInjectionPoint currentInjectionPoint = Container.instance().services().get(CurrentInjectionPoint.class);
                currentInjectionPoint.pop();
                currentInjectionPoint.push(this.originalInjectionPoint);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T run() {
            try {
                this.setup();
                T t = this.work();
                return t;
            }
            finally {
                this.cleanup();
            }
        }
    }
}

