/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.ArrayList;
import java.util.Map;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.internal.engine.ConfigurationImpl;
import org.hibernate.validator.internal.engine.ValidatorContextImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.ProgrammaticMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.XmlMetaDataProvider;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidatorFactoryImpl
implements HibernateValidatorFactory {
    private static final Log log = LoggerFactory.make();
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final BeanMetaDataManager metaDataManager;
    private final boolean failFast;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
        ConstraintHelper constraintHelper = new ConstraintHelper();
        ArrayList<MetaDataProvider> metaDataProviders = CollectionHelper.newArrayList();
        if (!configurationState.getMappingStreams().isEmpty()) {
            metaDataProviders.add(new XmlMetaDataProvider(constraintHelper, configurationState.getMappingStreams()));
        }
        Map<String, String> properties = configurationState.getProperties();
        boolean tmpFailFast = false;
        if (configurationState instanceof ConfigurationImpl) {
            ConfigurationImpl hibernateSpecificConfig = (ConfigurationImpl)configurationState;
            if (hibernateSpecificConfig.getProgrammaticMappings().size() > 0) {
                metaDataProviders.add(new ProgrammaticMetaDataProvider(constraintHelper, hibernateSpecificConfig.getProgrammaticMappings()));
            }
            tmpFailFast = hibernateSpecificConfig.getFailFast();
        }
        this.failFast = tmpFailFast = this.checkPropertiesForFailFast(properties, tmpFailFast);
        this.metaDataManager = new BeanMetaDataManager(constraintHelper, metaDataProviders);
    }

    @Override
    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    @Override
    public <T> T unwrap(Class<T> type2) {
        if (HibernateValidatorFactory.class.equals(type2)) {
            return type2.cast(this);
        }
        throw log.getTypeNotSupportedException(type2);
    }

    @Override
    public HibernateValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.metaDataManager, this.failFast);
    }

    private boolean checkPropertiesForFailFast(Map<String, String> properties, boolean programmaticConfiguredFailFast) {
        boolean failFast = programmaticConfiguredFailFast;
        String failFastPropValue = properties.get("hibernate.validator.fail_fast");
        if (failFastPropValue != null) {
            boolean tmpFailFast = Boolean.valueOf(failFastPropValue);
            if (programmaticConfiguredFailFast && !tmpFailFast) {
                throw log.getInconsistentFailFastConfigurationException();
            }
            failFast = tmpFailFast;
        }
        return failFast;
    }
}

