/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyServicesImpl
implements ProxyServices {
    ClassLoaderHierarchy clh;

    public ProxyServicesImpl(Habitat habitat) {
        this.clh = habitat.getByContract(ClassLoaderHierarchy.class);
    }

    @Override
    public ClassLoader getClassLoader(final Class<?> proxiedBeanType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ProxyServicesImpl.this.getClassLoaderforBean(proxiedBeanType);
                }
            });
        }
        return this.getClassLoaderforBean(proxiedBeanType);
    }

    private ClassLoader getClassLoaderforBean(Class<?> proxiedBeanType) {
        ClassLoader prxCL = proxiedBeanType.getClassLoader();
        boolean isAppCL = this.isApplicationClassLoader(prxCL);
        if (!isAppCL) {
            prxCL = this._getClassLoader();
        }
        return prxCL;
    }

    private boolean isApplicationClassLoader(ClassLoader prxCL) {
        boolean isAppCL = false;
        while (prxCL != null) {
            if (prxCL.equals(this.clh.getCommonClassLoader())) {
                isAppCL = true;
                break;
            }
            prxCL = prxCL.getParent();
        }
        return isAppCL;
    }

    private ClassLoader _getClassLoader() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        return tcl;
    }

    @Override
    public Class<?> loadBeanClass(final String className) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        ClassLoader cl = ProxyServicesImpl.this._getClassLoader();
                        return Class.forName(className, true, cl);
                    }
                });
            }
            ClassLoader cl = this._getClassLoader();
            return Class.forName(className, true, cl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void cleanup() {
    }
}

