/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="enable-http-lb-server")
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
public final class EnableHTTPLBServerCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(primary=true)
    String target;
    @Inject
    Target tgt;
    @Inject
    LbConfigs lbconfigs;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableHTTPLBServerCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.tgt.isCluster(this.target)) {
            this.updateLBForCluster(report, this.target, "true", null);
        } else {
            boolean foundTarget = false;
            List<LbConfig> lbConfigs = this.lbconfigs.getLbConfig();
            for (LbConfig lc : lbConfigs) {
                ServerRef sRef = lc.getRefByRef(ServerRef.class, this.target);
                if (sRef == null) {
                    logger2.warning(localStrings.getLocalString("InvalidInstance", "Server {0} does not exist in {1}", this.target, lc.getName()));
                    continue;
                }
                boolean enabled = sRef.getLbEnabled().equals("true");
                if (enabled) {
                    String msg = localStrings.getLocalString("ServerEnabled", "Server [{0}] is already enabled.", sRef.getRef());
                    report.setMessage(msg);
                    return;
                }
                try {
                    this.updateLbEnabled(sRef, "true", null);
                }
                catch (TransactionFailure ex) {
                    String msg = localStrings.getLocalString("FailedToUpdateAttr", "Failed to update lb-enabled attribute for {0}", this.target);
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause(ex);
                    return;
                }
                foundTarget = true;
            }
            if (!foundTarget) {
                ServerRef sRef = this.getServerRefFromCluster(report, this.target);
                if (sRef == null) {
                    String msg = localStrings.getLocalString("InvalidServer", "Server {0} does not exist", this.target);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                boolean enabled = sRef.getLbEnabled().equals("true");
                if (enabled) {
                    String msg = localStrings.getLocalString("ServerEnabled", "Server [{0}] is already enabled.", sRef.getRef());
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                try {
                    this.updateLbEnabled(sRef, "true", null);
                }
                catch (TransactionFailure ex) {
                    String msg = localStrings.getLocalString("FailedToUpdateAttr", "Failed to update lb-enabled attribute for {0}", this.target);
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause(ex);
                    return;
                }
            }
        }
    }
}

