/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jstl.integration;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.net.JarURIPattern;
import com.sun.logging.LogDomains;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.taglibs.standard.Version;
import org.glassfish.api.web.TldProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jstlTld")
@Scoped(value=Singleton.class)
public class GlassFishTldProvider
implements TldProvider,
PostConstruct {
    private static final Logger logger = LogDomains.getLogger(GlassFishTldProvider.class, "javax.enterprise.system.container.web");
    private static final ResourceBundle rb = logger.getResourceBundle();
    @Inject
    ModulesRegistry registry;
    private Map<URI, List<String>> tldMap = new HashMap<URI, List<String>>();

    @Override
    public String getName() {
        return "jstlTld";
    }

    @Override
    public Map<URI, List<String>> getTldMap() {
        return (Map)((HashMap)this.tldMap).clone();
    }

    @Override
    public Map<URI, List<String>> getTldListenerMap() {
        return null;
    }

    @Override
    public void postConstruct() {
        Class<Version> jstlImplClass = Version.class;
        URI[] uris = null;
        Module m = null;
        if (jstlImplClass != null) {
            m = this.registry.find(jstlImplClass);
        }
        if (m != null) {
            uris = m.getModuleDefinition().getLocations();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                if (urls != null && urls.length > 0) {
                    uris = new URI[urls.length];
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            uris[i] = urls[i].toURI();
                            continue;
                        }
                        catch (URISyntaxException e) {
                            String msg = rb.getString("tldProvider.ignoreUrl");
                            msg = MessageFormat.format(msg, urls[i]);
                            logger.log(Level.WARNING, msg, e);
                        }
                    }
                }
            } else {
                logger.log(Level.WARNING, "taglibs.unableToDetermineTldResources", new Object[]{"JSTL", classLoader, GlassFishTldProvider.class.getName()});
            }
        }
        if (uris != null && uris.length > 0) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uri : uris) {
                List<String> entries = JarURIPattern.getJarEntries(uri, pattern);
                if (entries == null || entries.size() <= 0) continue;
                this.tldMap.put(uri, entries);
            }
        }
    }
}

