/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.jdbc.admin.cli.JDBCResourceManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-jdbc-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jdbc.resource")
public class DeleteJdbcResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJdbcResource.class);
    @Param(optional=true)
    private String target = "server";
    @Param(name="jdbc_resource_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private JDBCResourceManager jdbcResMgr;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ResourceStatus rs = this.jdbcResMgr.delete(this.domain.getResources(), this.jndiName, this.target);
            if (rs.getMessage() != null) {
                report.setMessage(rs.getMessage());
            }
            if (rs.getStatus() == 0) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                if (rs.getException() != null) {
                    report.setFailureCause(rs.getException());
                }
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("delete.jdbc.resource.fail", "{0} delete failed ", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

