/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_postdeploy")
@Supplemental(value="deploy", ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class PostDeployCommand
extends DeployCommandParameters
implements AdminCommand {
    @Inject
    private Habitat habitat;
    @Inject
    private Deployment deployment;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        DeployCommandSupplementalInfo suppInfo = context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
        DeploymentContext dc = suppInfo.deploymentContext();
        DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
        if (DeploymentUtils.isDASTarget(params.target)) {
            return;
        }
        try {
            ParameterMap paramMap = this.deployment.prepareInstanceDeployParamMap(dc);
            ArrayList<String> targets = new ArrayList<String>();
            if (!DeploymentUtils.isDomainTarget(params.target)) {
                targets.add(params.target);
            } else {
                targets = suppInfo.previousTargets();
            }
            ClusterOperationUtil.replicateCommand("_deploy", FailurePolicy.Warn, FailurePolicy.Warn, targets, context, paramMap, this.habitat);
        }
        catch (Exception e) {
            report.failure(logger2, e.getMessage());
        }
    }
}

