/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.deployment.versioning.VersioningWildcardException;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-application-ref")
@I18n(value="create.application.ref.command")
@ExecuteOn(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class CreateApplicationRefCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Param(optional=true, acceptableValues="true,false")
    public String lbenabled;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    VersioningService versioningService;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    private Habitat habitat;
    @Inject
    Events events;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(AdminCommandContext context) {
        report = context.getActionReport();
        logger = context.getLogger();
        matchedVersions = null;
        if (this.enabled.booleanValue()) {
            try {
                VersioningUtils.checkIdentifier(this.name);
                matchedVersions = new ArrayList<String>(1);
                matchedVersions.add(this.name);
            }
            catch (VersioningWildcardException ex) {
                report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("wildcard.not.allowed", "WARNING : version expression are available only with --enabled=false"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            catch (VersioningSyntaxException ex) {
                report.setMessage(ex.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!this.deployment.isRegistered(this.name)) {
                report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        } else {
            try {
                matchedVersions = this.versioningService.getMatchedVersions(this.name, null);
            }
            catch (VersioningException e) {
                report.failure(logger, e.getMessage());
                return;
            }
            if (matchedVersions.isEmpty()) {
                report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{this.name, this.target}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        part = report.getTopMessagePart();
        isVersionExpression = VersioningUtils.isVersionExpression(this.name);
        it = matchedVersions.iterator();
        while (it.hasNext() != false) {
            appName = it.next();
            app = this.applications.getApplication(appName);
            applicationRef = this.domain.getApplicationRefInTarget(appName, this.target);
            if (applicationRef != null) {
                if (!isVersionExpression) {
                    report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", new Object[]{this.name, this.target}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                childPart = part.addChild();
                childPart.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", new Object[]{appName, this.target}));
                continue;
            }
            t = new Transaction();
            if (app.isLifecycleModule()) {
                this.handleLifecycleModule(context, t);
                return;
            }
            file = null;
            commandParams = null;
            contextProps = new Properties();
            modulePropsMap = null;
            savedAppConfig = null;
            try {
                commandParams = app.getDeployParameters(null);
                commandParams.origin = OpsParams.Origin.create_application_ref;
                commandParams.target = this.target;
                commandParams.virtualservers = this.virtualservers;
                commandParams.enabled = this.enabled;
                if (this.lbenabled != null) {
                    commandParams.lbenabled = this.lbenabled;
                }
                if (app.containsSnifferType("osgi")) {
                    commandParams.type = "osgi";
                }
                contextProps = app.getDeployProperties();
                modulePropsMap = app.getModulePropertiesMap();
                savedAppConfig = new ApplicationConfigInfo(app);
                uri = new URI(app.getLocation());
                file = new File(uri);
                if (!file.exists()) {
                    report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                archive = this.archiveFactory.openArchive(file);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
                report.setMessage(CreateApplicationRefCommand.localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                block35: {
                    deploymentContext = this.deployment.getBuilder(logger, commandParams, report).source(archive).build();
                    appProps = deploymentContext.getAppProps();
                    appProps.putAll((Map<?, ?>)contextProps);
                    location = DeploymentUtils.relativizeWithinDomainIfPossible(new URI(app.getLocation()));
                    appProps.setProperty("location", location);
                    appLocation = appProps.getProperty("appLocation");
                    appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible(new URI(appLocation)));
                    planLocation = appProps.getProperty("deploymentPlanLocation");
                    if (planLocation != null) {
                        appProps.setProperty("deploymentPlanLocation", DeploymentUtils.relativizeWithinDomainIfPossible(new URI(planLocation)));
                    }
                    savedAppConfig.store(appProps);
                    if (modulePropsMap != null) {
                        deploymentContext.setModulePropsMap(modulePropsMap);
                    }
                    if (this.enabled.booleanValue()) {
                        this.versioningService.handleDisable(appName, this.target, deploymentContext.getActionReport());
                    }
                    if (this.domain.isCurrentInstanceMatchingTarget(this.target, appName, this.server.getName(), null)) {
                        this.deployment.deploy(this.deployment.getSniffersFromApp(app), deploymentContext);
                    } else {
                        this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.APPLICATION_PREPARED, deploymentContext), false);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        try {
                            this.deployment.registerAppInDomainXML(null, deploymentContext, t, true);
                        }
                        catch (TransactionFailure e) {
                            logger.warning("failed to create application ref for " + appName);
                        }
                    }
                    if (isVersionExpression || !DeploymentUtils.isDASTarget(this.target)) break block35;
                    var26_31 = null;
                    ** GOTO lbl145
                }
                paramMap = this.deployment.prepareInstanceDeployParamMap(deploymentContext);
                targets = new ArrayList<String>(Arrays.asList(commandParams.target.split(",")));
                ClusterOperationUtil.replicateCommand("_deploy", FailurePolicy.Error, FailurePolicy.Warn, targets, context, paramMap, this.habitat);
                ** GOTO lbl151
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error during creating application ref ", e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                var26_31 = null;
                try {
                    archive.close();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
                continue;
            }
            {
                catch (Throwable var25_33) {
                    var26_31 = null;
                    ** try [egrp 6[TRYBLOCK] [12 : 1129->1139)] { 
lbl140:
                    // 1 sources

                    archive.close();
                    throw var25_33;
lbl142:
                    // 1 sources

                    catch (IOException e) {
                        logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                    }
                    throw var25_33;
                }
lbl145:
                // 1 sources

                ** try [egrp 6[TRYBLOCK] [12 : 1129->1139)] { 
lbl146:
                // 1 sources

                archive.close();
                return;
lbl148:
                // 1 sources

                catch (IOException e) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
                return;
lbl151:
                // 1 sources

                var26_31 = null;
                try {}
                catch (IOException e) {}
                logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                continue;
                archive.close();
            }
        }
    }

    private void handleLifecycleModule(AdminCommandContext context, Transaction t) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        Application app = this.applications.getApplication(this.name);
        DeployCommandParameters commandParams = new DeployCommandParameters();
        commandParams.name = this.name;
        commandParams.target = this.target;
        commandParams.virtualservers = this.virtualservers;
        commandParams.enabled = this.enabled;
        DeploymentContextImpl lifecycleContext = new DeploymentContextImpl(report, logger2, null, commandParams, null);
        try {
            this.deployment.registerAppInDomainXML(null, lifecycleContext, t, true);
        }
        catch (Exception e) {
            report.failure(logger2, e.getMessage());
        }
        if (!DeploymentUtils.isDASTarget(this.target)) {
            ParameterMap paramMap = new ParameterMap();
            paramMap.add("DEFAULT", this.name);
            paramMap.add("target", this.target);
            paramMap.add("enabled", this.enabled.toString());
            if (this.virtualservers != null) {
                paramMap.add("virtualservers", this.virtualservers);
            }
            Properties appProps = app.getDeployProperties();
            paramMap.set("appprops", DeploymentUtils.propertiesValue(appProps, ':'));
            ArrayList<String> targets = new ArrayList<String>();
            targets.add(this.target);
            ClusterOperationUtil.replicateCommand("_lifecycle", FailurePolicy.Error, FailurePolicy.Warn, targets, context, paramMap, this.habitat);
        }
    }
}

