/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.Paths;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import com.sun.enterprise.util.cluster.windows.process.WindowsRemoteAsadmin;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.connect.Strings;
import org.glassfish.cluster.ssh.util.DcomInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRunnerDcom {
    private final Logger logger;
    private Node node;
    private WindowsRemoteFile authTokenFile;
    private String authTokenFilePath;
    private DcomInfo dcomInfo;

    public NodeRunnerDcom(Logger logger2) {
        this.logger = logger2;
    }

    public final int runAdminCommandOnRemoteNode(Node thisNode, StringBuilder output, List<String> args, List<String> stdinLines) throws SSHCommandExecutionException, IllegalArgumentException, UnsupportedOperationException {
        String humanreadable = null;
        try {
            this.node = thisNode;
            this.dcomInfo = new DcomInfo(this.node);
            ArrayList<String> fullcommand = new ArrayList<String>();
            WindowsRemoteAsadmin asadmin = this.dcomInfo.getAsadmin();
            if (stdinLines != null && !stdinLines.isEmpty()) {
                this.setupAuthTokenFile(fullcommand, stdinLines);
            }
            fullcommand.addAll(args);
            humanreadable = this.dcomInfo.getNadminPath() + " " + NodeRunnerDcom.commandListToString(fullcommand);
            String out = asadmin.run(fullcommand);
            output.append(out);
            this.logger.info(Strings.get("remote.command.summary", humanreadable, out));
            int n = this.determineStatus(args);
            return n;
        }
        catch (WindowsException ex) {
            throw new SSHCommandExecutionException(Strings.get("remote.command.error", ex.getMessage(), humanreadable), ex);
        }
        finally {
            this.teardownAuthTokenFile();
        }
    }

    private void trace(String s) {
        this.logger.fine(String.format("%s: %s", this.getClass().getSimpleName(), s));
    }

    private static String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }

    private void setupAuthTokenFile(List<String> cmd, List<String> stdin) throws WindowsException {
        WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(this.dcomInfo.getCredentials());
        this.authTokenFilePath = this.dcomInfo.getAsadminParentPath() + "\\token_" + System.nanoTime() + new Random().nextInt(1000);
        this.authTokenFilePath = this.createUniqueFilename(this.dcomInfo.getAsadminParentPath());
        this.authTokenFile = new WindowsRemoteFile(wrfs, this.authTokenFilePath);
        this.authTokenFile.copyFrom(stdin);
        cmd.add("--_auxinput");
        cmd.add(this.authTokenFilePath);
    }

    private void teardownAuthTokenFile() {
        if (this.authTokenFile != null) {
            try {
                this.authTokenFile.delete();
            }
            catch (WindowsException ex) {
                this.logger.warning(Strings.get("cant.delete", this.dcomInfo.getHost(), this.authTokenFilePath));
            }
        }
    }

    private String createUniqueFilename(String path) {
        String random = "" + System.nanoTime();
        if (random.length() > 16) {
            random = random.substring(random.length() - 16);
        }
        random = random + "" + new Random(System.currentTimeMillis()).nextInt(10000);
        return path + "\\DELETE_ME_" + random;
    }

    private int determineStatus(List<String> args) {
        if (args == null) {
            throw new NullPointerException();
        }
        if (args.size() < 2) {
            return 0;
        }
        String instanceName = args.get(args.size() - 1);
        if (this.isCommand(args, "_delete-instance-filesystem")) {
            try {
                String dir = Paths.getInstanceDirPath(this.node, instanceName);
                WindowsRemoteFile instanceDir = new WindowsRemoteFile(this.dcomInfo.getCredentials(), dir);
                return instanceDir.exists() ? 1 : 0;
            }
            catch (WindowsException ex) {
                return 0;
            }
        }
        if (this.isCommand(args, "_create-instance-filesystem")) {
            try {
                String dir = Paths.getDasPropsPath(this.node);
                WindowsRemoteFile dasProps = new WindowsRemoteFile(this.dcomInfo.getCredentials(), dir);
                if (dasProps.exists()) {
                    return 0;
                }
                dir = Paths.getInstanceDirPath(this.node, instanceName);
                WindowsRemoteFile instanceDir = new WindowsRemoteFile(this.dcomInfo.getCredentials(), dir);
                instanceDir.delete();
                return 1;
            }
            catch (WindowsException ex) {
                return 1;
            }
        }
        return 0;
    }

    private boolean isCommand(List<String> args, String cmd) {
        if (!StringUtils.ok(cmd)) {
            return false;
        }
        for (String arg : args) {
            if (arg == null || !arg.equals(cmd)) continue;
            return true;
        }
        return false;
    }
}

