/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ProxyImpl;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Dom;

@Produces(value={"text/html;qs=2", "application/json", "application/xml"})
@Path(value="domain/proxy/{path:.*}")
public class ManagementProxyResource {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Habitat habitat;

    @GET
    public ActionReportResult proxyRequest() {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("Proxied Data");
        ar.setSuccess();
        ActionReportResult result = new ActionReportResult(ar);
        Properties proxiedResponse = new ManagementProxyImpl().proxyRequest(this.uriInfo, this.habitat);
        ar.setExtraProperties(proxiedResponse);
        return result;
    }

    public void setEntity(Dom p) {
    }

    private static class ManagementProxyImpl
    extends ProxyImpl {
        private static int TARGET_INSTANCE_NAME_PATH_INDEX = 2;

        private ManagementProxyImpl() {
        }

        public UriBuilder constructTargetURLPath(UriInfo sourceUriInfo, URL responseURLReceivedFromTarget) {
            return sourceUriInfo.getBaseUriBuilder().replacePath(responseURLReceivedFromTarget.getFile());
        }

        public UriBuilder constructForwardURLPath(UriInfo sourceUriInfo) {
            List<PathSegment> sourcePathSegments = sourceUriInfo.getPathSegments();
            List<PathSegment> forwardPathSegmentsHead = sourcePathSegments.subList(0, TARGET_INSTANCE_NAME_PATH_INDEX - 1);
            List<PathSegment> forwardPathSegmentsTail = sourcePathSegments.subList(TARGET_INSTANCE_NAME_PATH_INDEX + 1, sourcePathSegments.size());
            UriBuilder forwardUriBuilder = sourceUriInfo.getBaseUriBuilder();
            for (PathSegment pathSegment : forwardPathSegmentsHead) {
                forwardUriBuilder.segment(pathSegment.getPath());
            }
            for (PathSegment pathSegment : forwardPathSegmentsTail) {
                forwardUriBuilder.segment(pathSegment.getPath());
            }
            return forwardUriBuilder;
        }

        public String extractTargetInstanceName(UriInfo uriInfo) {
            return uriInfo.getPathSegments().get(TARGET_INSTANCE_NAME_PATH_INDEX).getPath();
        }
    }
}

