/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.ValidationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.resources.TemplateResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.GetResultList;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBagResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Habitat habitat;
    protected List<Dom> entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PropertiesBagResource.class);

    @Path(value="{Name}/")
    public PropertyResource getProperty(@PathParam(value="Name") String id) {
        PropertyResource resource = this.resourceContext.getResource(PropertyResource.class);
        resource.setBeanByKey(this.getEntity(), id);
        return resource;
    }

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public Object get() {
        List<Dom> entities = this.getEntity();
        if (entities == null) {
            return new GetResultList(new ArrayList<Dom>(), "", new String[0][], new OptionsResult(Util.getResourceName(this.uriInfo)));
        }
        RestActionReporter ar = new RestActionReporter();
        ar.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ar.setActionDescription("property");
        ArrayList properties = new ArrayList();
        for (Dom child : entities) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", child.attribute("name"));
            entry.put("value", child.attribute("value"));
            String description = child.attribute("description");
            if (description != null) {
                entry.put("description", description);
            }
            properties.add(entry);
        }
        Properties extraProperties = new Properties();
        extraProperties.put("properties", properties);
        ar.setExtraProperties(extraProperties);
        return new ActionReportResult("properties", ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public ActionReportResult createProperties(List<Map<String, String>> data) {
        return this.clearThenSaveProperties(data);
    }

    @PUT
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public ActionReportResult replaceProperties(List<Map<String, String>> data) {
        return this.clearThenSaveProperties(data);
    }

    @DELETE
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded", "application/octet-stream"})
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public Response delete() {
        try {
            Map<String, Property> existing = this.getExistingProperties();
            this.deleteMissingProperties(existing, null);
            String successMessage = localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", this.uriInfo.getAbsolutePath());
            return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return ResourceUtil.getResponse(400, ex.getMessage(), this.requestHeaders, this.uriInfo);
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getEscapedPropertyName(String propName) {
        return propName.replaceAll("\\.", "\\\\.");
    }

    protected ActionReportResult clearThenSaveProperties(List<Map<String, String>> properties) {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("property");
        try {
            Map<String, Property> existing = this.getExistingProperties();
            this.deleteMissingProperties(existing, properties);
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            for (Map<String, String> property : properties) {
                boolean canSaveDesc;
                Property existingProp = existing.get(property.get("name"));
                String escapedName = this.getEscapedPropertyName(property.get("name"));
                String value = property.get("value");
                String description = property.get("description");
                String unescapedValue = value.replaceAll("\\\\", "");
                boolean bl = canSaveDesc = property.get("name").indexOf(".") == -1;
                if (existingProp == null || !unescapedValue.equals(existingProp.getValue())) {
                    data.put(escapedName, property.get("value"));
                    if (canSaveDesc && description != null) {
                        data.put(escapedName + ".description", description);
                    }
                }
                if (description == null || existingProp == null || "".equals(description) || description.equals(existingProp.getDescription()) || !canSaveDesc) continue;
                data.put(escapedName + ".description", description);
            }
            if (!data.isEmpty()) {
                Util.applyChanges(data, this.uriInfo, this.habitat);
            }
            String successMessage = localStrings.getLocalString("rest.resource.update.message", "\"{0}\" updated successfully.", this.uriInfo.getAbsolutePath());
            ar.setSuccess();
            ar.setMessage(successMessage);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                ar.setFailure();
                ar.setFailureCause(ex);
                ar.setMessage(ex.getLocalizedMessage());
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return new ActionReportResult("properties", ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    protected Map<String, Property> getExistingProperties() {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        for (Dom child : this.parent.nodeElements(this.tagName)) {
            Property property = (Property)child.createProxy();
            properties.put(property.getName(), property);
        }
        return properties;
    }

    protected void deleteMissingProperties(Map<String, Property> existing, List<Map<String, String>> properties) throws TransactionFailure {
        HashSet<String> propNames = new HashSet<String>();
        if (properties != null) {
            for (Map<String, String> property : properties) {
                propNames.add(property.get("name"));
            }
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (Property existingProp : existing.values()) {
            if (propNames.contains(existingProp.getName())) continue;
            String escapedName = this.getEscapedPropertyName(existingProp.getName());
            data.put(escapedName, "");
        }
        if (!data.isEmpty()) {
            Util.applyChanges(data, this.uriInfo, this.habitat);
        }
    }

    public void setEntity(List<Dom> p) {
        this.entity = p;
    }

    public List<Dom> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        if (parent == null) {
            return;
        }
        this.parent = parent;
        this.tagName = tagName;
        this.entity = parent.nodeElements(tagName);
    }

    public static class PropertyResource
    extends TemplateResource {
        public String getDeleteCommand() {
            return "GENERIC-DELETE";
        }
    }
}

