/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.common.ActionReporter;
import java.beans.PropertyVetoException;
import org.glassfish.admin.rest.cli.CreatePrincipalCommand;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="__delete-principal")
@Scoped(value=PerLookup.class)
public class DeletePrincipalCommand
extends CreatePrincipalCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeletePrincipalCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReporter report = (ActionReporter)context.getActionReport();
        SecurityMap map = DeletePrincipalCommand.getSpecifiedSecurityMapForPool(this.ccPools, this.poolName, this.mapName);
        if (map == null) {
            report.setMessage(localStrings.getLocalString("create.principal.invalid.map", "A security map named {0} could not be found for connector connection pool {1}. Please check the map and pool names.", this.mapName, this.poolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<SecurityMap>(){

                @Override
                public Object run(SecurityMap map) throws PropertyVetoException, TransactionFailure {
                    if (DeletePrincipalCommand.this.principals != null) {
                        for (String p : DeletePrincipalCommand.this.principals) {
                            map.getPrincipal().remove(p);
                        }
                    }
                    return "";
                }
            }, map);
        }
        catch (TransactionFailure tfe) {
            Object[] params = new Object[]{this.mapName, this.poolName};
            report.setMessage(localStrings.getLocalString("create.connector.security.map.fail", "Unable to create connector security map {0} for connector connection pool {1} ", params) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

