/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.tables.UniqueConstraintMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetadata
extends ORMetadata {
    private DatabaseTable m_databaseTable = new DatabaseTable();
    private List<UniqueConstraintMetadata> m_uniqueConstraints = new ArrayList<UniqueConstraintMetadata>();
    private String m_name;
    private String m_schema;
    private String m_catalog;
    private String m_creationSuffix;

    public TableMetadata() {
        super("<table>");
    }

    public TableMetadata(MetadataAnnotation table, MetadataAccessor accessor) {
        super(table, accessor);
        if (table != null) {
            this.m_name = (String)table.getAttribute("name");
            this.m_schema = (String)table.getAttribute("schema");
            this.m_catalog = (String)table.getAttribute("catalog");
            for (Object uniqueConstraint : (Object[])table.getAttributeArray("uniqueConstraints")) {
                this.m_uniqueConstraints.add(new UniqueConstraintMetadata((MetadataAnnotation)uniqueConstraint, accessor));
            }
        }
    }

    protected TableMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TableMetadata) {
            TableMetadata table = (TableMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, table.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_schema, table.getSchema())) {
                return false;
            }
            if (!this.valuesMatch(this.m_catalog, table.getCatalog())) {
                return false;
            }
            if (!this.valuesMatch(this.m_creationSuffix, table.getCreationSuffix())) {
                return false;
            }
            return this.valuesMatch(this.m_uniqueConstraints, table.getUniqueConstraints());
        }
        return false;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getCatalogContext() {
        return "metadata_default_table_catalog";
    }

    public String getCreationSuffix() {
        return this.m_creationSuffix;
    }

    public DatabaseTable getDatabaseTable() {
        return this.m_databaseTable;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameContext() {
        return "metadata_default_table_name";
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getSchemaContext() {
        return "metadata_default_table_schema";
    }

    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.m_uniqueConstraints;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        for (UniqueConstraintMetadata jcm : this.m_uniqueConstraints) {
            this.initXMLObject(jcm, accessibleObject);
        }
    }

    public void processUniqueConstraints() {
        if (this.m_uniqueConstraints != null) {
            for (UniqueConstraintMetadata uniqueConstraint : this.m_uniqueConstraints) {
                if (uniqueConstraint.hasName() && this.m_databaseTable.getUniqueConstraints().containsKey(uniqueConstraint.getName())) {
                    throw ValidationException.multipleUniqueConstraintsWithSameNameSpecified(uniqueConstraint.getName(), this.getName(), this.getLocation());
                }
                this.m_databaseTable.addUniqueConstraints(uniqueConstraint.getName(), uniqueConstraint.getColumnNames());
            }
        }
    }

    public void setFullyQualifiedTableName(String fullyQualifiedTableName) {
        this.m_databaseTable.setPossiblyQualifiedName(fullyQualifiedTableName, Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setCreationSuffix(String creationSuffix) {
        this.m_creationSuffix = creationSuffix;
    }

    public void setDatabaseTable(DatabaseTable databaseTable) {
        this.m_databaseTable = databaseTable;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setUniqueConstraints(List<UniqueConstraintMetadata> uniqueConstraints) {
        this.m_uniqueConstraints = uniqueConstraints;
    }

    public void setUseDelimiters(boolean useDelimiters) {
        this.m_databaseTable.setUseDelimiters(useDelimiters);
    }
}

