/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataFactory {
    public static boolean ALLOW_JDK = false;
    protected Map<String, MetadataClass> m_metadataClasses;
    protected MetadataLogger m_logger;
    protected ClassLoader m_loader;

    public MetadataFactory(MetadataLogger logger2, ClassLoader loader) {
        this.m_logger = logger2;
        this.m_loader = loader;
        this.m_metadataClasses = new HashMap<String, MetadataClass>();
        this.m_metadataClasses.put("void", new MetadataClass(this, Void.TYPE));
        this.m_metadataClasses.put("", new MetadataClass(this, Void.TYPE));
        this.m_metadataClasses.put(null, new MetadataClass(this, Void.TYPE));
        this.m_metadataClasses.put("int", new MetadataClass(this, Integer.TYPE));
        this.m_metadataClasses.put("long", new MetadataClass(this, Long.TYPE));
        this.m_metadataClasses.put("short", new MetadataClass(this, Short.TYPE));
        this.m_metadataClasses.put("boolean", new MetadataClass(this, Boolean.TYPE));
        this.m_metadataClasses.put("float", new MetadataClass(this, Float.TYPE));
        this.m_metadataClasses.put("double", new MetadataClass(this, Double.TYPE));
        this.m_metadataClasses.put("char", new MetadataClass(this, Character.TYPE));
        this.m_metadataClasses.put("byte", new MetadataClass(this, Byte.TYPE));
    }

    public void addMetadataClass(MetadataClass metadataClass) {
        this.addMetadataClass(metadataClass.getName(), metadataClass);
    }

    public void addMetadataClass(String name, MetadataClass metadataClass) {
        this.m_metadataClasses.put(name, metadataClass);
    }

    public ClassLoader getLoader() {
        return this.m_loader;
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    protected Map<String, MetadataClass> getMetadataClasses() {
        return this.m_metadataClasses;
    }

    protected boolean metadataClassExists(String className) {
        return this.m_metadataClasses.containsKey(className);
    }

    public abstract MetadataClass getMetadataClass(String var1);

    public abstract MetadataClass getMetadataClass(String var1, boolean var2);

    public void setLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public void setLogger(MetadataLogger logger2) {
        this.m_logger = logger2;
    }

    public abstract void resolveGenericTypes(MetadataClass var1, List<String> var2, MetadataClass var3, MetadataDescriptor var4);
}

