/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;

public class ExceptionMessageGenerator {
    public static String buildMessage(Class exceptionClass, int errorNumber, Object[] arguments) {
        String CR2 = System.getProperty("line.separator");
        String shortClassName = Helper.getShortClassName(exceptionClass);
        String message = "";
        ResourceBundle bundle2 = null;
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != null) continue;
            arguments[i] = "null";
        }
        bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n." + shortClassName + "Resource", Locale.getDefault(), ExceptionMessageGenerator.class.getClassLoader());
        try {
            message = bundle2.getString(String.valueOf(errorNumber));
        }
        catch (MissingResourceException mre) {
            bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.class.getClassLoader());
            String noTranslationMessage = bundle2.getString("NoExceptionTranslationForThisLocale");
            Object[] args = new Object[]{CR2};
            return ExceptionMessageGenerator.format(message, arguments) + ExceptionMessageGenerator.format(noTranslationMessage, args);
        }
        return ExceptionMessageGenerator.format(message, arguments);
    }

    protected static String format(String message, Object[] arguments) {
        try {
            return MessageFormat.format(message, arguments);
        }
        catch (Exception ex) {
            ResourceBundle bundle2 = null;
            bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.class.getClassLoader());
            String errorMessage = bundle2.getString("ErrorFormattingMessage");
            Vector<Object> vec = new Vector<Object>();
            if (arguments != null) {
                for (int index = 0; index < arguments.length; ++index) {
                    try {
                        vec.add(arguments[index].toString());
                        continue;
                    }
                    catch (Exception ex2) {
                        vec.add(ex2);
                    }
                }
            }
            return MessageFormat.format(errorMessage, message, vec);
        }
    }

    public static String getHeader(String headerLabel) {
        ResourceBundle bundle2 = null;
        try {
            bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.class.getClassLoader());
            return bundle2.getString(headerLabel);
        }
        catch (MissingResourceException mre) {
            return "[" + headerLabel + "]";
        }
    }
}

