/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.ManyToManyQueryKey;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.sessions.Record;

public class QueryException
extends ValidationException {
    protected transient DatabaseQuery query;
    protected transient AbstractRecord queryArguments;
    public static final int ADDITIONAL_SIZE_QUERY_NOT_SPECIFIED = 6001;
    public static final int AGGREGATE_OBJECT_CANNOT_BE_DELETED = 6002;
    public static final int ARGUMENT_SIZE_MISMATCH_IN_QUERY_AND_QUERY_DEFINITION = 6003;
    public static final int BACKUP_CLONE_IS_ORIGINAL_FROM_PARENT = 6004;
    public static final int BACKUP_CLONE_IS_ORIGINAL_FROM_SELF = 6005;
    public static final int BATCH_READING_NOT_SUPPORTED = 6006;
    public static final int DESCRIPTOR_IS_MISSING = 6007;
    public static final int DESCRIPTOR_IS_MISSING_FOR_NAMED_QUERY = 6008;
    public static final int INCORRECT_SIZE_QUERY_FOR_CURSOR_STREAM = 6013;
    public static final int INVALID_QUERY = 6014;
    public static final int INVALID_QUERY_KEY_IN_EXPRESSION = 6015;
    public static final int INVALID_QUERY_ON_SERVER_SESSION = 6016;
    public static final int NO_CONCRETE_CLASS_INDICATED = 6020;
    public static final int NO_CURSOR_SUPPORT = 6021;
    public static final int OBJECT_TO_INSERT_IS_EMPTY = 6023;
    public static final int OBJECT_TO_MODIFY_NOT_SPECIFIED = 6024;
    public static final int QUERY_NOT_DEFINED = 6026;
    public static final int QUERY_SENT_TO_INACTIVE_UNIT_OF_WORK = 6027;
    public static final int READ_BEYOND_QUERY = 6028;
    public static final int REFERENCE_CLASS_MISSING = 6029;
    public static final int REFRESH_NOT_POSSIBLE_WITHOUT_CACHE = 6030;
    public static final int SIZE_ONLY_SUPPORTED_ON_EXPRESSION_QUERIES = 6031;
    public static final int SQL_STATEMENT_NOT_SET_PROPERLY = 6032;
    public static final int INVALID_QUERY_ITEM = 6034;
    public static final int SELECTION_OBJECT_CANNOT_BE_NULL = 6041;
    public static final int UNNAMED_QUERY_ON_SESSION_BROKER = 6042;
    public static final int REPORT_RESULT_WITHOUT_PKS = 6043;
    public static final int NULL_PRIMARY_KEY_IN_BUILDING_OBJECT = 6044;
    public static final int NO_DESCRIPTOR_FOR_SUBCLASS = 6045;
    public static final int CANNOT_DELETE_READ_ONLY_OBJECT = 6046;
    public static final int INVALID_OPERATOR = 6047;
    public static final int ILLEGAL_USE_OF_GETFIELD = 6048;
    public static final int ILLEGAL_USE_OF_GETTABLE = 6049;
    public static final int REPORT_QUERY_RESULT_SIZE_MISMATCH = 6050;
    public static final int CANNOT_CACHE_PARTIAL_OBJECT = 6051;
    public static final int OUTER_JOIN_ONLY_VALID_FOR_ONE_TO_ONE = 6052;
    public static final int CANNOT_ADD_TO_CONTAINER = 6054;
    public static final int METHOD_INVOCATION_FAILED = 6055;
    public static final int CANNOT_CREATE_CLONE = 6056;
    public static final int METHOD_NOT_VALID = 6057;
    public static final int METHOD_DOES_NOT_EXIST_IN_CONTAINER_CLASS = 6058;
    public static final int COULD_NOT_INSTANTIATE_CONTAINER_CLASS = 6059;
    public static final int MAP_KEY_NOT_COMPARABLE = 6060;
    public static final int CANNOT_ACCESS_METHOD_ON_OBJECT = 6061;
    public static final int CALLED_METHOD_THREW_EXCEPTION = 6062;
    public static final int INVALID_OPERATION = 6063;
    public static final int CANNOT_REMOVE_FROM_CONTAINER = 6064;
    public static final int CANNOT_ADD_ELEMENT = 6065;
    public static final int BACKUP_CLONE_DELETED = 6066;
    public static final int CANNOT_ACCESS_FIELD_ON_OBJECT = 6067;
    public static final int CANNOT_COMPARE_TABLES_IN_EXPRESSION = 6068;
    public static final int INVALID_TABLE_FOR_FIELD_IN_EXPRESSION = 6069;
    public static final int INVALID_USE_OF_TO_MANY_QUERY_KEY_IN_EXPRESSION = 6070;
    public static final int INVALID_USE_OF_ANY_OF_IN_EXPRESSION = 6071;
    public static final int CANNOT_QUERY_ACROSS_VARIABLE_ONE_TO_ONE_MAPPING = 6072;
    public static final int ILL_FORMED_EXPRESSION = 6073;
    public static final int CANNOT_CONFORM_EXPRESSION = 6074;
    public static final int INVALID_OPERATOR_FOR_OBJECT_EXPRESSION = 6075;
    public static final int UNSUPPORTED_MAPPING_FOR_OBJECT_COMPARISON = 6076;
    public static final int OBJECT_COMPARISON_CANNOT_BE_PARAMETERIZED = 6077;
    public static final int INCORRECT_CLASS_FOR_OBJECT_COMPARISON = 6078;
    public static final int CANNOT_COMPARE_TARGET_FOREIGN_KEYS_TO_NULL = 6079;
    public static final int INVALID_DATABASE_CALL = 6080;
    public static final int INVALID_DATABASE_ACCESSOR = 6081;
    public static final int METHOD_DOES_NOT_EXIST_ON_EXPRESSION = 6082;
    public static final int IN_CANNOT_BE_PARAMETERIZED = 6083;
    public static final int REDIRECTION_CLASS_OR_METHOD_NOT_SET = 6084;
    public static final int REDIRECTION_METHOD_NOT_DEFINED_CORRECTLY = 6085;
    public static final int REDIRECTION_METHOD_ERROR = 6086;
    public static final int EXAMPLE_AND_REFERENCE_OBJECT_CLASS_MISMATCH = 6087;
    public static final int NO_ATTRIBUTES_FOR_REPORT_QUERY = 6088;
    public static final int NO_EXPRESSION_BUILDER_CLASS_FOUND = 6089;
    public static final int CANNOT_SET_REPORT_QUERY_TO_CHECK_CACHE_ONLY = 6090;
    public static final int TYPE_MISMATCH_BETWEEN_ATTRIBUTE_AND_CONSTANT_ON_EXPRESSION = 6091;
    public static final int MUST_INSTANTIATE_VALUEHOLDERS = 6092;
    public static final int INVALID_TYPE_EXPRESSION = 6093;
    public static final int PARAMETER_NAME_MISMATCH = 6094;
    public static final int CLONE_METHOD_REQUIRED = 6095;
    public static final int CLONE_METHOD_INACCESSIBLE = 6096;
    public static final int CLONE_METHOD_THORW_EXCEPTION = 6097;
    public static final int UNEXPECTED_INVOCATION = 6098;
    public static final int JOINING_ACROSS_INHERITANCE_WITH_MULTIPLE_TABLES = 6099;
    public static final int MULTIPLE_ROWS_DETECTED_FROM_SINGLE_OBJECT_READ = 6100;
    public static final int HISTORICAL_QUERIES_MUST_PRESERVE_GLOBAL_CACHE = 6101;
    public static final int HISTORICAL_QUERIES_ONLY_SUPPORTED_ON_ORACLE = 6102;
    public static final int INVALID_QUERY_ON_HISTORICAL_SESSION = 6103;
    public static final int OBJECT_DOES_NOT_EXIST_IN_CACHE = 6104;
    public static final int MUST_USE_CURSOR_STREAM_POLICY = 6105;
    public static final int CLASS_PK_DOES_NOT_EXIST_IN_CACHE = 6106;
    public static final int UPDATE_STATEMENTS_NOT_SPECIFIED = 6107;
    public static final int INHERITANCE_WITH_MULTIPLE_TABLES_NOT_SUPPORTED = 6108;
    public static final int QUERY_FETCHGROUP_NOT_DEFINED_IN_DESCRIPTOR = 6109;
    public static final int CANNOT_CONFORM_UNFETCHED_ATTRIBUTE = 6110;
    public static final int FETCH_GROUP_ATTRIBUTE_NOT_MAPPED = 6111;
    public static final int FETCH_GROUP_NOT_SUPPORT_ON_REPORT_QUERY = 6112;
    public static final int FETCH_GROUP_NOT_SUPPORT_ON_PARTIAL_ATTRIBUTE_READING = 6113;
    public static final int FETCHGROUP_VALID_ONLY_IF_FETCHGROUP_MANAGER_IN_DESCRIPTOR = 6114;
    public static final int ISOLATED_QUERY_EXECUTED_ON_SERVER_SESSION = 6115;
    public static final int NO_CALL_OR_INTERACTION_SPECIFIED = 6116;
    public static final int CANNOT_CACHE_CURSOR_RESULTS_ON_QUERY = 6117;
    public static final int CANNOT_CACHE_ISOLATED_DATA_ON_QUERY = 6118;
    public static final int MAPPING_FOR_EXPRESSION_DOES_NOT_SUPPORT_JOINING = 6119;
    public static final int SPECIFIED_PARTIAL_ATTRIBUTE_DOES_NOT_EXIST = 6120;
    public static final int INVALID_BUILDER_IN_QUERY = 6121;
    public static final int INVALID_EXPRESSION = 6122;
    public static final int INVALID_CONTAINER_CLASS = 6123;
    public static final int INCORRECT_QUERY_FOUND = 6124;
    public static final int CLEAR_QUERY_RESULTS_NOT_SUPPORTED = 6125;
    public static final int CANNOT_CONFORM_AND_CACHE_QUERY_RESULTS = 6126;
    public static final int REFLECTIVE_CALL_ON_TOPLINK_CLASS_FAILED = 6127;
    public static final int BATCH_READING_NOT_SUPPORTED_WITH_CALL = 6128;
    public static final int REFRESH_NOT_POSSIBLE_WITH_CHECK_CACHE_ONLY = 6129;
    public static final int DISCRIMINATOR_COLUMN_NOT_SELECTED = 6130;
    public static final int DELETE_ALL_QUERY_SPECIFIES_OBJECTS_BUT_NOT_SELECTION_CRITERIA = 6131;
    public static final int NAMED_ARGUMENT_NOT_FOUND_IN_QUERY_PARAMETERS = 6132;
    public static final int UPDATE_ALL_QUERY_ADD_UPDATE_FIELD_IS_NULL = 6133;
    public static final int UPDATE_ALL_QUERY_ADD_UPDATE_DOES_NOT_DEFINE_FIELD = 6134;
    public static final int UPDATE_ALL_QUERY_ADD_UPDATE_DEFINES_WRONG_FIELD = 6135;
    public static final int POLYMORPHIC_REPORT_ITEM_NOT_SUPPORTED = 6136;
    public static final int EXCEPTION_WHILE_USING_CONSTRUCTOR_EXPRESSION = 6137;
    public static final int TEMP_TABLES_NOT_SUPPORTED = 6138;
    public static final int MAPPING_FOR_FIELDRESULT_NOT_FOUND = 6139;
    public static final int JOIN_EXPRESSIONS_NOT_APPLICABLE_ON_NON_OBJECT_REPORT_ITEM = 6140;
    public static final int CLASS_NOT_FOUND_WHILE_USING_QUERY_HINT = 6141;
    public static final int QUERY_HINT_NAVIGATED_ILLEGAL_RELATIONSHIP = 6142;
    public static final int QUERY_HINT_NAVIGATED_NON_EXISTANT_RELATIONSHIP = 6143;
    public static final int QUERY_HINT_DID_NOT_CONTAIN_ENOUGH_TOKENS = 6144;
    public static final int DISTINCT_COUNT_ON_OUTER_JOINED_COMPOSITE_PK = 6145;
    public static final int QUERY_HINT_CONTAINED_INVALID_INTEGER_VALUE = 6146;
    public static final int EXPRESSION_DOES_NOT_SUPPORT_PARTIAL_ATTRIBUTE_READING = 6147;
    public static final int ADD_ARGS_NOT_SUPPORTED = 6148;
    public static final int UNNAMED_ARG_NOT_SUPPORTED = 6149;
    public static final int MAP_KEY_IS_NULL = 6150;
    public static final int UNABLE_TO_SET_REDIRECTOR_FROM_HINT = 6151;
    public static final int ERROR_INSTANTIATING_CLASS_FOR_QUERY_HINT = 6152;
    public static final int COMPATIBLE_TYPE_NOT_SET = 6153;
    public static final int TYPE_NAME_NOT_SET = 6154;
    public static final int NO_RELATION_TABLE_IN_MANY_TO_MANY_QUERY_KEY = 6155;
    public static final int EXCEPTION_WHILE_READING_MAP_KEY = 6156;
    public static final int CANNOT_ADD_ELEMENT_WITHOUT_KEY_TO_MAP = 6157;
    public static final int CANNOT_UNWRAP_NON_MAP_MEMBERS = 6158;
    public static final int NO_MAPPING_FOR_MAP_ENTRY_EXPRESSION = 6159;
    public static final int MAP_ENTRY_EXPRESSION_FOR_NON_COLLECTION = 6160;
    public static final int MAP_ENTRY_EXPRESSION_FOR_NON_MAP = 6161;
    public static final int LIST_ORDER_FIELD_WRONG_VALUE = 6162;
    public static final int INDEX_REQUIRES_QUERY_KEY_EXPRESSION = 6163;
    public static final int INDEX_REQUIRES_COLLECTION_MAPPING_WITH_LIST_ORDER_FIELD = 6164;
    public static final int BATCH_IN_REQUIRES_SINGLETON_PK = 6165;
    public static final int COULD_NOT_FIND_CAST_DESCRIPTOR = 6166;
    public static final int CAST_MUST_USE_INHERITANCE = 6167;
    public static final int PREPARE_FAILED = 6168;
    public static final int ORIGINAL_QUERY_MUST_USE_IN = 6169;
    public static final int PARTIONING_NOT_SUPPORTED = 6171;
    public static final int MISSING_CONNECTION_POOL = 6172;
    public static final int FAILOVER_FAILED = 6173;
    public static final int MISSING_CONTEXT_PROPERTY_FOR_PROPERTY_PARAMETER_EXPRESSION = 6174;
    public static final int NATIVE_SQL_QUERIES_ARE_DISABLED = 6175;

    protected QueryException(String message) {
        super(message);
    }

    protected QueryException(String message, DatabaseQuery query) {
        super(message);
        this.query = query;
    }

    protected QueryException(String message, DatabaseQuery query, Exception internalException) {
        super(message, internalException);
        this.query = query;
    }

    public static QueryException additionalSizeQueryNotSpecified(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6001, args), query);
        queryException.setErrorCode(6001);
        return queryException;
    }

    public static QueryException aggregateObjectCannotBeDeletedOrWritten(ClassDescriptor descriptor, DatabaseQuery query) {
        Object[] args = new Object[]{descriptor.toString(), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6002, args), query);
        queryException.setErrorCode(6002);
        return queryException;
    }

    public static QueryException argumentSizeMismatchInQueryAndQueryDefinition(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6003, args), query);
        queryException.setErrorCode(6003);
        return queryException;
    }

    public static QueryException missingContextPropertyForPropertyParameterExpression(DatabaseQuery query, String argumentName) {
        Object[] args = new Object[]{argumentName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6174, args), query);
        queryException.setErrorCode(6174);
        return queryException;
    }

    public static QueryException namedArgumentNotFoundInQueryParameters(String argumentName) {
        Object[] args = new Object[]{argumentName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6132, args));
        queryException.setErrorCode(6132);
        return queryException;
    }

    public static QueryException nativeSQLQueriesAreDisabled(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6175, args), query);
        queryException.setErrorCode(6175);
        return queryException;
    }

    public static QueryException backupCloneIsDeleted(Object clone) {
        Object[] args = new Object[]{clone, clone.getClass(), System.identityHashCode(clone), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6066, args));
        queryException.setErrorCode(6066);
        return queryException;
    }

    public static QueryException backupCloneIsOriginalFromParent(Object clone) {
        Object[] args = new Object[]{clone, clone.getClass(), System.identityHashCode(clone), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6004, args));
        queryException.setErrorCode(6004);
        return queryException;
    }

    public static QueryException backupCloneIsOriginalFromSelf(Object clone) {
        Object[] args = new Object[]{clone, clone.getClass(), System.identityHashCode(clone), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6005, args));
        queryException.setErrorCode(6005);
        return queryException;
    }

    public static QueryException batchReadingNotSupported(DatabaseMapping mapping, DatabaseQuery query) {
        Object[] args = new Object[]{mapping};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6006, args), query);
        queryException.setErrorCode(6006);
        return queryException;
    }

    public static QueryException batchReadingNotSupported(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6128, args), query);
        queryException.setErrorCode(6128);
        return queryException;
    }

    public static QueryException calledMethodThrewException(Method aMethod, Object object, Exception ex) {
        Object[] args = new Object[]{aMethod, object, object.getClass()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6062, args));
        queryException.setErrorCode(6062);
        queryException.setInternalException(ex);
        return queryException;
    }

    public static ValidationException cannotAccessFieldOnObject(Field aField, Object anObject) {
        Object[] args = new Object[]{aField, anObject, anObject.getClass()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6067, args));
        validationException.setErrorCode(6067);
        return validationException;
    }

    public static ValidationException cannotAccessMethodOnObject(Method aMethod, Object anObject) {
        Object[] args = new Object[]{aMethod, anObject, anObject.getClass()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6061, args));
        validationException.setErrorCode(6061);
        return validationException;
    }

    public static QueryException cannotAddElement(Object anObject, Object aContainer, Exception ex) {
        Object[] args = new Object[]{anObject, anObject.getClass(), aContainer.getClass()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6065, args));
        queryException.setErrorCode(6065);
        queryException.setInternalException(ex);
        return queryException;
    }

    public static QueryException cannotAddToContainer(Object anObject, Object aContainer, ContainerPolicy policy) {
        Object[] args = new Object[]{anObject, anObject.getClass(), aContainer.getClass(), policy};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6054, args));
        queryException.setErrorCode(6054);
        return queryException;
    }

    public static QueryException cannotCacheCursorResultsOnQuery(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6117, args));
        queryException.setQuery(query);
        queryException.setErrorCode(6117);
        return queryException;
    }

    public static QueryException cannotCacheIsolatedDataOnQuery(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6118, args));
        queryException.setQuery(query);
        queryException.setErrorCode(6118);
        return queryException;
    }

    public static QueryException cannotCachePartialObjects(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6051, args));
        queryException.setQuery(query);
        queryException.setErrorCode(6051);
        return queryException;
    }

    public static QueryException cannotCompareTablesInExpression(Object data) {
        Object[] args = new Object[]{data};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6068, args));
        queryException.setErrorCode(6068);
        return queryException;
    }

    public static QueryException cannotCompareTargetForeignKeysToNull(Expression expression, Object value, DatabaseMapping mapping) {
        Object[] args = new Object[]{expression, mapping, value, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6079, args));
        queryException.setErrorCode(6079);
        return queryException;
    }

    public static QueryException cannotConformAndCacheQueryResults(ReadQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6126, args), query);
        queryException.setErrorCode(6126);
        return queryException;
    }

    public static QueryException cannotConformExpression() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6074, args));
        queryException.setErrorCode(6074);
        return queryException;
    }

    public static QueryException cannotCreateClone(ContainerPolicy policy, Object anObject) {
        Object[] args = new Object[]{anObject, anObject.getClass(), policy};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6056, args));
        queryException.setErrorCode(6056);
        return queryException;
    }

    public static QueryException cannotDeleteReadOnlyObject(Object anObject) {
        Object[] args = new Object[]{anObject.getClass().toString()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6046, args));
        queryException.setErrorCode(6046);
        return queryException;
    }

    public static QueryException cannotQueryAcrossAVariableOneToOneMapping(DatabaseMapping mapping, ClassDescriptor descriptor) {
        Object[] args = new Object[]{descriptor.toString(), mapping.toString(), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6072, args));
        queryException.setErrorCode(6072);
        return queryException;
    }

    public static QueryException cannotRemoveFromContainer(Object anObject, Object aContainer, ContainerPolicy policy) {
        Object[] args = new Object[]{anObject, anObject.getClass(), aContainer.getClass(), policy};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6064, args));
        queryException.setErrorCode(6064);
        return queryException;
    }

    public static QueryException cannotSetShouldCheckCacheOnlyOnReportQuery() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6090, args));
        queryException.setErrorCode(6090);
        return queryException;
    }

    public static QueryException couldNotInstantiateContainerClass(Class aClass, Exception exception) {
        Object[] args = new Object[]{aClass.toString()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6059, args));
        queryException.setErrorCode(6059);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException descriptorIsMissing(Class referenceClass, DatabaseQuery query) {
        Object[] args = new Object[]{referenceClass};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6007, args), query);
        queryException.setErrorCode(6007);
        return queryException;
    }

    public static QueryException descriptorIsMissingForNamedQuery(Class domainClass, String queryName) {
        Object[] args = new Object[]{domainClass.getName(), queryName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6008, args));
        queryException.setErrorCode(6008);
        return queryException;
    }

    public static QueryException discriminatorColumnNotSelected(String expectedColumn, String sqlResultSetMapping) {
        Object[] args = new Object[]{expectedColumn, sqlResultSetMapping};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6130, args));
        queryException.setErrorCode(6130);
        return queryException;
    }

    public static QueryException exampleAndReferenceObjectClassMismatch(Class exampleObjectClass, Class referenceObjectClass, DatabaseQuery query) {
        Object[] args = new Object[]{exampleObjectClass, referenceObjectClass};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6087, args));
        queryException.setErrorCode(6087);
        queryException.setQuery(query);
        return queryException;
    }

    public static QueryException exceptionWhileUsingConstructorExpression(Exception thrownException, DatabaseQuery query) {
        Object[] args = new Object[]{thrownException};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6137, args));
        queryException.setErrorCode(6137);
        queryException.setQuery(query);
        return queryException;
    }

    public String getMessage() {
        if (this.getQuery() == null) {
            return super.getMessage();
        }
        return super.getMessage() + QueryException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("QueryHeader") + this.getQuery().toString();
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public Record getQueryArgumentsRecord() {
        return this.queryArguments;
    }

    public static QueryException illegalUseOfGetField(Object data) {
        Object[] args = new Object[]{data};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6048, args));
        queryException.setErrorCode(6048);
        return queryException;
    }

    public static QueryException illegalUseOfGetTable(Object data) {
        Object[] args = new Object[]{data};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6049, args));
        queryException.setErrorCode(6049);
        return queryException;
    }

    public static QueryException illFormedExpression(Expression queryKey) {
        Object[] args = new Object[]{queryKey};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6073, args));
        queryException.setErrorCode(6073);
        return queryException;
    }

    public static QueryException inCannotBeParameterized(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException exception = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6083, args), query);
        exception.setErrorCode(6083);
        return exception;
    }

    public static QueryException incorrectClassForObjectComparison(Expression expression, Object value, DatabaseMapping mapping) {
        Object[] args = new Object[]{expression, mapping, value, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6078, args));
        queryException.setErrorCode(6078);
        return queryException;
    }

    public static QueryException incorrectSizeQueryForCursorStream(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6013, args), query);
        queryException.setErrorCode(6013);
        return queryException;
    }

    public static QueryException incorrectQueryObjectFound(DatabaseQuery query, Class expectedQueryClass) {
        Object[] args = new Object[]{expectedQueryClass, query.getClass()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6124, args), query);
        queryException.setErrorCode(6124);
        return queryException;
    }

    public static QueryException invalidContainerClass(Class containerGiven, Class containerRequired) {
        Object[] args = new Object[]{containerGiven, containerRequired};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6123, args));
        queryException.setErrorCode(6123);
        return queryException;
    }

    public static QueryException invalidDatabaseAccessor(Accessor accessor) {
        Object[] args = new Object[]{accessor};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6081, args));
        queryException.setErrorCode(6081);
        return queryException;
    }

    public static QueryException invalidDatabaseCall(Call call) {
        Object[] args = new Object[]{call};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6080, args));
        queryException.setErrorCode(6080);
        return queryException;
    }

    public static QueryException invalidExpressionForQueryItem(Expression expression, DatabaseQuery owner) {
        Object[] args = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6034, args), owner);
        queryException.setErrorCode(6034);
        return queryException;
    }

    public static QueryException invalidOperation(String operation) {
        Object[] args = new Object[]{operation};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6063, args));
        queryException.setErrorCode(6063);
        return queryException;
    }

    public static QueryException invalidOperator(Object data) {
        Object[] args = new Object[]{data};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6047, args));
        queryException.setErrorCode(6047);
        return queryException;
    }

    public static QueryException invalidOperatorForObjectComparison(Expression expression) {
        Object[] args = new Object[]{expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6075, args));
        queryException.setErrorCode(6075);
        return queryException;
    }

    public static QueryException invalidQuery(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6014, args), query);
        queryException.setErrorCode(6014);
        return queryException;
    }

    public static QueryException invalidBuilderInQuery(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6121, args), query);
        queryException.setErrorCode(6121);
        return queryException;
    }

    public static QueryException invalidQueryKeyInExpression(Object data) {
        Object[] args = new Object[]{data};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6015, args));
        queryException.setErrorCode(6015);
        return queryException;
    }

    public static QueryException invalidExpression(Object expression) {
        Object[] args = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6122, args));
        queryException.setErrorCode(6122);
        return queryException;
    }

    public static QueryException mappingForExpressionDoesNotSupportJoining(Object expression) {
        Object[] args = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6119, args));
        queryException.setErrorCode(6119);
        return queryException;
    }

    public static QueryException mappingForFieldResultNotFound(String[] attributeNames, int currentString) {
        String attributeName = "";
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeName = attributeName + attributeNames[i];
        }
        Object[] args = new Object[]{attributeName, attributeNames[currentString]};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6139, args));
        queryException.setErrorCode(6139);
        return queryException;
    }

    public static QueryException invalidQueryOnHistoricalSession(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6103, args), query);
        queryException.setErrorCode(6103);
        return queryException;
    }

    public static QueryException invalidQueryOnServerSession(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6016, args), query);
        queryException.setErrorCode(6016);
        return queryException;
    }

    public static QueryException invalidTableForFieldInExpression(Object data) {
        Object[] args = new Object[]{data};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6069, args));
        queryException.setErrorCode(6069);
        return queryException;
    }

    public static QueryException invalidTypeExpression(Object expression) {
        Object[] args = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6093, args));
        queryException.setErrorCode(6093);
        return queryException;
    }

    public static QueryException invalidUseOfAnyOfInExpression(Object data) {
        Object[] args = new Object[]{data};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6071, args));
        queryException.setErrorCode(6071);
        return queryException;
    }

    public static QueryException joinExpressionsNotApplicableOnNonObjectReportItem(String expressionType, String itemName) {
        Object[] args = new Object[]{expressionType, itemName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6140, args));
        queryException.setErrorCode(6140);
        return queryException;
    }

    public static QueryException joiningAcrossInheritanceClassWithMultipleTablesNotSupported(DatabaseQuery query, Class joinClass) {
        Object[] args = new Object[]{query, joinClass};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6099, args));
        queryException.setErrorCode(6099);
        return queryException;
    }

    public static QueryException invalidUseOfToManyQueryKeyInExpression(Object data) {
        Object[] args = new Object[]{data};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6070, args));
        queryException.setErrorCode(6070);
        return queryException;
    }

    public static QueryException isolatedQueryExecutedOnServerSession() {
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6115, new Object[0]));
        queryException.setErrorCode(6115);
        return queryException;
    }

    public static ValidationException mapKeyIsNull(Object element, Object container) {
        Object[] args = new Object[]{element.getClass(), container.getClass()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6150, args));
        validationException.setErrorCode(6150);
        return validationException;
    }

    public static ValidationException mapKeyNotComparable(Object anObject, Object aContainer) {
        String objType;
        String obj;
        if (anObject == null) {
            obj = "null";
            objType = "NULL";
        } else {
            obj = anObject.toString();
            objType = anObject.getClass().toString();
        }
        Object[] args = new Object[]{obj, objType, aContainer, aContainer.getClass()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6060, args));
        validationException.setErrorCode(6060);
        return validationException;
    }

    public static QueryException methodDoesNotExistInContainerClass(String methodName, Class aClass) {
        Object[] args = new Object[]{methodName, aClass};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6058, args));
        queryException.setErrorCode(6058);
        return queryException;
    }

    public static QueryException methodDoesNotExistOnExpression(String methodName, Class[] argTypes) {
        Object[] args = new Object[]{methodName, argTypes};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6082, args));
        queryException.setErrorCode(6082);
        return queryException;
    }

    public static QueryException methodInvocationFailed(Method aMethod, Object anObject, Exception ex) {
        Object[] args = new Object[]{aMethod, anObject, anObject.getClass()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6055, args));
        queryException.setErrorCode(6055);
        queryException.setInternalException(ex);
        return queryException;
    }

    public static QueryException methodNotValid(Object aReceiver, String methodName) {
        Object[] args = new Object[]{methodName, aReceiver};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6057, args));
        queryException.setErrorCode(6057);
        return queryException;
    }

    public static QueryException mustInstantiateValueholders() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6092, args));
        queryException.setErrorCode(6092);
        return queryException;
    }

    public static QueryException noAttributesForReportQuery(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6088, args));
        queryException.setErrorCode(6088);
        queryException.setQuery(query);
        return queryException;
    }

    public static QueryException noConcreteClassIndicated(AbstractRecord row, DatabaseQuery query) {
        Object[] args = new Object[]{row};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6020, args), query);
        queryException.setErrorCode(6020);
        return queryException;
    }

    public static QueryException noCallOrInteractionSpecified() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6116, args));
        queryException.setErrorCode(6116);
        return queryException;
    }

    public static QueryException noCursorSupport(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6021, args), query);
        queryException.setErrorCode(6021);
        return queryException;
    }

    public static QueryException noDescriptorForClassFromInheritancePolicy(DatabaseQuery query, Class referenceClass) {
        Object[] args = new Object[]{String.valueOf(referenceClass)};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6045, args), query);
        queryException.setErrorCode(6045);
        return queryException;
    }

    public static QueryException noExpressionBuilderFound(Expression expression) {
        Object[] args = new Object[]{expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6089, args));
        queryException.setErrorCode(6089);
        return queryException;
    }

    public static QueryException nullPrimaryKeyInBuildingObject(DatabaseQuery query, AbstractRecord databaseRow) {
        Object[] args = new Object[]{databaseRow};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6044, args), query);
        queryException.setErrorCode(6044);
        return queryException;
    }

    public static QueryException objectComparisonsCannotBeParameterized(Expression expression) {
        Object[] args = new Object[]{expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6077, args));
        queryException.setErrorCode(6077);
        return queryException;
    }

    public static QueryException objectDoesNotExistInCache(Object object) {
        Object[] args = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6104, args));
        queryException.setErrorCode(6104);
        return queryException;
    }

    public static QueryException classPkDoesNotExistInCache(Class theClass, Object primaryKey) {
        Object[] args = new Object[]{theClass, primaryKey};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6106, args));
        queryException.setErrorCode(6106);
        return queryException;
    }

    public static QueryException clearQueryResultsNotSupported(ReadQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6125, args), query);
        queryException.setErrorCode(6125);
        return queryException;
    }

    public static QueryException objectToInsertIsEmpty(DatabaseTable table) {
        Object[] args = new Object[]{table};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6023, args));
        queryException.setErrorCode(6023);
        return queryException;
    }

    public static QueryException objectToModifyNotSpecified(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6024, args), query);
        queryException.setErrorCode(6024);
        return queryException;
    }

    public static QueryException outerJoinIsOnlyValidForOneToOneMappings(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.toString()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6052, args));
        queryException.setErrorCode(6052);
        return queryException;
    }

    public static QueryException queryNotDefined() {
        Object[] args = new Object[]{"", ""};
        return QueryException.queryNotDefined(args);
    }

    public static QueryException queryNotDefined(String queryName) {
        Object[] args = new Object[]{queryName, ""};
        return QueryException.queryNotDefined(args);
    }

    public static QueryException queryNotDefined(String queryName, Class domainClass) {
        Object[] args = new Object[]{queryName, domainClass};
        return QueryException.queryNotDefined(args);
    }

    private static QueryException queryNotDefined(Object[] args) {
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6026, args));
        queryException.setErrorCode(6026);
        return queryException;
    }

    public static QueryException querySentToInactiveUnitOfWork(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6027, args), query);
        queryException.setErrorCode(6027);
        return queryException;
    }

    public static QueryException readBeyondStream(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6028, args), query);
        queryException.setErrorCode(6028);
        return queryException;
    }

    public static QueryException redirectionClassOrMethodNotSet(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6084, args), query);
        queryException.setErrorCode(6084);
        return queryException;
    }

    public static QueryException unableToSetRedirectorOnQueryFromHint(DatabaseQuery query, String hint, String redirectorClass, Exception ex) {
        Object[] args = new Object[]{hint, redirectorClass};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6151, args), query);
        queryException.setInternalException(ex);
        queryException.setErrorCode(6151);
        return queryException;
    }

    public static QueryException redirectionMethodError(Exception exception, DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6086, args), query);
        queryException.setInternalException(exception);
        queryException.setErrorCode(6086);
        return queryException;
    }

    public static QueryException redirectionMethodNotDefinedCorrectly(Class methodClass, String methodName, Exception exception, DatabaseQuery query) {
        Object[] args = new Object[]{methodClass, methodName, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6085, args), query);
        queryException.setInternalException(exception);
        queryException.setErrorCode(6085);
        return queryException;
    }

    public static QueryException referenceClassMissing(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6029, args), query);
        queryException.setErrorCode(6029);
        return queryException;
    }

    public static QueryException refreshNotPossibleWithoutCache(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6030, args), query);
        queryException.setErrorCode(6030);
        return queryException;
    }

    public static QueryException reportQueryResultSizeMismatch(int expected, int retrieved) {
        Object[] args = new Object[]{expected, retrieved};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6050, args));
        queryException.setErrorCode(6050);
        return queryException;
    }

    public static QueryException reportQueryResultWithoutPKs(ReportQueryResult result) {
        Object[] args = new Object[]{result, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6043, args), null);
        queryException.setErrorCode(6043);
        return queryException;
    }

    public static QueryException parameterNameMismatch(String badParameterName) {
        Object[] args = new Object[]{badParameterName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6094, args), null);
        queryException.setErrorCode(6094);
        return queryException;
    }

    public static QueryException polymorphicReportItemWithMultipletableNotSupported(String itemName, Expression expression, DatabaseQuery owner) {
        Object[] args = new Object[]{itemName, expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6136, args), owner);
        queryException.setErrorCode(6136);
        return queryException;
    }

    public static QueryException selectionObjectCannotBeNull(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6041, args), query);
        queryException.setErrorCode(6041);
        return queryException;
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setQueryArguments(AbstractRecord queryArguments) {
        this.queryArguments = queryArguments;
    }

    public static QueryException sizeOnlySupportedOnExpressionQueries(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6031, args), query);
        queryException.setErrorCode(6031);
        return queryException;
    }

    public static QueryException specifiedPartialAttributeDoesNotExist(DatabaseQuery query, String attributeName, String targetClassName) {
        Object[] args = new Object[]{attributeName, targetClassName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6120, args), query);
        queryException.setErrorCode(6120);
        return queryException;
    }

    public static QueryException sqlStatementNotSetProperly(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6032, args), query);
        queryException.setErrorCode(6032);
        return queryException;
    }

    public static QueryException typeMismatchBetweenAttributeAndConstantOnExpression(Class constantClass, Class attributeClass) {
        Object[] args = new Object[]{constantClass, attributeClass};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6091, args));
        queryException.setErrorCode(6091);
        return queryException;
    }

    public static QueryException unnamedQueryOnSessionBroker(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6042, args), query);
        queryException.setErrorCode(6042);
        return queryException;
    }

    public static QueryException unsupportedMappingForObjectComparison(DatabaseMapping mapping, Expression expression) {
        Object[] args = new Object[]{mapping, expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6076, args));
        queryException.setErrorCode(6076);
        return queryException;
    }

    public static QueryException updateStatementsNotSpecified() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6107, args));
        queryException.setErrorCode(6107);
        return queryException;
    }

    public static QueryException inheritanceWithMultipleTablesNotSupported() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6108, args));
        queryException.setErrorCode(6108);
        return queryException;
    }

    public static QueryException cloneMethodRequired() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6095, args));
        queryException.setErrorCode(6095);
        return queryException;
    }

    public static QueryException cloneMethodInaccessible() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6096, args));
        queryException.setErrorCode(6096);
        return queryException;
    }

    public static QueryException cloneMethodThrowException(Throwable exception) {
        Object[] args = new Object[]{exception};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6097, args));
        queryException.setErrorCode(6097);
        return queryException;
    }

    public static QueryException unexpectedInvocation(String message) {
        Object[] args = new Object[]{message};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6098, args));
        queryException.setErrorCode(6098);
        return queryException;
    }

    public static QueryException multipleRowsDetectedFromReadObjectQuery() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6100, args));
        queryException.setErrorCode(6100);
        return queryException;
    }

    public static QueryException historicalQueriesMustPreserveGlobalCache() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6101, args));
        queryException.setErrorCode(6101);
        return queryException;
    }

    public static QueryException historicalQueriesOnlySupportedOnOracle() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6102, args));
        queryException.setErrorCode(6102);
        return queryException;
    }

    public static QueryException mustUseCursorStreamPolicy() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6105, args));
        queryException.setErrorCode(6105);
        return queryException;
    }

    public static QueryException fetchGroupNotDefinedInDescriptor(String fetchGroupName) {
        Object[] args = new Object[]{fetchGroupName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6109, args));
        queryException.setErrorCode(6109);
        return queryException;
    }

    public static QueryException cannotConformUnfetchedAttribute(String attrbuteName) {
        Object[] args = new Object[]{attrbuteName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6110, args));
        queryException.setErrorCode(6110);
        return queryException;
    }

    public static QueryException fetchGroupAttributeNotMapped(String attrbuteName) {
        Object[] args = new Object[]{attrbuteName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6111, args));
        queryException.setErrorCode(6111);
        return queryException;
    }

    public static QueryException fetchGroupNotSupportOnReportQuery() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6112, args));
        queryException.setErrorCode(6112);
        return queryException;
    }

    public static QueryException fetchGroupNotSupportOnPartialAttributeReading() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6113, args));
        queryException.setErrorCode(6113);
        return queryException;
    }

    public static QueryException fetchGroupValidOnlyIfFetchGroupManagerInDescriptor(String descriptorName, String queryName) {
        Object[] args = new Object[]{descriptorName, queryName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6114, args));
        queryException.setErrorCode(6114);
        return queryException;
    }

    public static QueryException reflectiveCallOnTopLinkClassFailed(String className, Exception e) {
        Object[] args = new Object[]{className};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6127, args));
        queryException.setErrorCode(6127);
        queryException.setInternalException(e);
        return queryException;
    }

    public static QueryException refreshNotPossibleWithCheckCacheOnly(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6129, args), query);
        queryException.setErrorCode(6129);
        return queryException;
    }

    public static QueryException deleteAllQuerySpecifiesObjectsButNotSelectionCriteria(ClassDescriptor descriptor, DatabaseQuery query, String objects) {
        Object[] args = new Object[]{descriptor.toString(), CR, objects};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6131, args), query);
        queryException.setErrorCode(6131);
        return queryException;
    }

    public static QueryException updateAllQueryAddUpdateFieldIsNull(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6133, args), query);
        queryException.setErrorCode(6133);
        return queryException;
    }

    public static QueryException updateAllQueryAddUpdateDoesNotDefineField(ClassDescriptor descriptor, DatabaseQuery query, String attributeNameOrExpression) {
        Object[] args = new Object[]{descriptor.toString(), CR, attributeNameOrExpression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6134, args), query);
        queryException.setErrorCode(6134);
        return queryException;
    }

    public static QueryException updateAllQueryAddUpdateDefinesWrongField(ClassDescriptor descriptor, DatabaseQuery query, String attributeNameOrExpression, String wrongField) {
        Object[] args = new Object[]{descriptor.toString(), CR, attributeNameOrExpression, wrongField};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6135, args), query);
        queryException.setErrorCode(6135);
        return queryException;
    }

    public static QueryException tempTablesNotSupported(DatabaseQuery query, String platformClassName) {
        Object[] args = new Object[]{platformClassName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6138, args), query);
        queryException.setErrorCode(6138);
        return queryException;
    }

    public static QueryException classNotFoundWhileUsingQueryHint(DatabaseQuery query, Object hintValue, Exception exc) {
        Object[] args = new Object[]{hintValue};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6141, args), query);
        queryException.setErrorCode(6141);
        queryException.setInternalException(exc);
        return queryException;
    }

    public static QueryException queryHintNavigatedIllegalRelationship(DatabaseQuery query, String hintName, Object hintValue, String relationship) {
        Object[] args = new Object[]{hintName, hintValue, relationship};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6142, args), query);
        queryException.setErrorCode(6142);
        return queryException;
    }

    public static QueryException queryHintNavigatedNonExistantRelationship(DatabaseQuery query, String hintName, Object hintValue, String relationship) {
        Object[] args = new Object[]{hintName, hintValue, relationship};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6143, args), query);
        queryException.setErrorCode(6143);
        return queryException;
    }

    public static QueryException queryHintDidNotContainEnoughTokens(DatabaseQuery query, String hintName, Object hintValue) {
        Object[] args = new Object[]{hintName, hintValue};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6144, args), query);
        queryException.setErrorCode(6144);
        return queryException;
    }

    public static QueryException distinctCountOnOuterJoinedCompositePK(ClassDescriptor descr, DatabaseQuery query) {
        Object[] args = new Object[]{descr.getJavaClass().getName(), descr.toString()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6145, args), query);
        queryException.setErrorCode(6145);
        return queryException;
    }

    public static QueryException queryHintContainedInvalidIntegerValue(String hintName, Object hintValue, Exception e) {
        Object[] args = new Object[]{hintName, hintValue};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6146, args), null, e);
        queryException.setErrorCode(6146);
        return queryException;
    }

    public static QueryException expressionDoesNotSupportPartialAttributeReading(Expression expression) {
        Object[] args = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6147, args));
        queryException.setErrorCode(6147);
        return queryException;
    }

    public static QueryException addArgumentsNotSupported(String argumentType) {
        Object[] args = new Object[]{argumentType};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6148, args));
        queryException.setErrorCode(6148);
        return queryException;
    }

    public static QueryException unnamedArgumentsNotSupported() {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6149, args));
        queryException.setErrorCode(6149);
        return queryException;
    }

    public static QueryException compatibleTypeNotSet(DatabaseType type2) {
        Object[] args = new Object[]{type2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6153, args));
        queryException.setErrorCode(6153);
        return queryException;
    }

    public static QueryException typeNameNotSet(DatabaseType type2) {
        Object[] args = new Object[]{type2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6154, args));
        queryException.setErrorCode(6154);
        return queryException;
    }

    public static QueryException errorInstantiatedClassForQueryHint(Exception exception, DatabaseQuery query, Class theClass, String hint) {
        Object[] args = new Object[]{theClass, hint};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6152, args), query);
        queryException.setErrorCode(6152);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException noRelationTableInManyToManyQueryKey(ManyToManyQueryKey queryKey, Expression expression) {
        Object[] args = new Object[]{queryKey, expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6155, args));
        queryException.setErrorCode(6155);
        return queryException;
    }

    public static QueryException exceptionWhileReadingMapKey(Object object, Exception ex) {
        Object[] args = new Object[]{object, ex};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6156, args));
        queryException.setErrorCode(6156);
        queryException.setInternalException(ex);
        return queryException;
    }

    public static QueryException cannotAddElementWithoutKeyToMap(Object object) {
        Object[] args = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6157, args));
        queryException.setErrorCode(6157);
        return queryException;
    }

    public static QueryException cannotUnwrapNonMapMembers(Object object) {
        Object[] args = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6158, args));
        queryException.setErrorCode(6158);
        return queryException;
    }

    public static QueryException noMappingForMapEntryExpression(Expression baseExpression) {
        Object[] args = new Object[]{baseExpression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6159, args));
        queryException.setErrorCode(6159);
        return queryException;
    }

    public static QueryException mapEntryExpressionForNonCollection(Expression baseExpression, DatabaseMapping mapping) {
        Object[] args = new Object[]{baseExpression, mapping};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6160, args));
        queryException.setErrorCode(6160);
        return queryException;
    }

    public static QueryException mapEntryExpressionForNonMap(Expression baseExpression, DatabaseMapping mapping) {
        Object[] args = new Object[]{baseExpression, mapping};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6161, args));
        queryException.setErrorCode(6161);
        return queryException;
    }

    public static QueryException listOrderFieldWrongValue(DatabaseQuery query, DatabaseField field, List wrongOrderValuesList) {
        Object[] args = new Object[]{field, wrongOrderValuesList, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6162, args), query);
        queryException.setErrorCode(6162);
        return queryException;
    }

    public static QueryException indexRequiresQueryKeyExpression(Expression expression) {
        Object[] args = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6163, args));
        queryException.setErrorCode(6163);
        return queryException;
    }

    public static QueryException indexRequiresCollectionMappingWithListOrderField(Expression expression, DatabaseMapping mapping) {
        Object[] args = new Object[]{expression, mapping};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6164, args));
        queryException.setErrorCode(6164);
        return queryException;
    }

    public static QueryException batchReadingInRequiresSingletonPrimaryKey(DatabaseQuery query) {
        Object[] args = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6165, args), query);
        queryException.setErrorCode(6165);
        return queryException;
    }

    public static QueryException couldNotFindCastDescriptor(Class castClass, Expression base) {
        Object[] args = new Object[]{castClass, base};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6166, args));
        queryException.setErrorCode(6166);
        return queryException;
    }

    public static QueryException castMustUseInheritance(Expression base) {
        Object[] args = new Object[]{base};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6167, args));
        queryException.setErrorCode(6167);
        return queryException;
    }

    public static QueryException prepareFailed(Exception error, DatabaseQuery query) {
        Object[] args = new Object[]{error};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6168, args), query, error);
        queryException.setErrorCode(6168);
        return queryException;
    }

    public static QueryException originalQueryMustUseBatchIN(DatabaseMapping mapping, DatabaseQuery query) {
        Object[] args = new Object[]{mapping};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6169, args), query);
        queryException.setErrorCode(6169);
        return queryException;
    }

    public static QueryException partitioningNotSupported(AbstractSession session, DatabaseQuery query) {
        Object[] args = new Object[]{session};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6171, args), query);
        queryException.setErrorCode(6171);
        return queryException;
    }

    public static QueryException missingConnectionPool(String poolName, DatabaseQuery query) {
        Object[] args = new Object[]{poolName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6172, args), query);
        queryException.setErrorCode(6172);
        return queryException;
    }

    public static QueryException failoverFailed(String poolName) {
        Object[] args = new Object[]{poolName};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6173, args));
        queryException.setErrorCode(6173);
        return queryException;
    }
}

