/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.util.logging.Level;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.StringManager;

public final class EngineConfig
implements LifecycleListener {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(EngineConfig.class.getName());
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private int debug = 0;
    private Engine engine = null;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int engineDebug;
            this.engine = (Engine)((Object)event.getLifecycle());
            if (this.engine instanceof StandardEngine && (engineDebug = ((StandardEngine)this.engine).getDebug()) > this.debug) {
                this.debug = engineDebug;
            }
        }
        catch (ClassCastException e) {
            this.log(sm.getString("engineConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void log(String message) {
        Logger logger2 = null;
        if (this.engine != null) {
            logger2 = this.engine.getLogger();
        }
        if (logger2 != null) {
            logger2.log("EngineConfig: " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.info("EngineConfig: " + message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger2 = null;
        if (this.engine != null) {
            logger2 = this.engine.getLogger();
        }
        if (logger2 != null) {
            logger2.log("EngineConfig: " + message, t, 2);
        } else {
            log.log(Level.WARNING, "EngineConfig: " + message, t);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(sm.getString("engineConfig.start"));
        }
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(sm.getString("engineConfig.stop"));
        }
    }
}

