/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.helper;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthContextHelper {
    String loggerName;
    private boolean returnNullContexts = false;

    private AuthContextHelper() {
    }

    protected AuthContextHelper(String loggerName, boolean returnNullContexts) {
        this.loggerName = loggerName;
        this.returnNullContexts = returnNullContexts;
    }

    protected boolean isLoggable(Level level) {
        Logger logger2 = Logger.getLogger(this.loggerName);
        return logger2.isLoggable(level);
    }

    protected void logIfLevel(Level level, Throwable t, String ... msgParts) {
        Logger logger2 = Logger.getLogger(this.loggerName);
        if (logger2.isLoggable(level)) {
            String msg = null;
            for (String m : msgParts) {
                msg = msg + m;
            }
            if (msg != null && t != null) {
                logger2.log(level, msg, t);
            } else if (msg != null) {
                logger2.log(level, msg);
            }
        }
    }

    protected Logger getLogger(Level level) {
        Logger rvalue = Logger.getLogger(this.loggerName);
        if (rvalue.isLoggable(level)) {
            return rvalue;
        }
        return null;
    }

    protected abstract void refresh();

    public boolean returnsNullContexts() {
        return this.returnNullContexts;
    }

    public <M> boolean isProtected(M[] template, String authContextID) throws AuthException {
        try {
            if (this.returnNullContexts) {
                return this.hasModules(template, authContextID);
            }
            return true;
        }
        catch (AuthException ae) {
            throw new RuntimeException(ae);
        }
    }

    public abstract <M> boolean hasModules(M[] var1, String var2) throws AuthException;

    public abstract <M> M[] getModules(M[] var1, String var2) throws AuthException;

    public abstract Map<String, ?> getInitProperties(int var1, Map<String, ?> var2);

    public abstract boolean exitContext(AuthStatus[] var1, int var2, AuthStatus var3);

    public abstract AuthStatus getReturnStatus(AuthStatus[] var1, AuthStatus var2, AuthStatus[] var3, int var4);
}

