/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.KeyWebSocketListener;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.Version;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketCloseHandler;
import com.sun.grizzly.websockets.WebSocketException;
import com.sun.grizzly.websockets.WebSocketSelectionKeyAttachment;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketEngine {
    public static final String SEC_WS_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WS_KEY_HEADER = "Sec-WebSocket-Key";
    public static final String SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String SEC_WS_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SEC_WS_EXTENSIONS_HEADER = "Sec-WebSocket-Extensions";
    public static final String SEC_WS_VERSION = "Sec-WebSocket-Version";
    public static final String WEBSOCKET = "websocket";
    public static final String RESPONSE_CODE_HEADER = "Response Code";
    public static final String RESPONSE_CODE_MESSAGE = "Switching Protocols";
    public static final String RESPONSE_CODE_VALUE = "101";
    public static final String UPGRADE = "upgrade";
    public static final String CONNECTION = "connection";
    public static final String CLIENT_WS_ORIGIN_HEADER = "Origin";
    public static final Version DEFAULT_VERSION = Version.DRAFT17;
    public static final int INITIAL_BUFFER_SIZE = 8192;
    public static final int DEFAULT_TIMEOUT;
    private static final WebSocketEngine engine;
    static final Logger logger;
    public static final String SERVER_KEY_HASH = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final int MASK_SIZE = 4;
    private final List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private final WebSocketCloseHandler closeHandler = new WebSocketCloseHandler();

    private WebSocketEngine() {
    }

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public static byte[] toArray(long length) {
        long value = length;
        byte[] b = new byte[8];
        for (int i = 7; i >= 0 && value > 0L; value >>= 8, --i) {
            b[i] = (byte)(value & 0xFFL);
        }
        return b;
    }

    public static long toLong(byte[] bytes, int start, int end) {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value <<= 8;
            value ^= (long)bytes[i] & 0xFFL;
        }
        return value;
    }

    public static ProtocolHandler loadHandler(MimeHeaders headers) {
        for (Version version : Version.values()) {
            if (!version.validate(headers)) continue;
            return version.createHandler(false);
        }
        return null;
    }

    public WebSocketApplication getApplication(Request request) {
        for (WebSocketApplication application : this.applications) {
            if (!application.isApplicationRequest(request)) continue;
            return application;
        }
        return null;
    }

    public boolean upgrade(AsyncExecutor asyncExecutor) {
        return this.upgrade(asyncExecutor, null);
    }

    public boolean upgrade(AsyncExecutor asyncExecutor, Mapper mapper) {
        Request request = asyncExecutor.getProcessorTask().getRequest();
        MimeHeaders mimeHeaders = request.getMimeHeaders();
        if (this.isUpgradable(request)) {
            try {
                WebSocketApplication app = this.getApplication(request);
                WebSocket socket = null;
                try {
                    if (app != null) {
                        ProcessorTask task = asyncExecutor.getProcessorTask();
                        AsyncProcessorTask asyncTask = (AsyncProcessorTask)asyncExecutor.getAsyncTask();
                        SelectionKey key = task.getSelectionKey();
                        ProtocolHandler protocolHandler = WebSocketEngine.loadHandler(mimeHeaders);
                        if (protocolHandler == null) {
                            try {
                                WebSocketEngine.handleUnsupportedVersion(request.getResponse());
                                return true;
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                        }
                        ServerNetworkHandler handler = new ServerNetworkHandler(request, request.getResponse(), protocolHandler, mapper);
                        protocolHandler.setNetworkHandler(handler);
                        protocolHandler.setKey(key);
                        protocolHandler.setProcessorTask(task);
                        protocolHandler.setAsyncTask(asyncTask);
                        protocolHandler.handshake(app, request);
                        socket = app.createWebSocket(protocolHandler, app, new KeyWebSocketListener(key));
                        if (socket instanceof DefaultWebSocket) {
                            // empty if block
                        }
                        ((BaseSelectionKeyHandler)task.getSelectorHandler().getSelectionKeyHandler()).setConnectionCloseHandler(this.closeHandler);
                        key.attach(new WebSocketSelectionKeyAttachment(protocolHandler, handler, task, asyncTask));
                        socket.onConnect();
                        this.enableRead(task, key);
                        return true;
                    }
                }
                catch (HandshakeException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    if (socket != null) {
                        socket.close();
                    }
                }
            }
            catch (WebSocketException e) {
                return false;
            }
        }
        return false;
    }

    private static void handleUnsupportedVersion(Response response) throws IOException {
        response.setStatus(400);
        response.setMessage("Bad Request");
        response.addHeader(SEC_WS_VERSION, Version.getSupportedWireProtocolVersions());
        response.sendHeaders();
        response.flush();
    }

    private boolean isUpgradable(Request request) {
        String s = request.getHeader("Upgrade");
        return "WebSocket".equalsIgnoreCase(s);
    }

    final void enableRead(ProcessorTask task, SelectionKey key) {
        task.getSelectorHandler().register(key, 1);
    }

    @Deprecated
    public void register(String name, WebSocketApplication app) {
        this.register(app);
    }

    public void register(WebSocketApplication app) {
        this.applications.add(app);
    }

    public void unregister(WebSocketApplication app) {
        this.applications.remove(app);
        app.shutdown();
    }

    static {
        engine = new WebSocketEngine();
        logger = Logger.getLogger(WEBSOCKET);
        DEFAULT_TIMEOUT = Utils.isDebugVM() ? 900 : 30;
    }
}

