/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.Utils;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SelectorFactory {
    private static final int MISS_THRESHOLD = 10000;
    public static final int DEFAULT_MAX_SELECTORS = 20;
    private static volatile int maxSelectors = 20;
    private static final Queue<Selector> selectors = DataStructures.getCLQinstance(Selector.class);
    private static final AtomicInteger poolSize = new AtomicInteger();
    private static final AtomicInteger missesCounter = new AtomicInteger();

    public static void setMaxSelectors(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        missesCounter.set(0);
        maxSelectors = size;
    }

    public static int getMaxSelectors() {
        return maxSelectors;
    }

    public static Selector getSelector() {
        Selector selector = selectors.poll();
        if (selector != null) {
            poolSize.decrementAndGet();
        } else {
            try {
                selector = Utils.openSelector();
            }
            catch (IOException e) {
                LoggerUtils.getLogger().log(Level.WARNING, "SelectorFactory. Can not create a selector", e);
            }
            int missesCount = missesCounter.incrementAndGet();
            if (missesCount % 10000 == 0) {
                LoggerUtils.getLogger().log(Level.WARNING, "SelectorFactory. Pool encounters a lot of misses {0}. Increase default {1} pool size", new Object[]{missesCount, maxSelectors});
            }
        }
        return selector;
    }

    public static void returnSelector(Selector s) {
        if (poolSize.getAndIncrement() < maxSelectors) {
            selectors.offer(s);
        } else {
            poolSize.decrementAndGet();
            SelectorFactory.closeSelector(s);
        }
    }

    public static void selectNowAndReturnSelector(Selector s) {
        try {
            s.selectNow();
            SelectorFactory.returnSelector(s);
        }
        catch (IOException e) {
            Logger logger2 = LoggerUtils.getLogger();
            logger2.log(Level.WARNING, "Unexpected problem when releasing temporary Selector", e);
            SelectorFactory.closeSelector(s);
        }
    }

    private static void closeSelector(Selector s) {
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

