/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.ajp;

import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.http.ajp.AjpHttpResponse;
import com.sun.grizzly.http.ajp.AjpMessageUtils;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class AjpOutputBuffer
extends SocketChannelOutputBuffer {
    private static final byte[] END_RESPONSE_AJP_PACKET = AjpMessageUtils.createAjpPacket((byte)5, new byte[]{1});
    private static final byte[] TERMINATING_BYTE = new byte[1];

    public AjpOutputBuffer(Response response, int sendBufferSize, boolean bufferResponse) {
        super(response, sendBufferSize, bufferResponse);
    }

    public final boolean isSupportFileSend() {
        return false;
    }

    public void sendHeaders() {
        ByteChunk encodeHeaders = AjpMessageUtils.encodeHeaders((AjpHttpResponse)this.response);
        try {
            this.writeEncodedAjpMessage(encodeHeaders.getBuffer(), encodeHeaders.getStart(), encodeHeaders.getLength());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeEncodedAjpMessage(byte[] cbuf, int off, int len) throws IOException {
        this.writeEncodedAjpMessage(cbuf, off, len, false);
    }

    public void writeEncodedAjpMessage(byte[] cbuf, int off, int len, boolean isFlush) throws IOException {
        super.realWriteBytes(cbuf, off, len);
        if (isFlush) {
            this.flushBuffer();
        }
    }

    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (this.response.isCommitted()) {
            int count;
            ByteChunk bc = ((AjpHttpResponse)this.response).tmpHeaderByteChunk;
            for (int written = 0; written < len; written += count) {
                count = Math.min(8183, len - written);
                bc.recycle();
                bc.append('A');
                bc.append('B');
                AjpMessageUtils.putShort(bc, (short)(count + 4));
                bc.append((byte)3);
                AjpMessageUtils.putShort(bc, (short)count);
                super.realWriteBytes(bc.getBytes(), bc.getStart(), bc.getLength());
                super.realWriteBytes(cbuf, off + written, count);
                super.realWriteBytes(TERMINATING_BYTE, 0, 1);
            }
        } else {
            throw new IllegalStateException("Headers serialization shouldn't reach this point");
        }
    }

    public long sendFile(FileChannel fileChannel, long position, long length) throws IOException {
        throw new IllegalStateException("Not implemented");
    }

    public void endRequest() throws IOException {
        if (!this.finished) {
            super.endRequest();
            this.writeEncodedAjpMessage(END_RESPONSE_AJP_PACKET, 0, END_RESPONSE_AJP_PACKET.length);
            this.flushBuffer();
        }
    }

    void setFinished(boolean isFinished) {
        this.finished = isFinished;
    }
}

