/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.ajp;

import com.sun.grizzly.http.ajp.AjpConfiguration;
import com.sun.grizzly.http.ajp.AjpHttpRequest;
import com.sun.grizzly.http.ajp.AjpMessageUtils;
import com.sun.grizzly.http.ajp.AjpOutputBuffer;
import com.sun.grizzly.http.ajp.AjpProcessorTask;
import com.sun.grizzly.tcp.InputBuffer;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.EOFException;
import java.io.IOException;

public class AjpInputBuffer
extends InternalInputBuffer {
    private static final byte[] GET_BODY_CHUNK_PACKET;
    private final AjpConfiguration configuration;
    private final AjpProcessorTask ajpProcessorTask;
    private int thisPacketEnd;
    private int dataPacketRemaining;
    private boolean isIOExceptionOccurred;

    public AjpInputBuffer(AjpConfiguration configuration, AjpProcessorTask ajpProcessorTask, Request request, int requestBufferSize) {
        super(request, requestBufferSize);
        this.ajpProcessorTask = ajpProcessorTask;
        this.configuration = configuration;
        this.inputStreamInputBuffer = new AjpInputStreamInputBuffer();
    }

    protected void readAjpMessageHeader() throws IOException {
        if (!this.ensureAvailable(4)) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        int magic = AjpMessageUtils.getShort(this.buf, this.pos);
        if (magic != 4660) {
            throw new IllegalStateException("Invalid packet magic number: " + Integer.toHexString(magic) + " pos=" + this.pos + " lastValid=" + this.lastValid + " end=" + this.end);
        }
        int size = AjpMessageUtils.getShort(this.buf, this.pos + 2);
        if (size + 4 > 8192) {
            throw new IllegalStateException("The message is too large. " + (size + 4) + ">" + 8192);
        }
        this.pos += 4;
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        ajpRequest.setLength(size);
    }

    public void parseRequestLine() throws IOException {
        this.readAjpPacketPayload();
    }

    public void parseHeaders() throws IOException {
        super.parseHeaders();
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        if (ajpRequest.getType() == 2) {
            this.parseAjpHttpHeaders();
        }
    }

    public boolean parseHeader() throws IOException {
        return false;
    }

    protected void readAjpPacketPayload() throws IOException {
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        int length = ajpRequest.getLength();
        if (!this.ensureAvailable(length)) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        this.thisPacketEnd = this.pos + length;
        ajpRequest.setType(ajpRequest.isForwardRequestProcessing() ? 99 : this.buf[this.pos++] & 0xFF);
    }

    protected void parseAjpHttpHeaders() {
        String epSecret;
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        this.pos = this.end = AjpMessageUtils.decodeForwardRequest(this.buf, this.pos, this.configuration.isTomcatAuthentication(), ajpRequest);
        String secret = this.configuration.getSecret();
        if (!(secret == null || (epSecret = ajpRequest.getSecret()) != null && secret.equals(epSecret))) {
            throw new IllegalStateException("Secret doesn't match");
        }
        long contentLength = this.request.getContentLength();
        if (contentLength > 0L) {
            ajpRequest.setContentBytesRemaining((int)contentLength);
            ajpRequest.setExpectContent(true);
        } else {
            ajpRequest.setExpectContent(false);
        }
    }

    final void getBytesToMB(MessageBytes messageBytes) {
        this.pos = AjpMessageUtils.getBytesToByteChunk(this.buf, this.pos, messageBytes);
    }

    protected final boolean fill() throws IOException {
        throw new IllegalStateException("Should never be called for AJP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ensureAvailable(int length) throws IOException {
        if (this.isIOExceptionOccurred) {
            return false;
        }
        int available = this.available();
        if (available >= length) {
            return true;
        }
        if (this.pos == this.lastValid) {
            this.pos = this.lastValid = this.end;
        }
        if (this.pos + length > this.buf.length) {
            int offs;
            byte[] targetArray;
            if (this.end + length <= this.buf.length) {
                targetArray = this.buf;
                offs = this.end;
            } else {
                targetArray = new byte[Math.max(this.buf.length, 16384)];
                offs = 0;
                this.end = 0;
            }
            if (available > 0) {
                System.arraycopy(this.buf, this.pos, targetArray, offs, available);
            }
            this.buf = targetArray;
            this.pos = offs;
            this.lastValid = this.pos + available;
        }
        boolean error = false;
        try {
            while (this.lastValid - this.pos < length) {
                int readNow;
                error = true;
                try {
                    readNow = this.inputStream.read(this.buf, this.lastValid, this.buf.length - this.lastValid);
                    if (readNow < 0) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (IOException ioe) {
                    boolean bl = false;
                    return bl;
                }
                error = false;
                this.lastValid += readNow;
            }
        }
        finally {
            if (error) {
                this.ajpProcessorTask.error();
                this.isIOExceptionOccurred = true;
                this.lastValid = this.thisPacketEnd = this.end;
                this.pos = this.thisPacketEnd;
            }
        }
        return true;
    }

    public void endRequest() throws IOException {
        this.pos = this.thisPacketEnd;
        this.end = 0;
        this.dataPacketRemaining = 0;
        this.isIOExceptionOccurred = false;
    }

    public void recycle() {
        this.thisPacketEnd = 0;
        this.dataPacketRemaining = 0;
        this.isIOExceptionOccurred = false;
        super.recycle();
    }

    void parseDataChunk() throws IOException {
        this.pos = this.thisPacketEnd;
        this.readAjpMessageHeader();
        this.readAjpPacketPayload();
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        if (ajpRequest.getLength() != this.available()) {
            throw new IllegalStateException("Unexpected: read more data than JK_AJP13_DATA has");
        }
        if (ajpRequest.getType() != 99) {
            throw new IllegalStateException("Expected message type is JK_AJP13_DATA");
        }
        this.pos += 2;
        this.dataPacketRemaining = this.available();
    }

    private void requestDataChunk() throws IOException {
        ((AjpOutputBuffer)this.request.getResponse().getOutputBuffer()).writeEncodedAjpMessage(GET_BODY_CHUNK_PACKET, 0, GET_BODY_CHUNK_PACKET.length, true);
    }

    static {
        byte[] getBodyChunkPayload = new byte[2];
        AjpMessageUtils.putShort(getBodyChunkPayload, 0, (short)8186);
        GET_BODY_CHUNK_PACKET = AjpMessageUtils.createAjpPacket((byte)6, getBodyChunkPayload);
    }

    protected class AjpInputStreamInputBuffer
    implements InputBuffer {
        protected AjpInputStreamInputBuffer() {
        }

        public int doRead(ByteChunk chunk, Request req) throws IOException {
            AjpHttpRequest ajpRequest = (AjpHttpRequest)AjpInputBuffer.this.request;
            if (!ajpRequest.isExpectContent()) {
                return -1;
            }
            if (ajpRequest.getContentBytesRemaining() <= 0) {
                return -1;
            }
            if (AjpInputBuffer.this.dataPacketRemaining <= 0) {
                AjpInputBuffer.this.requestDataChunk();
                AjpInputBuffer.this.parseDataChunk();
            }
            int length = AjpInputBuffer.this.dataPacketRemaining;
            chunk.setBytes(AjpInputBuffer.this.buf, AjpInputBuffer.this.pos, AjpInputBuffer.this.dataPacketRemaining);
            AjpInputBuffer.this.pos = AjpInputBuffer.this.pos + AjpInputBuffer.this.dataPacketRemaining;
            ajpRequest.setContentBytesRemaining(ajpRequest.getContentBytesRemaining() - AjpInputBuffer.this.dataPacketRemaining);
            AjpInputBuffer.this.dataPacketRemaining = 0;
            return length;
        }
    }
}

