/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ErrorPageDescriptor;
import com.sun.enterprise.deployment.JspConfigDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingListDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.CookieConfig;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.MimeMapping;
import com.sun.enterprise.deployment.web.MultipartConfig;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.deployment.web.SessionConfig;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.deploy.ContextEjbDecorator;
import com.sun.enterprise.web.deploy.ContextEnvironmentDecorator;
import com.sun.enterprise.web.deploy.ContextLocalEjbDecorator;
import com.sun.enterprise.web.deploy.ContextResourceDecorator;
import com.sun.enterprise.web.deploy.ErrorPageDecorator;
import com.sun.enterprise.web.deploy.FilterDefDecorator;
import com.sun.enterprise.web.deploy.LoginConfigDecorator;
import com.sun.enterprise.web.deploy.MessageDestinationDecorator;
import com.sun.enterprise.web.deploy.MessageDestinationRefDecorator;
import com.sun.enterprise.web.deploy.SecurityCollectionDecorator;
import com.sun.enterprise.web.deploy.SecurityConstraintDecorator;
import com.sun.enterprise.web.session.SessionCookieConfig;
import com.sun.enterprise.web.session.WebSessionCookieConfig;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.SecurityConstraint;

public class TomcatDeploymentConfig {
    private static final Logger logger = LogDomains.getLogger(TomcatDeploymentConfig.class, "javax.enterprise.system.container.web");

    public static void configureWebModule(WebModule webModule, WebBundleDescriptor webModuleDescriptor) throws LifecycleException {
        if (webModuleDescriptor == null) {
            return;
        }
        webModule.setDisplayName(webModuleDescriptor.getDisplayName());
        webModule.setDistributable(webModuleDescriptor.isDistributable());
        webModule.setReplaceWelcomeFiles(true);
        TomcatDeploymentConfig.configureStandardContext(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureContextParam(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureApplicationListener(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureEjbReference(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureContextEnvironment(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureErrorPage(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureFilterDef(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureFilterMap(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureLoginConfig(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureMimeMapping(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureResourceRef(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureMessageDestination(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureContextResource(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureSecurityConstraint(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureJspConfig(webModule, webModuleDescriptor);
        TomcatDeploymentConfig.configureSecurityRoles(webModule, webModuleDescriptor);
    }

    protected static void configureEjbReference(WebModule webModule, WebBundleDescriptor wmd) {
        for (EjbReference ejbDescriptor : wmd.getEjbReferenceDescriptors()) {
            if (ejbDescriptor.isLocal()) {
                TomcatDeploymentConfig.configureContextLocalEjb(webModule, (EjbReferenceDescriptor)ejbDescriptor);
                continue;
            }
            TomcatDeploymentConfig.configureContextEjb(webModule, (EjbReferenceDescriptor)ejbDescriptor);
        }
    }

    protected static void configureContextLocalEjb(WebModule webModule, EjbReferenceDescriptor ejbDescriptor) {
        ContextLocalEjbDecorator decorator = new ContextLocalEjbDecorator(ejbDescriptor);
        webModule.addLocalEjb(decorator);
    }

    protected static void configureContextEjb(WebModule webModule, EjbReferenceDescriptor ejbDescriptor) {
        ContextEjbDecorator decorator = new ContextEjbDecorator(ejbDescriptor);
        webModule.addEjb(decorator);
    }

    protected static void configureContextEnvironment(WebModule webModule, WebBundleDescriptor wmd) {
        for (ContextParameter envRef : wmd.getContextParametersSet()) {
            webModule.addEnvironment(new ContextEnvironmentDecorator((EnvironmentProperty)envRef));
        }
    }

    protected static void configureErrorPage(WebModule webModule, WebBundleDescriptor wmd) {
        Enumeration<ErrorPageDescriptor> e = wmd.getErrorPageDescriptors();
        while (e.hasMoreElements()) {
            webModule.addErrorPage(new ErrorPageDecorator(e.nextElement()));
        }
    }

    protected static void configureFilterDef(WebModule webModule, WebBundleDescriptor wmd) {
        Vector<ServletFilter> vector = wmd.getServletFilters();
        for (int i = 0; i < vector.size(); ++i) {
            ServletFilter servletFilter = vector.get(i);
            FilterDefDecorator filterDef = new FilterDefDecorator(servletFilter);
            webModule.addFilterDef(filterDef);
        }
    }

    protected static void configureFilterMap(WebModule webModule, WebBundleDescriptor wmd) {
        Vector<ServletFilterMapping> vector = wmd.getServletFilterMappingDescriptors();
        for (int i = 0; i < vector.size(); ++i) {
            webModule.addFilterMap(vector.get(i));
        }
    }

    protected static void configureApplicationListener(WebModule webModule, WebBundleDescriptor wmd) {
        Vector<AppListenerDescriptor> vector = wmd.getAppListenerDescriptors();
        for (int i = 0; i < vector.size(); ++i) {
            webModule.addApplicationListener(vector.get(i).getListener());
        }
    }

    protected static void configureJspConfig(WebModule webModule, WebBundleDescriptor wmd) {
        webModule.setJspConfigDescriptor(wmd.getJspConfigDescriptor());
        JspConfigDescriptor jspConfig = wmd.getJspConfigDescriptor();
        if (jspConfig != null) {
            for (JspPropertyGroupDescriptor jspGroup : jspConfig.getJspPropertyGroups()) {
                for (String urlPattern : jspGroup.getUrlPatterns()) {
                    webModule.addJspMapping(urlPattern);
                }
            }
        }
    }

    protected static void configureLoginConfig(WebModule webModule, WebBundleDescriptor wmd) {
        LoginConfiguration loginConf = wmd.getLoginConfiguration();
        if (loginConf == null) {
            return;
        }
        LoginConfigDecorator decorator = new LoginConfigDecorator(loginConf);
        webModule.setLoginConfig(decorator);
    }

    protected static void configureMimeMapping(WebModule webModule, WebBundleDescriptor wmd) {
        Enumeration<MimeMapping> enumeration = wmd.getMimeMappings();
        while (enumeration.hasMoreElements()) {
            MimeMapping mimeMapping = enumeration.nextElement();
            webModule.addMimeMapping(mimeMapping.getExtension(), mimeMapping.getMimeType());
        }
    }

    protected static void configureResourceRef(WebModule webModule, WebBundleDescriptor wmd) {
        for (EnvironmentEntry envEntry : wmd.getEnvironmentProperties()) {
            webModule.addResourceEnvRef(envEntry.getName(), envEntry.getType());
        }
    }

    protected static void configureContextParam(WebModule webModule, WebBundleDescriptor wmd) {
        for (ContextParameter ctxParam : wmd.getContextParametersSet()) {
            if ("com.sun.faces.injectionProvider".equals(ctxParam.getName()) && "com.sun.faces.vendor.GlassFishInjectionProvider".equals(ctxParam.getValue())) continue;
            webModule.addParameter(ctxParam.getName(), ctxParam.getValue());
        }
    }

    protected static void configureMessageDestination(WebModule webModule, WebBundleDescriptor wmd) {
        for (MessageDestinationDescriptor msgDrd : wmd.getMessageDestinations()) {
            webModule.addMessageDestination(new MessageDestinationDecorator(msgDrd));
        }
    }

    protected static void configureMessageDestinationRef(WebModule webModule, WebBundleDescriptor wmd) {
        for (MessageDestinationReferenceDescriptor msgDrd : wmd.getMessageDestinationReferenceDescriptors()) {
            webModule.addMessageDestinationRef(new MessageDestinationRefDecorator(msgDrd));
        }
    }

    protected static void configureContextResource(WebModule webModule, WebBundleDescriptor wmd) {
        for (ResourceReferenceDescriptor resRefDesc : wmd.getResourceReferenceDescriptors()) {
            webModule.addResource(new ContextResourceDecorator(resRefDesc));
        }
    }

    protected static void configureStandardContext(WebModule webModule, WebBundleDescriptor wmd) {
        SessionCookieConfig gfSessionCookieConfig;
        Enumeration<Object> enumeration;
        for (WebComponentDescriptor webComponentDesc : wmd.getWebComponentDescriptors()) {
            if (!webComponentDesc.isEnabled()) continue;
            StandardWrapper wrapper = (StandardWrapper)webModule.createWrapper();
            wrapper.setName(webComponentDesc.getCanonicalName());
            String impl = webComponentDesc.getWebComponentImplementation();
            if (impl != null && !impl.isEmpty()) {
                if (webComponentDesc.isServlet()) {
                    wrapper.setServletClassName(impl);
                } else {
                    wrapper.setJspFile(impl);
                }
            }
            webModule.addChild(wrapper);
            enumeration = webComponentDesc.getInitializationParameters();
            InitializationParameter initP = null;
            while (enumeration.hasMoreElements()) {
                initP = (InitializationParameter)enumeration.nextElement();
                wrapper.addInitParameter(initP.getName(), initP.getValue());
            }
            if (webComponentDesc.getLoadOnStartUp() != null) {
                wrapper.setLoadOnStartup(webComponentDesc.getLoadOnStartUp());
            }
            if (webComponentDesc.isAsyncSupported() != null) {
                wrapper.setIsAsyncSupported(webComponentDesc.isAsyncSupported());
            }
            if (webComponentDesc.getRunAsIdentity() != null) {
                wrapper.setRunAs(webComponentDesc.getRunAsIdentity().getRoleName());
            }
            for (String pattern : webComponentDesc.getUrlPatternsSet()) {
                webModule.addServletMapping(pattern, webComponentDesc.getCanonicalName());
            }
            enumeration = webComponentDesc.getSecurityRoleReferences();
            while (enumeration.hasMoreElements()) {
                SecurityRoleReference securityRoleReference = (SecurityRoleReference)enumeration.nextElement();
                wrapper.addSecurityReference(securityRoleReference.getRolename(), securityRoleReference.getSecurityRoleLink().getName());
            }
            MultipartConfig mpConfig = webComponentDesc.getMultipartConfig();
            if (mpConfig == null) continue;
            wrapper.setMultipartLocation(mpConfig.getLocation());
            wrapper.setMultipartMaxFileSize(mpConfig.getMaxFileSize());
            wrapper.setMultipartMaxRequestSize(mpConfig.getMaxRequestSize());
            wrapper.setMultipartFileSizeThreshold(mpConfig.getFileSizeThreshold());
        }
        SessionConfig sessionConfig = wmd.getSessionConfig();
        webModule.setSessionTimeout(sessionConfig.getSessionTimeout());
        CookieConfig cookieConfig = sessionConfig.getCookieConfig();
        if (cookieConfig != null) {
            javax.servlet.SessionCookieConfig sessionCookieConfig = webModule.getSessionCookieConfig();
            if (cookieConfig.getName() != null && !cookieConfig.getName().isEmpty()) {
                sessionCookieConfig.setName(cookieConfig.getName());
            }
            sessionCookieConfig.setDomain(cookieConfig.getDomain());
            sessionCookieConfig.setPath(cookieConfig.getPath());
            sessionCookieConfig.setComment(cookieConfig.getComment());
            sessionCookieConfig.setHttpOnly(cookieConfig.isHttpOnly());
            sessionCookieConfig.setSecure(cookieConfig.isSecure());
            sessionCookieConfig.setMaxAge(cookieConfig.getMaxAge());
        }
        if (!sessionConfig.getTrackingModes().isEmpty()) {
            webModule.setSessionTrackingModes(sessionConfig.getTrackingModes());
        }
        if ((gfSessionCookieConfig = webModule.getSessionCookieConfigFromSunWebXml()) != null) {
            WebSessionCookieConfig sessionCookieConfig = (WebSessionCookieConfig)webModule.getSessionCookieConfig();
            if (gfSessionCookieConfig.getName() != null && !gfSessionCookieConfig.getName().isEmpty()) {
                sessionCookieConfig.setName(gfSessionCookieConfig.getName());
            }
            if (gfSessionCookieConfig.getPath() != null) {
                sessionCookieConfig.setPath(gfSessionCookieConfig.getPath());
            }
            if (gfSessionCookieConfig.getMaxAge() != null) {
                sessionCookieConfig.setMaxAge(gfSessionCookieConfig.getMaxAge());
            }
            if (gfSessionCookieConfig.getDomain() != null) {
                sessionCookieConfig.setDomain(gfSessionCookieConfig.getDomain());
            }
            if (gfSessionCookieConfig.getComment() != null) {
                sessionCookieConfig.setComment(gfSessionCookieConfig.getComment());
            }
            if (gfSessionCookieConfig.getSecure() != null) {
                sessionCookieConfig.setSecure(gfSessionCookieConfig.getSecure());
            }
            if (gfSessionCookieConfig.getHttpOnly() != null) {
                sessionCookieConfig.setHttpOnly(gfSessionCookieConfig.getHttpOnly());
            }
        }
        enumeration = wmd.getWelcomeFiles();
        while (enumeration.hasMoreElements()) {
            webModule.addWelcomeFile((String)enumeration.nextElement());
        }
        LocaleEncodingMappingListDescriptor lemds = wmd.getLocaleEncodingMappingListDescriptor();
        if (lemds != null) {
            for (LocaleEncodingMappingDescriptor lemd : lemds.getLocaleEncodingMappingSet()) {
                webModule.addLocaleEncodingMappingParameter(lemd.getLocale(), lemd.getEncoding());
            }
        }
        webModule.setOrderedLibs(wmd.getOrderedLibs());
        String[] majorMinorVersions = wmd.getSpecVersion().split("\\.");
        if (majorMinorVersions.length != 2) {
            throw new IllegalArgumentException("Illegal Servlet spec version");
        }
        webModule.setEffectiveMajorVersion(Integer.parseInt(majorMinorVersions[0]));
        webModule.setEffectiveMinorVersion(Integer.parseInt(majorMinorVersions[1]));
    }

    protected static void configureSecurityConstraint(WebModule webModule, WebBundleDescriptor wmd) {
        Enumeration<com.sun.enterprise.deployment.web.SecurityConstraint> enumeration = wmd.getSecurityConstraints();
        while (enumeration.hasMoreElements()) {
            com.sun.enterprise.deployment.web.SecurityConstraint securityConstraint = enumeration.nextElement();
            SecurityConstraintDecorator decorator = new SecurityConstraintDecorator(securityConstraint, webModule);
            for (WebResourceCollection wrc : securityConstraint.getWebResourceCollections()) {
                SecurityCollectionDecorator secCollDecorator = new SecurityCollectionDecorator(wrc);
                decorator.addCollection(secCollDecorator);
            }
            webModule.addConstraint(decorator);
        }
    }

    protected static void configureSecurityRoles(WebModule webModule, WebBundleDescriptor wmd) {
        Enumeration<SecurityRoleDescriptor> e = wmd.getSecurityRoles();
        if (e != null) {
            while (e.hasMoreElements()) {
                webModule.addSecurityRole(e.nextElement().getName());
            }
        }
        Iterator<SecurityConstraint> iter = webModule.getConstraints().iterator();
        while (iter.hasNext()) {
            String[] roles = iter.next().findAuthRoles();
            for (int j = 0; j < roles.length; ++j) {
                if ("*".equals(roles[j]) || webModule.hasSecurityRole(roles[j])) continue;
                logger.log(Level.WARNING, "tomcatDeploymentConfig.role.auth", roles[j]);
                webModule.addSecurityRole(roles[j]);
            }
        }
        Container[] wrappers = webModule.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !webModule.hasSecurityRole(runAs)) {
                logger.log(Level.WARNING, "tomcatDeploymentConfig.role.runas", runAs);
                webModule.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || webModule.hasSecurityRole(link)) continue;
                logger.log(Level.WARNING, "tomcatDeploymentConfig.role.link", link);
                webModule.addSecurityRole(link);
            }
        }
    }
}

