/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;

public class ReadableArchiveScannerAdapter
extends AbstractAdapter {
    final ReadableArchive archive;
    final Parser parser;
    final URI uri;
    final ReadableArchiveScannerAdapter parent;
    final AtomicInteger releaseCount = new AtomicInteger(1);
    private final int DEFAULT_TIMEOUT = Integer.getInteger("hk2.parser.timeout", 600);
    private static final Level level = Level.FINE;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ReadableArchiveScannerAdapter.class);

    public ReadableArchiveScannerAdapter(Parser parser, ReadableArchive archive) {
        this.archive = archive;
        this.parser = parser;
        this.uri = archive.getURI();
        this.parent = null;
    }

    private ReadableArchiveScannerAdapter(ReadableArchiveScannerAdapter parent, ReadableArchive archive, URI uri) {
        this.parent = parent;
        this.archive = archive;
        this.parser = parent.parser;
        this.uri = uri == null ? archive.getURI() : uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public Manifest getManifest() throws IOException {
        return this.archive.getManifest();
    }

    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask entryTask, Logger logger2) throws IOException {
        Enumeration<String> entries = this.archive.entries();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement();
            ArchiveAdapter.Entry entry = new ArchiveAdapter.Entry(name, this.archive.getEntrySize(name), false);
            if (selector.isSelected(entry)) {
                this.handleEntry(name, entry, logger2, entryTask);
            }
            if (!name.endsWith(".jar")) continue;
            this.handleJar(name, logger2);
        }
        if (logger2.isLoggable(level)) {
            logger2.log(level, "Finished parsing " + this.uri);
        }
    }

    public void close() throws IOException {
        this.releaseCount();
    }

    private void releaseCount() throws IOException {
        int release = this.releaseCount.decrementAndGet();
        if (release == 0) {
            this.archive.close();
            if (this.parent != null) {
                this.parent.releaseCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEntry(String name, ArchiveAdapter.Entry entry, Logger logger2, ArchiveAdapter.EntryTask entryTask) throws IOException {
        InputStream is;
        block7: {
            block8: {
                is = null;
                is = this.archive.getEntry(name);
                if (is != null) break block7;
                logger2.log(Level.SEVERE, "Invalid InputStream returned for " + name);
                if (is == null) break block8;
                is.close();
            }
            return;
        }
        try {
            try {
                entryTask.on(entry, is);
            }
            catch (Exception e) {
                logger2.log(Level.SEVERE, localStrings.getLocalString("exception_while_parsing", "Exception while processing {0} inside {1} of size {2}", entry.name, this.archive.getURI(), entry.size), e);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    protected Future handleJar(final String name, final Logger logger2) throws IOException {
        String explodedName = name.replaceAll("[/ ]", "__").replace(".jar", "_jar");
        if (!this.archive.exists(explodedName)) {
            final ReadableArchive subArchive = this.archive.getSubArchive(name);
            if (subArchive == null) {
                logger2.log(Level.SEVERE, localStrings.getLocalString("cannot_open_sub_archive", "Cannot open sub-archive {0} from {1}", name, this.archive.getURI()));
                return null;
            }
            if (subArchive != null) {
                if (logger2.isLoggable(level)) {
                    logger2.log(level, "Spawning sub parsing " + subArchive.getURI());
                }
                final InternalJarAdapter adapter = new InternalJarAdapter(this, subArchive, subArchive.getURI());
                this.releaseCount.incrementAndGet();
                return this.parser.parse(adapter, new Runnable(){

                    public void run() {
                        try {
                            if (logger2.isLoggable(level)) {
                                logger2.log(level, "Closing sub archive " + subArchive.getURI());
                            }
                            adapter.close();
                        }
                        catch (IOException e) {
                            logger2.log(Level.SEVERE, localStrings.getLocalString("exception_while_closing", "Cannot close sub archive {0}", name), e);
                        }
                    }
                });
            }
        }
        return null;
    }

    private class InternalJarAdapter
    extends ReadableArchiveScannerAdapter {
        public InternalJarAdapter(ReadableArchiveScannerAdapter parent, ReadableArchive archive, URI uri) {
            super(parent, archive, uri);
        }

        protected Future handleJar(String name, Logger logger2) throws IOException {
            return null;
        }
    }
}

