/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.APIClassLoaderServiceImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CommonClassLoaderServiceImpl
implements PostConstruct {
    private ClassLoader commonClassLoader;
    @Inject
    APIClassLoaderServiceImpl acls;
    @Inject
    ServerEnvironment env;
    static final Logger logger = LogDomains.getLogger(CommonClassLoaderServiceImpl.class, "javax.enterprise.system.core.classloading");
    private ClassLoader APIClassLoader;
    private String commonClassPath = "";
    private static final String SERVER_EXCLUDED_ATTR_NAME = "GlassFish-ServerExcluded";

    @Override
    public void postConstruct() {
        this.APIClassLoader = this.acls.getAPIClassLoader();
        assert (this.APIClassLoader != null);
        this.createCommonClassLoader();
    }

    private void createCommonClassLoader() {
        File domainLib;
        ArrayList<File> cpElements = new ArrayList<File>();
        File domainDir = this.env.getDomainRoot();
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        if (installRoot != null) {
            File installDir = new File(installRoot);
            File installLibPath = new File(installDir, "lib");
            if (installLibPath.isDirectory()) {
                Collections.addAll(cpElements, installLibPath.listFiles(new CompiletimeJarFileFilter()));
            }
        } else {
            logger.logp(Level.WARNING, "CommonClassLoaderServiceImpl", "createCommonClassLoader", "System property called {0} is null, is this intended?", new Object[]{"com.sun.aas.installRoot"});
        }
        File domainClassesDir = new File(domainDir, "lib/classes/");
        if (domainClassesDir.exists()) {
            cpElements.add(domainClassesDir);
        }
        if ((domainLib = new File(domainDir, "lib/")).isDirectory()) {
            Collections.addAll(cpElements, domainLib.listFiles(new JarFileFilter()));
        }
        cpElements.addAll(this.findDerbyClient());
        ArrayList<URL> urls = new ArrayList<URL>();
        StringBuilder cp = new StringBuilder();
        for (File f : cpElements) {
            try {
                urls.add(f.toURI().toURL());
                if (cp.length() > 0) {
                    cp.append(File.pathSeparator);
                }
                cp.append(f.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                logger.logp(Level.WARNING, "ClassLoaderManager", "postConstruct", "e = {0}", new Object[]{e});
            }
        }
        this.commonClassPath = cp.toString();
        if (!urls.isEmpty()) {
            this.commonClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.APIClassLoader);
        } else {
            logger.logp(Level.FINE, "CommonClassLoaderManager", "Skipping creation of CommonClassLoader as there are no libraries available", "urls = {0}", new Object[]{urls});
        }
    }

    public ClassLoader getCommonClassLoader() {
        return this.commonClassLoader != null ? this.commonClassLoader : this.APIClassLoader;
    }

    public String getCommonClassPath() {
        return this.commonClassPath;
    }

    private List<File> findDerbyClient() {
        String DERBY_HOME_PROP = "AS_DERBY_INSTALL";
        String derbyHome = this.env.getStartupContext().getArguments().getProperty("AS_DERBY_INSTALL", System.getProperty("AS_DERBY_INSTALL"));
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "../db/lib");
        }
        if (!derbyLib.exists()) {
            logger.info("Cannot find javadb client jar file, derby jdbc driver will not be available by default.");
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(derbyLib.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && !name.startsWith("derbyLocale_");
            }
        }));
    }

    private static class CompiletimeJarFileFilter
    extends JarFileFilter {
        private CompiletimeJarFileFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accept(File dir, String name) {
            if (super.accept(dir, name)) {
                File file = new File(dir, name);
                JarFile jar = null;
                try {
                    String exclude;
                    jar = new JarFile(file);
                    Manifest manifest = jar.getManifest();
                    if (manifest != null && (exclude = manifest.getMainAttributes().getValue(CommonClassLoaderServiceImpl.SERVER_EXCLUDED_ATTR_NAME)) != null && exclude.equalsIgnoreCase("true")) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "CommonClassLoaderServiceImpl is unable to process " + file.getAbsolutePath() + " because of exception.", e);
                }
                finally {
                    try {
                        if (jar != null) {
                            jar.close();
                        }
                    }
                    catch (IOException e) {}
                }
                return true;
            }
            return false;
        }
    }

    private static class JarFileFilter
    implements FilenameFilter {
        private final String JAR_EXT = ".jar";

        private JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

