/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="delete-node-config")
@I18n(value="delete.node.config")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class DeleteNodeConfigCommand
implements AdminCommand,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    Nodes nodes;
    @Inject
    private CommandRunner cr;
    @Param(name="name", primary=true)
    String name;
    private RemoteInstanceCommandHelper helper;

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.logger;
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            String msg = Strings.get("noSuchNode", this.name);
            logger2.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (!node.getType().equals("CONFIG")) {
            String msg = Strings.get("notConfigNodeType", this.name);
            logger2.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_delete-node", report);
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", this.name);
        ci.parameters(map);
        ci.execute();
    }
}

