/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.ResourceNamingService;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glassfish.javaee.services.DataSourceDefinitionProxy;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DataSourceDefinitionDeployer
implements ResourceDeployer {
    @Inject
    private Habitat habitat;
    private static Logger _logger = LogDomains.getLogger(DataSourceDefinitionDeployer.class, "javax.enterprise.resource.resourceadapter");

    @Override
    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(Object resource) throws Exception {
        DataSourceDefinitionDescriptor desc = (DataSourceDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveDataSourceDefinitionPoolName(desc.getResourceId(), desc.getName());
        String resourceName = ConnectorsUtil.deriveDataSourceDefinitionResourceName(desc.getResourceId(), desc.getName());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "DataSourceDefinitionDeployer.deployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyJdbcConnectionPool jdbcCp = new MyJdbcConnectionPool(desc, poolName);
        Collection<ResourceDeployer> deployers = this.habitat.getAllByContract(ResourceDeployer.class);
        this.getDeployer(jdbcCp, deployers).deployResource(jdbcCp);
        MyJdbcResource jdbcResource = new MyJdbcResource(poolName, resourceName);
        this.getDeployer(jdbcResource, deployers).deployResource(jdbcResource);
    }

    private ResourceDeployer getDeployer(Object resource, Collection<ResourceDeployer> deployers) {
        ResourceDeployer resourceDeployer = null;
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            resourceDeployer = deployer;
            break;
        }
        return resourceDeployer;
    }

    private DataSourceProperty convertProperty(String name, String value) {
        return new DataSourceProperty(name, value);
    }

    public void registerDataSourceDefinitions(Application application) {
        String appName = application.getAppName();
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle2 : bundles) {
            this.registerDataSourceDefinitions(appName, bundle2);
            Collection<RootDeploymentDescriptor> dds = bundle2.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.registerDataSourceDefinitions(appName, dd);
            }
        }
    }

    private void registerDataSourceDefinitions(String appName, Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)descriptor);
            for (DataSourceDefinitionDescriptor dsd : env.getDataSourceDefinitionDescriptors()) {
                this.registerDSDReferredByApplication(appName, dsd);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set<EjbDescriptor> ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (DataSourceDefinitionDescriptor dsd : ejbDescriptor.getDataSourceDefinitionDescriptors()) {
                    this.registerDSDReferredByApplication(appName, dsd);
                }
            }
            Set<EjbInterceptor> ejbInterceptors = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                for (DataSourceDefinitionDescriptor dsd : ejbInterceptor.getDataSourceDefinitionDescriptors()) {
                    this.registerDSDReferredByApplication(appName, dsd);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set<ManagedBeanDescriptor> managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor mbd : managedBeanDescriptors) {
                for (DataSourceDefinitionDescriptor dsd : mbd.getDataSourceDefinitionDescriptors()) {
                    this.registerDSDReferredByApplication(appName, dsd);
                }
            }
        }
    }

    private void unregisterDSDReferredByApplication(DataSourceDefinitionDescriptor dsd) {
        try {
            if (dsd.isDeployed()) {
                this.undeployResource(dsd);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "exception while unregistering DSD [ " + dsd.getName() + " ]", e);
        }
    }

    public void unRegisterDataSourceDefinitions(Application application) {
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle2 : bundles) {
            this.unRegisterDataSourceDefinitions(bundle2);
            Collection<RootDeploymentDescriptor> dds = bundle2.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.unRegisterDataSourceDefinitions(dd);
            }
        }
    }

    private void unRegisterDataSourceDefinitions(Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)descriptor);
            for (DataSourceDefinitionDescriptor dsd : env.getDataSourceDefinitionDescriptors()) {
                this.unregisterDSDReferredByApplication(dsd);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set<EjbDescriptor> ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (DataSourceDefinitionDescriptor dsd : ejbDescriptor.getDataSourceDefinitionDescriptors()) {
                    this.unregisterDSDReferredByApplication(dsd);
                }
            }
            Set<EjbInterceptor> ejbInterceptors = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                for (DataSourceDefinitionDescriptor dsd : ejbInterceptor.getDataSourceDefinitionDescriptors()) {
                    this.unregisterDSDReferredByApplication(dsd);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set<ManagedBeanDescriptor> managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor mbd : managedBeanDescriptors) {
                for (DataSourceDefinitionDescriptor dsd : mbd.getDataSourceDefinitionDescriptors()) {
                    this.unregisterDSDReferredByApplication(dsd);
                }
            }
        }
    }

    private void registerDSDReferredByApplication(String appName, DataSourceDefinitionDescriptor dsd) {
        if (!dsd.isDeployed()) {
            DataSourceDefinitionProxy proxy = this.habitat.getComponent(DataSourceDefinitionProxy.class);
            ResourceNamingService resourceNamingService = this.habitat.getComponent(ResourceNamingService.class);
            proxy.setDescriptor(dsd);
            String moduleName = null;
            if (dsd.getName().startsWith("java:app/")) {
                dsd.setResourceId(appName);
            }
            if (dsd.getName().startsWith("java:global/") || dsd.getName().startsWith("java:app/")) {
                ResourceInfo resourceInfo = new ResourceInfo(dsd.getName(), appName, moduleName);
                try {
                    resourceNamingService.publishObject(resourceInfo, proxy, true);
                    dsd.setDeployed(true);
                }
                catch (NamingException e) {
                    Object[] params = new Object[]{appName, dsd.getName(), e};
                    _logger.log(Level.WARNING, "dsd.registration.failed", params);
                }
            }
        }
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void undeployResource(Object resource) throws Exception {
        DataSourceDefinitionDescriptor desc = (DataSourceDefinitionDescriptor)resource;
        Collection<ResourceDeployer> deployers = this.habitat.getAllByContract(ResourceDeployer.class);
        String poolName = ConnectorsUtil.deriveDataSourceDefinitionPoolName(desc.getResourceId(), desc.getName());
        String resourceName = ConnectorsUtil.deriveDataSourceDefinitionResourceName(desc.getResourceId(), desc.getName());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "DataSourceDefinitionDeployer.undeployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyJdbcResource jdbcResource = new MyJdbcResource(poolName, resourceName);
        this.getDeployer(jdbcResource, deployers).undeployResource(jdbcResource);
        MyJdbcConnectionPool jdbcCp = new MyJdbcConnectionPool(desc, poolName);
        this.getDeployer(jdbcCp, deployers).undeployResource(jdbcCp);
        desc.setDeployed(false);
    }

    @Override
    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for datasource-definition type");
    }

    @Override
    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for datasource-definition type");
    }

    @Override
    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for datasource-definition type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof DataSourceDefinitionDescriptor;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyJdbcConnectionPool
    extends FakeConfigBean
    implements JdbcConnectionPool {
        private DataSourceDefinitionDescriptor desc;
        private String name;

        public MyJdbcConnectionPool(DataSourceDefinitionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        @Override
        public String getDatasourceClassname() {
            if (!this.getResType().equals("java.sql.Driver")) {
                return this.desc.getClassName();
            }
            return null;
        }

        @Override
        public void setDatasourceClassname(String value) throws PropertyVetoException {
        }

        @Override
        public String getResType() {
            String type2;
            block9: {
                type2 = "javax.sql.DataSource";
                try {
                    Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(this.desc.getClassName());
                    if (XADataSource.class.isAssignableFrom(clz)) {
                        type2 = "javax.sql.XADataSource";
                    } else if (ConnectionPoolDataSource.class.isAssignableFrom(clz)) {
                        type2 = "javax.sql.ConnectionPoolDataSource";
                    } else if (DataSource.class.isAssignableFrom(clz)) {
                        type2 = "javax.sql.DataSource";
                    } else if (Driver.class.isAssignableFrom(clz)) {
                        type2 = "java.sql.Driver";
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!_logger.isLoggable(Level.FINEST)) break block9;
                    _logger.log(Level.FINEST, "Unable to load class [ " + this.desc.getClassName() + " ] to " + "determine its res-type, defaulting to [" + "javax.sql.DataSource" + "]");
                }
            }
            return type2;
        }

        @Override
        public void setResType(String value) throws PropertyVetoException {
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getSteadyPoolSize() {
            int minPoolSize = this.desc.getMinPoolSize();
            if (minPoolSize == -1) {
                minPoolSize = 8;
            }
            return String.valueOf(minPoolSize);
        }

        @Override
        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxPoolSize() {
            int maxPoolSize = this.desc.getMaxPoolSize();
            if (maxPoolSize == -1) {
                maxPoolSize = 32;
            }
            return String.valueOf(maxPoolSize);
        }

        @Override
        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxWaitTimeInMillis() {
            return String.valueOf(60000);
        }

        @Override
        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        @Override
        public String getPoolResizeQuantity() {
            return String.valueOf(2);
        }

        @Override
        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdleTimeoutInSeconds() {
            long maxIdleTime = this.desc.getMaxIdleTime();
            if (maxIdleTime == -1L) {
                maxIdleTime = 300L;
            }
            return String.valueOf(maxIdleTime);
        }

        @Override
        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransactionIsolationLevel() {
            if (this.desc.getIsolationLevel() == -1) {
                return null;
            }
            return ConnectorsUtil.getTransactionIsolationInt(this.desc.getIsolationLevel());
        }

        @Override
        public void setTransactionIsolationLevel(String value) throws PropertyVetoException {
        }

        @Override
        public String getIsIsolationLevelGuaranteed() {
            return String.valueOf("true");
        }

        @Override
        public void setIsIsolationLevelGuaranteed(String value) throws PropertyVetoException {
        }

        @Override
        public String getIsConnectionValidationRequired() {
            return String.valueOf("false");
        }

        @Override
        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionValidationMethod() {
            return null;
        }

        @Override
        public void setConnectionValidationMethod(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidationTableName() {
            return null;
        }

        @Override
        public void setValidationTableName(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidationClassname() {
            return null;
        }

        @Override
        public void setValidationClassname(String value) throws PropertyVetoException {
        }

        @Override
        public String getFailAllConnections() {
            return String.valueOf("false");
        }

        @Override
        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getNonTransactionalConnections() {
            return String.valueOf(!this.desc.isTransactional());
        }

        @Override
        public void setNonTransactionalConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getAllowNonComponentCallers() {
            return String.valueOf("false");
        }

        @Override
        public void setAllowNonComponentCallers(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidateAtmostOncePeriodInSeconds() {
            return String.valueOf(0);
        }

        @Override
        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakTimeoutInSeconds() {
            return String.valueOf(0);
        }

        @Override
        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakReclaim() {
            return String.valueOf(false);
        }

        @Override
        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryAttempts() {
            return String.valueOf(0);
        }

        @Override
        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryIntervalInSeconds() {
            return String.valueOf(10);
        }

        @Override
        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementTimeoutInSeconds() {
            return String.valueOf(-1);
        }

        @Override
        public void setStatementTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionEnlistment() {
            return String.valueOf(false);
        }

        @Override
        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionAssociation() {
            return String.valueOf(false);
        }

        @Override
        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        @Override
        public String getAssociateWithThread() {
            return String.valueOf(false);
        }

        @Override
        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        @Override
        public String getPooling() {
            return String.valueOf(true);
        }

        @Override
        public void setPooling(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementCacheSize() {
            return String.valueOf(0);
        }

        @Override
        public void setStatementCacheSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMatchConnections() {
            return String.valueOf(true);
        }

        @Override
        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxConnectionUsageCount() {
            return String.valueOf(0);
        }

        @Override
        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        @Override
        public String getWrapJdbcObjects() {
            return String.valueOf(true);
        }

        @Override
        public void setWrapJdbcObjects(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.desc.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            DataSourceProperty property;
            Properties p = this.desc.getProperties();
            ArrayList<Property> dataSourceProperties = new ArrayList<Property>();
            for (Object o : p.keySet()) {
                String key = (String)o;
                String value = (String)p.get(o);
                DataSourceProperty dp = DataSourceDefinitionDeployer.this.convertProperty(key, value);
                dataSourceProperties.add(dp);
            }
            if (this.desc.getUser() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("user", String.valueOf(this.desc.getUser()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getPassword() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("password", String.valueOf(this.desc.getPassword()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getDatabaseName() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("databaseName", String.valueOf(this.desc.getDatabaseName()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getServerName() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("serverName", String.valueOf(this.desc.getServerName()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getPortNumber() != -1) {
                property = DataSourceDefinitionDeployer.this.convertProperty("portNumber", String.valueOf(this.desc.getPortNumber()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getUrl() != null && !this.isStandardPropertiesSet(this.desc)) {
                property = DataSourceDefinitionDeployer.this.convertProperty("url", String.valueOf(this.desc.getUrl()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getLoginTimeout() != 0L) {
                property = DataSourceDefinitionDeployer.this.convertProperty("loginTimeout", String.valueOf(this.desc.getLoginTimeout()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getMaxStatements() != -1) {
                property = DataSourceDefinitionDeployer.this.convertProperty("maxStatements", String.valueOf(this.desc.getMaxStatements()));
                dataSourceProperties.add(property);
            }
            return dataSourceProperties;
        }

        private boolean isStandardPropertiesSet(DataSourceDefinitionDescriptor desc) {
            boolean result = false;
            if (desc.getServerName() != null && desc.getDatabaseName() != null && desc.getPortNumber() != -1) {
                result = true;
            }
            return result;
        }

        @Override
        public Property getProperty(String name) {
            String value = (String)this.desc.getProperties().get(name);
            return new DataSourceProperty(name, value);
        }

        @Override
        public String getPropertyValue(String name) {
            return (String)this.desc.getProperties().get(name);
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            String value = null;
            value = (String)this.desc.getProperties().get(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        @Override
        public void injectedInto(Object o) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
        }

        @Override
        public String getSqlTraceListeners() {
            return null;
        }

        @Override
        public void setSqlTraceListeners(String value) throws PropertyVetoException {
        }

        @Override
        public String getPing() {
            return String.valueOf(false);
        }

        @Override
        public void setPing(String value) throws PropertyVetoException {
        }

        @Override
        public String getInitSql() {
            return null;
        }

        @Override
        public void setInitSql(String value) throws PropertyVetoException {
        }

        @Override
        public String getDriverClassname() {
            if (this.getResType().equals("java.sql.Driver")) {
                return this.desc.getClassName();
            }
            return null;
        }

        @Override
        public void setDriverClassname(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementLeakTimeoutInSeconds() {
            return String.valueOf(0);
        }

        @Override
        public void setStatementLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementLeakReclaim() {
            return String.valueOf(false);
        }

        @Override
        public void setStatementLeakReclaim(String value) throws PropertyVetoException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyJdbcResource
    extends FakeConfigBean
    implements JdbcResource {
        private String poolName;
        private String jndiName;

        MyJdbcResource(String poolName, String jndiName) {
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        @Override
        public String getPoolName() {
            return this.poolName;
        }

        @Override
        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = value;
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getEnabled() {
            return String.valueOf(true);
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            return null;
        }

        @Override
        public Property getProperty(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        @Override
        public void injectedInto(Object o) {
        }

        @Override
        public String getJndiName() {
            return this.jndiName;
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = value;
        }
    }

    class DataSourceProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        DataSourceProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

