/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceWrapper
implements XAResource {
    private XAResource res;
    private static Logger _logger = LogDomains.getLogger(XAResourceWrapper.class, "javax.enterprise.resource.resourceadapter");

    public XAResourceWrapper(XAResource res) {
        this.res = res;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.print("XAResource.commit: " + XAResourceWrapper.xidToString(xid) + "," + onePhase);
        this.res.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.print("XAResource.end: " + XAResourceWrapper.xidToString(xid) + "," + XAResourceWrapper.flagToString(flags));
        this.res.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this.print("XAResource.forget: " + XAResourceWrapper.xidToString(xid));
        this.res.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.res.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof XAResourceWrapper) {
            XAResourceWrapper other = (XAResourceWrapper)xares;
            boolean result = this.res.isSameRM(other.res);
            this.print("XAResource.isSameRM: " + this.res + "," + other.res + "," + result);
            return result;
        }
        boolean result = this.res.isSameRM(xares);
        this.print("XAResource.isSameRM: " + this.res + "," + xares + "," + result);
        return result;
    }

    public int prepare(Xid xid) throws XAException {
        this.print("XAResource.prepare: " + XAResourceWrapper.xidToString(xid));
        int result = this.res.prepare(xid);
        this.print("prepare result = " + XAResourceWrapper.flagToString(result));
        return result;
    }

    public Xid[] recover(int flag) throws XAException {
        this.print("XAResource.recover: " + XAResourceWrapper.flagToString(flag));
        return this.res.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.print("XAResource.rollback: " + XAResourceWrapper.xidToString(xid));
        this.res.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.res.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.print("XAResource.start: " + XAResourceWrapper.xidToString(xid) + "," + XAResourceWrapper.flagToString(flags));
        this.res.start(xid, flags);
    }

    private void print(String s) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, s);
        }
    }

    private static String xidToString(Xid xid) {
        return String.valueOf((new String(xid.getGlobalTransactionId()) + new String(xid.getBranchQualifier())).hashCode());
    }

    private static String flagToString(int flag) {
        switch (flag) {
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x40000000: {
                return "TMONEPHASE";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
            case 3: {
                return "XA_RDONLY";
            }
        }
        return "" + Integer.toHexString(flag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof XAResourceWrapper) {
            XAResource other = ((XAResourceWrapper)obj).res;
            return this.res.equals(other);
        }
        if (obj instanceof XAResource) {
            XAResource other = (XAResource)obj;
            return this.res.equals(other);
        }
        return false;
    }

    public int hashCode() {
        return this.res.hashCode();
    }
}

