/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Node;

public class ContainerTransactionNode
extends DeploymentDescriptorNode {
    private String trans_attribute;
    private String description;
    private Vector methods = new Vector();

    public ContainerTransactionNode() {
        this.registerElementHandler(new XMLElement("method"), MethodNode.class);
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof MethodDescriptor) {
            this.methods.add(newDescriptor);
        }
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean endElement(XMLElement element) {
        boolean doneWithNode = super.endElement(element);
        if (doneWithNode) {
            ContainerTransaction ct = new ContainerTransaction(this.trans_attribute, this.description);
            for (MethodDescriptor md : this.methods) {
                EjbBundleDescriptor bundle2 = (EjbBundleDescriptor)this.getParentNode().getDescriptor();
                EjbDescriptor ejb = bundle2.getEjbByName(md.getEjbName(), true);
                ejb.getMethodContainerTransactions().put(md, ct);
            }
        }
        return doneWithNode;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("description".equals(element.getQName())) {
            this.description = value;
        }
        if ("trans-attribute".equals(element.getQName())) {
            this.trans_attribute = value;
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, EjbDescriptor ejb) {
        Hashtable methodToTransactions = ejb.getMethodContainerTransactions();
        MethodNode mn = new MethodNode();
        for (MethodDescriptor md : methodToTransactions.keySet()) {
            Node ctNode = super.writeDescriptor(parent, nodeName, ejb);
            ContainerTransaction ct = (ContainerTransaction)methodToTransactions.get(md);
            ContainerTransactionNode.appendTextChild(ctNode, "description", ct.getDescription());
            mn.writeDescriptor(ctNode, "method", md, ejb.getName());
            ContainerTransactionNode.appendTextChild(ctNode, "trans-attribute", ct.getTransactionAttribute());
        }
        return null;
    }
}

