/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.CompositeArchivist;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.util.XModuleType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.api.ContractProvider;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ArchivistFactory
implements ContractProvider,
PostConstruct {
    @Inject
    Archivist[] archivists;
    @Inject
    CompositeArchivist[] compositeArchivists;
    @Inject(optional=true)
    ExtensionsArchivist[] extensionsArchivists;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Habitat habitat;

    public Archivist getArchivist(ReadableArchive archive, ClassLoader cl) throws IOException {
        Archivist archivist = this.getPrivateArchivistFor(archive);
        if (archivist != null) {
            archivist.setClassLoader(cl);
        }
        return archivist;
    }

    public Archivist getArchivist(XModuleType moduleType) throws IOException {
        return this.getPrivateArchivistFor(moduleType);
    }

    public List<ExtensionsArchivist> getExtensionsArchists(XModuleType moduleType) {
        ArrayList<ExtensionsArchivist> archivists = new ArrayList<ExtensionsArchivist>();
        for (ExtensionsArchivist ea : this.extensionsArchivists) {
            if (!ea.supportsModuleType(moduleType)) continue;
            archivists.add(ea);
        }
        return archivists;
    }

    Archivist getPrivateArchivistFor(XModuleType moduleType) throws IOException {
        for (Archivist pa : this.archivists) {
            Archivist a = (Archivist)Archivist.class.cast(pa);
            if (!a.getModuleType().equals(moduleType)) continue;
            return this.copyOf(a);
        }
        return null;
    }

    Archivist getPrivateArchivistFor(ReadableArchive archive) throws IOException {
        Archivist a = this.getPrivateArchivistFor(archive, this.compositeArchivists);
        if (a == null) {
            a = this.getPrivateArchivistFor(archive, this.archivists);
        }
        return a;
    }

    private Archivist getPrivateArchivistFor(ReadableArchive archive, Object[] aa) throws IOException {
        Archivist a;
        for (Object pa : aa) {
            Archivist a2 = (Archivist)Archivist.class.cast(pa);
            if (!a2.hasStandardDeploymentDescriptor(archive) && !a2.hasRuntimeDeploymentDescriptor(archive)) continue;
            return this.copyOf(a2);
        }
        String uri = archive.getURI().getPath();
        File file = new File(uri);
        if (!file.isDirectory() && !uri.endsWith(".jar")) {
            for (Object pa : aa) {
                a = (Archivist)Archivist.class.cast(pa);
                if (!uri.endsWith(a.getArchiveExtension())) continue;
                return this.copyOf(a);
            }
        }
        for (Object pa : aa) {
            a = (Archivist)Archivist.class.cast(pa);
            if (!a.postHandles(archive)) continue;
            return this.copyOf(a);
        }
        return null;
    }

    private Archivist copyOf(Archivist a) {
        try {
            return (Archivist)this.habitat.getComponent(a.getClass());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void postConstruct() {
        LinkedList<Archivist> sortedArchivists = new LinkedList<Archivist>();
        for (Archivist a : this.archivists) {
            if (a instanceof AppClientArchivist) {
                sortedArchivists.addLast(a);
                continue;
            }
            sortedArchivists.addFirst(a);
        }
        this.archivists = sortedArchivists.toArray(new Archivist[sortedArchivists.size()]);
    }
}

