/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.util.PortConstants;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServerPorts {
    private Server server;
    private final Map<String, Integer> props = new HashMap<String, Integer>();

    ServerPorts(Cluster cluster, Config config, Domain domain, Server theServer) {
        this.initialize(cluster, config, domain, theServer);
    }

    ServerPorts(Domain domain, Server theServer) {
        String configName;
        Cluster cluster = null;
        Config config = null;
        if (theServer.isInstance()) {
            cluster = domain.getClusterForInstance(theServer.getName());
        }
        if (StringUtils.ok(configName = theServer.getConfigRef())) {
            config = domain.getConfigNamed(configName);
        }
        this.initialize(cluster, config, domain, theServer);
    }

    Map<String, Integer> getMap() {
        return this.props;
    }

    private void initialize(Cluster cluster, Config config, Domain domain, Server theServer) {
        this.server = theServer;
        List<SystemProperty> propList = domain.getSystemProperty();
        this.addAll(propList);
        if (cluster != null) {
            propList = cluster.getSystemProperty();
            this.addAll(propList);
        }
        if (config != null) {
            propList = config.getSystemProperty();
            this.addAll(propList);
        }
        propList = this.server.getSystemProperty();
        this.addAll(propList);
    }

    private void addAll(List<SystemProperty> propList) {
        if (propList == null) {
            return;
        }
        for (SystemProperty sp : propList) {
            String name = sp.getName();
            String value = sp.getValue();
            if (!StringUtils.ok(name) || !StringUtils.ok(value) || !PortConstants.PORTSLIST.contains(name)) continue;
            try {
                int port = Integer.parseInt(value);
                if (!NetUtils.isPortValid(port)) continue;
                this.props.put(name, port);
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServerPorts Dump:").append('\n');
        sb.append("server: ").append(this.server.getName()).append(", ");
        sb.append("Properties: ").append(this.props).append('\n');
        return sb.toString();
    }
}

