/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.spi.distributed;

import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.transaction.api.RecoveryResourceRegistry;
import com.sun.enterprise.transaction.spi.RecoveryEventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.api.DistributedEJBTimerService;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class DistributedEJBTimerServiceImpl
implements DistributedEJBTimerService,
RecoveryEventListener,
PostConstruct,
CallBack {
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    GMSAdapterService gmsAdapterService;
    @Inject
    RecoveryResourceRegistry recoveryResourceRegistry;

    public void postConstruct() {
        if (!this.ejbContainerUtil.isDas()) {
            GMSAdapter gmsAdapter;
            if (this.gmsAdapterService != null && (gmsAdapter = this.gmsAdapterService.getGMSAdapter()) != null) {
                gmsAdapter.registerPlannedShutdownListener(this);
            }
            this.setPerformDBReadBeforeTimeout(true);
            this.recoveryResourceRegistry.addEventListener(this);
        }
    }

    public void processNotification(Signal signal) {
        Logger logger2 = this.ejbContainerUtil.getLogger();
        if (signal instanceof PlannedShutdownSignal) {
            PlannedShutdownSignal pssig;
            if (logger2.isLoggable(Level.FINE)) {
                logger2.log(Level.FINE, "[DistributedEJBTimerServiceImpl] planned shutdown signal: " + signal);
            }
            if ((pssig = (PlannedShutdownSignal)signal).getEventSubType() == GMSConstants.shutdownType.INSTANCE_SHUTDOWN) {
                this.migrateTimers(signal.getMemberToken());
            }
        } else if (logger2.isLoggable(Level.FINE)) {
            logger2.log(Level.FINE, "[DistributedEJBTimerServiceImpl] ignoring signal: " + signal);
        }
    }

    public void beforeRecovery(boolean delegated, String instance) {
    }

    public void afterRecovery(boolean success, boolean delegated, String instance) {
        if (!delegated) {
            return;
        }
        Logger logger2 = this.ejbContainerUtil.getLogger();
        if (logger2.isLoggable(Level.INFO)) {
            logger2.log(Level.INFO, "[DistributedEJBTimerServiceImpl] afterRecovery event for instance " + instance);
        }
        if (instance != null && !instance.equals(this.ejbContainerUtil.getServerEnvironment().getInstanceName())) {
            if (success) {
                this.migrateTimers(instance);
            } else {
                logger2.log(Level.WARNING, "[DistributedEJBTimerServiceImpl] Cannot perform automatic timer migration after failed transaction recovery");
            }
        }
    }

    public int migrateTimers(String serverId) {
        Logger logger2 = this.ejbContainerUtil.getLogger();
        if (logger2.isLoggable(Level.INFO)) {
            logger2.log(Level.INFO, "[DistributedEJBTimerServiceImpl] migrating timers from " + serverId);
        }
        int result = 0;
        EJBTimerService ejbTimerService = this.ejbContainerUtil.getEJBTimerService();
        if (ejbTimerService != null) {
            result = ejbTimerService.migrateTimers(serverId);
        }
        return result;
    }

    public String[] listTimers(String[] serverIds) {
        String[] result = new String[serverIds.length];
        EJBTimerService ejbTimerService = this.ejbContainerUtil.getEJBTimerService();
        if (ejbTimerService != null) {
            result = ejbTimerService.listTimers(serverIds);
        } else {
            for (int i = 0; i < serverIds.length; ++i) {
                result[i] = "0";
            }
        }
        return result;
    }

    public void setPerformDBReadBeforeTimeout(boolean defaultDBReadValue) {
        this.ejbContainerUtil.setEJBTimerServiceDBReadBeforeTimeout(defaultDBReadValue);
    }
}

