/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.graph;

import com.sun.corba.ee.impl.orbutil.graph.Graph;
import com.sun.corba.ee.impl.orbutil.graph.Node;
import com.sun.corba.ee.impl.orbutil.graph.NodeData;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GraphImpl<T extends Node<T>>
extends AbstractSet<T>
implements Graph<T> {
    private Map<T, NodeData> nodeToData = new HashMap<T, NodeData>();

    public GraphImpl() {
    }

    public GraphImpl(Collection<T> coll) {
        this();
        this.addAll(coll);
    }

    @Override
    public boolean add(T obj) {
        boolean found = this.nodeToData.keySet().contains(obj);
        if (!found) {
            NodeData nd = new NodeData();
            this.nodeToData.put(obj, nd);
        }
        return !found;
    }

    @Override
    public Iterator<T> iterator() {
        return this.nodeToData.keySet().iterator();
    }

    @Override
    public int size() {
        return this.nodeToData.keySet().size();
    }

    @Override
    public NodeData getNodeData(T node) {
        return this.nodeToData.get(node);
    }

    private void clearNodeData() {
        for (Map.Entry<T, NodeData> entry : this.nodeToData.entrySet()) {
            entry.getValue().clear();
        }
    }

    void visitAll(NodeVisitor<T> nv) {
        boolean done = false;
        do {
            done = true;
            ArrayList<Map.Entry<T, NodeData>> entries = new ArrayList<Map.Entry<T, NodeData>>(this.nodeToData.entrySet());
            for (Map.Entry entry : entries) {
                Node node = (Node)entry.getKey();
                NodeData nd = (NodeData)entry.getValue();
                if (nd.isVisited()) continue;
                nd.visited();
                done = false;
                nv.visit(this, node, nd);
            }
        } while (!done);
    }

    private void markNonRoots() {
        this.visitAll(new NodeVisitor<T>(){

            @Override
            public void visit(Graph<T> graph, T node, NodeData nd) {
                for (Node child : node.getChildren()) {
                    graph.add(child);
                    NodeData cnd = graph.getNodeData(child);
                    cnd.notRoot();
                }
            }
        });
    }

    private Set<T> collectRootSet() {
        HashSet<Node> result = new HashSet<Node>();
        for (Map.Entry<T, NodeData> entry : this.nodeToData.entrySet()) {
            Node node = (Node)entry.getKey();
            NodeData nd = entry.getValue();
            if (!nd.isRoot()) continue;
            result.add(node);
        }
        return result;
    }

    @Override
    public Set<T> getRoots() {
        this.clearNodeData();
        this.markNonRoots();
        return this.collectRootSet();
    }

    static interface NodeVisitor<T extends Node> {
        public void visit(Graph<T> var1, T var2, NodeData var3);
    }
}

