/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Formatter;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private Logger logger;
    private Level level;
    private ThreadLocal reentrant = new ThreadLocal();

    public LoggingOutputStream(Logger logger2, Level level) {
        this.logger = logger2;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        String record = null;
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            record = this.toString();
            super.reset();
        }
        if (record != null) {
            if (record.length() == 0 || record.equals(this.lineSeparator)) {
                return;
            }
            if (this.reentrant.get() != null) {
                return;
            }
            try {
                this.reentrant.set(this);
                this.logger.logp(this.level, "", "", record);
            }
            finally {
                this.reentrant.set(null);
            }
        }
    }

    private class StackTraceObjects {
        private ByteArrayOutputStream stackTraceBuf = new ByteArrayOutputStream();
        private PrintStream stStream = new PrintStream(this.stackTraceBuf, true);
        private String stString;
        private ByteArrayOutputStream comparisonBuf = new ByteArrayOutputStream();
        private int comparisonBufIndex = 0;
        private PrintStream cbStream = new PrintStream(this.comparisonBuf, true);
        private int stackTraceBufBytes = 0;
        private int charsIgnored = 0;

        private StackTraceObjects(Throwable x) {
            x.printStackTrace(this.stStream);
            this.stString = this.stackTraceBuf.toString();
            this.stackTraceBufBytes = this.stackTraceBuf.size();
            this.cbStream.println(x);
        }

        public String toString() {
            return this.stString;
        }

        boolean ignorePrintln(String str) {
            this.cbStream.println(str);
            String cbString = this.comparisonBuf.toString();
            int cbLen = cbString.length();
            if (this.stString.regionMatches(this.charsIgnored, cbString, 0, cbLen)) {
                this.charsIgnored += cbLen;
                this.comparisonBuf.reset();
                return true;
            }
            return false;
        }

        boolean checkCompletion() {
            return this.charsIgnored >= this.stackTraceBufBytes;
        }
    }

    public class LoggingPrintStream
    extends PrintStream {
        LogManager logManager;
        private ThreadLocal perThreadStObjects;

        public LoggingPrintStream(ByteArrayOutputStream os) {
            super(os, true);
            this.logManager = LogManager.getLogManager();
            this.perThreadStObjects = new ThreadLocal();
        }

        public void setLogger(Logger l) {
            LoggingOutputStream.this.logger = l;
        }

        public void println(Object x) {
            if (!this.checkLocks()) {
                return;
            }
            StackTraceObjects sTO = (StackTraceObjects)this.perThreadStObjects.get();
            if (sTO != null) {
                this.perThreadStObjects.set(null);
            }
            if (!(x instanceof Throwable)) {
                super.println(x);
                return;
            }
            sTO = new StackTraceObjects((Throwable)x);
            this.perThreadStObjects.set(sTO);
            super.println(sTO.toString());
        }

        public void println(String str) {
            if (!this.checkLocks()) {
                return;
            }
            StackTraceObjects sTO = (StackTraceObjects)this.perThreadStObjects.get();
            if (sTO == null) {
                super.println(str);
                return;
            }
            if (!sTO.ignorePrintln(str)) {
                this.perThreadStObjects.set(null);
                super.println(str);
                return;
            }
            if (sTO.checkCompletion()) {
                this.perThreadStObjects.set(null);
                return;
            }
        }

        public PrintStream printf(String str, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.getDefault());
            formatter.format(str, args);
            this.print(sb.toString());
            return null;
        }

        public PrintStream printf(Locale locale, String str, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, locale);
            formatter.format(str, args);
            this.print(sb.toString());
            return null;
        }

        public PrintStream format(String format, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.getDefault());
            formatter.format(Locale.getDefault(), format, args);
            this.print(sb.toString());
            return null;
        }

        public PrintStream format(Locale locale, String format, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, locale);
            formatter.format(locale, format, args);
            this.print(sb.toString());
            return null;
        }

        public void print(String x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void print(Object x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void print(boolean x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(boolean x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(char x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(char x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(int x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(int x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(long x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(long x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(float x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(float x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(double x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(double x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(char[] x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(char[] x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void println() {
            if (this.checkLocks()) {
                super.println();
            }
        }

        public void write(byte[] buf, int off, int len) {
            if (this.checkLocks()) {
                super.write(buf, off, len);
            }
        }

        public void write(int b) {
            if (this.checkLocks()) {
                super.write(b);
            }
        }

        private boolean checkLocks() {
            Thread t = Thread.currentThread();
            if (!Thread.holdsLock(LoggingOutputStream.this.logger)) {
                if (!Thread.holdsLock(this.logManager)) {
                    return true;
                }
            }
            return false;
        }
    }
}

