/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.enterprise.util.Utility;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;

public class NonBlockingPool
extends AbstractPool {
    private String poolName;
    private TimerTask poolTimerTask;
    protected boolean addedResizeTask = false;
    protected volatile boolean addedIdleBeanWork = false;
    protected boolean inResizing = false;
    private boolean maintainSteadySize = false;
    private boolean singletonBeanPool;
    private boolean poolClosed = false;
    private int resizeTaskCount;

    protected NonBlockingPool() {
    }

    public NonBlockingPool(long beanId, String poolName, ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this(beanId, poolName, factory, steadyPoolSize, resizeQuantity, maxPoolSize, idleTimeoutInSeconds, loader, false);
    }

    public NonBlockingPool(long beanId, String poolName, ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader, boolean singletonBeanPool) {
        this.poolName = poolName;
        this.beanId = beanId;
        this.singletonBeanPool = singletonBeanPool && steadyPoolSize == 1 && maxPoolSize == 1;
        this.initializePool(factory, steadyPoolSize, resizeQuantity, maxPoolSize, idleTimeoutInSeconds, loader);
    }

    protected void initializePool(ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this.list = new ArrayList();
        this.factory = factory;
        this.steadyPoolSize = steadyPoolSize <= 0 ? 0 : steadyPoolSize;
        this.resizeQuantity = resizeQuantity <= 0 ? 0 : resizeQuantity;
        this.maxPoolSize = maxPoolSize <= 0 ? Integer.MAX_VALUE : maxPoolSize;
        this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds <= 0 || this.singletonBeanPool ? 0 : idleTimeoutInSeconds;
        this.containerClassLoader = loader;
        boolean bl = this.singletonBeanPool ? false : (this.maintainSteadySize = this.steadyPoolSize > 0);
        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) {
            try {
                this.poolTimerTask = new PoolResizeTimerTask();
                EjbContainerUtilImpl.getInstance().getTimer().scheduleAtFixedRate(this.poolTimerTask, (long)idleTimeoutInSeconds * 1000L, (long)idleTimeoutInSeconds * 1000L);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Could not add" + " PoolTimerTask. Continuing anyway...", th);
            }
        }
    }

    @Override
    public void setContainerClassLoader(ClassLoader loader) {
        this.containerClassLoader = loader;
    }

    @Override
    public Object getObject(boolean canWait, Object param) throws PoolException {
        return this.getObject(param);
    }

    @Override
    public Object getObject(long maxWaitTime, Object param) throws PoolException {
        return this.getObject(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(Object param) {
        boolean toAddResizeTask = false;
        Object obj = null;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            if (size > this.steadyPoolSize) {
                ++this.poolSuccess;
                return this.list.remove(size - 1);
            }
            if (size > 0) {
                ++this.poolSuccess;
                if (!this.maintainSteadySize) return this.list.remove(size - 1);
                if (this.addedResizeTask) return this.list.remove(size - 1);
                this.addedResizeTask = true;
                toAddResizeTask = true;
                obj = this.list.remove(size - 1);
            } else if (!this.singletonBeanPool) {
                if (this.maintainSteadySize && !this.addedResizeTask) {
                    this.addedResizeTask = true;
                    toAddResizeTask = true;
                }
                this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.createdCount;
            }
        }
        if (toAddResizeTask) {
            this.addResizeTaskForImmediateExecution();
        }
        if (obj != null) {
            return obj;
        }
        if (this.singletonBeanPool) {
            arrayList = this.list;
            synchronized (arrayList) {
                while (this.list.isEmpty() && this.createdCount - this.destroyedCount > 0) {
                    try {
                        this.list.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                if (!this.list.isEmpty()) {
                    return this.list.remove(0);
                }
                try {
                    obj = this.factory.create(param);
                    ++this.createdCount;
                    return obj;
                }
                catch (RuntimeException th) {
                    this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    throw th;
                }
            }
        }
        try {
            return this.factory.create(param);
        }
        catch (RuntimeException th) {
            ArrayList arrayList2 = this.list;
            synchronized (arrayList2) {
                this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                --this.createdCount;
                throw th;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResizeTaskForImmediateExecution() {
        block6: {
            try {
                ReSizeWork work = new ReSizeWork();
                EjbContainerUtilImpl.getInstance().addWork(work);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
                ++this.resizeTaskCount;
            }
            catch (Exception ex) {
                ArrayList arrayList = this.list;
                synchronized (arrayList) {
                    this.addedResizeTask = false;
                }
                if (!_logger.isLoggable(Level.WARNING)) break block6;
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Cannot perform " + " pool resize task", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.list.size() < this.maxPoolSize) {
                this.list.add(object);
                if (this.singletonBeanPool) {
                    this.list.notify();
                }
                return;
            }
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in returnObj", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
            if (this.singletonBeanPool) {
                this.list.notify();
            }
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in destroyObject", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preload(int count) {
        int sz;
        ArrayList<Object> instances = new ArrayList<Object>(count);
        try {
            for (int i = 0; i < count; ++i) {
                instances.add(this.factory.create(null));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if ((sz = instances.size()) == 0) {
            return;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = this.list.size();
            int addsz = sz;
            if (n + sz > this.maxPoolSize) {
                addsz = this.maxPoolSize - n;
            }
            for (int i = 0; i < addsz; ++i) {
                this.list.add(instances.remove(0));
            }
            this.createdCount += sz;
        }
        for (Object e : instances) {
            this.destroyObject(e);
        }
    }

    public void prepopulate(int count) {
        this.steadyPoolSize = count <= 0 ? 0 : count;
        int n = this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        if (this.steadyPoolSize > 0) {
            this.preload(this.steadyPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Cancelled pool timer task " + " at: " + new Date());
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Destroying " + this.list.size() + " beans from the pool...");
            }
            ClassLoader origLoader = Utility.setContextClassLoader((ClassLoader)this.containerClassLoader);
            Object[] array = this.list.toArray();
            for (int i = 0; i < array.length; ++i) {
                try {
                    this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.destroyedCount;
                    try {
                        this.factory.destroy(array[i]);
                    }
                    catch (Throwable th) {
                        _logger.log(Level.FINE, "exception in close", th);
                    }
                    continue;
                }
                catch (Throwable th) {
                    _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Error while destroying", th);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Pool-" + this.poolName + "]: Pool closed....");
            }
            this.list.clear();
            this.unregisterProbeProvider();
            Utility.setContextClassLoader((ClassLoader)origLoader);
            this.poolClosed = true;
            this.list = null;
            this.factory = null;
            this.poolTimerTask = null;
            this.containerClassLoader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(int count) {
        ArrayList removeList = new ArrayList();
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            for (int i = 0; i < count && size > 0; ++i) {
                removeList.add(this.list.remove(--size));
                this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.destroyedCount;
            }
        }
        int sz = removeList.size();
        for (int i = 0; i < sz; ++i) {
            try {
                this.factory.destroy(removeList.get(i));
                continue;
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "exception in remove", th);
            }
        }
    }

    @Override
    protected void removeIdleObjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doResize() {
        block66: {
            block65: {
                block63: {
                    block61: {
                        if (this.poolClosed) {
                            return;
                        }
                        currentThread = Thread.currentThread();
                        previousClassLoader = currentThread.getContextClassLoader();
                        ctxClassLoader = this.containerClassLoader;
                        startTime = 0L;
                        enteredResizeBlock = false;
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(ctxClassLoader);
                        } else {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    currentThread.setContextClassLoader(ctxClassLoader);
                                    return null;
                                }
                            });
                        }
                        if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                            NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize started at: " + new Date() + " steadyPoolSize ::" + this.steadyPoolSize + " resizeQuantity ::" + this.resizeQuantity + " maxPoolSize ::" + this.maxPoolSize);
                        }
                        startTime = System.currentTimeMillis();
                        removeList = new ArrayList();
                        populateCount = 0L;
                        var10_10 = this.list;
                        synchronized (var10_10) {
                            if (!this.inResizing && !this.poolClosed) ** break block60
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 15] lbl23 : MonitorExitStatement: MONITOREXIT : var10_10
                            if (!enteredResizeBlock) break block61;
                            var11_12 = this.list;
                        }
                        synchronized (var11_12) {
                            this.inResizing = false;
                        }
                    }
                    if (System.getSecurityManager() == null) {
                        currentThread.setContextClassLoader(previousClassLoader);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction(currentThread, previousClassLoader){
                            final /* synthetic */ Thread val$currentThread;
                            final /* synthetic */ ClassLoader val$previousClassLoader;
                            {
                                this.val$currentThread = thread;
                                this.val$previousClassLoader = classLoader;
                            }

                            public Object run() {
                                this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                                return null;
                            }
                        });
                    }
                    return;
                    {
                        enteredResizeBlock = true;
                        this.inResizing = true;
                        curSize = this.list.size();
                        if (curSize <= this.steadyPoolSize) ** GOTO lbl75
                        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) ** break block62
                        // MONITOREXIT @DISABLED, blocks:[3, 15] lbl46 : MonitorExitStatement: MONITOREXIT : var10_10
                        if (!enteredResizeBlock) break block63;
                        var12_15 = this.list;
                    }
                    synchronized (var12_15) {
                        this.inResizing = false;
                    }
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                return;
                {
                    victimCount = curSize > this.steadyPoolSize + this.resizeQuantity ? this.resizeQuantity : curSize - this.steadyPoolSize;
                    allowedIdleTime = System.currentTimeMillis() - (long)this.idleTimeoutInSeconds * 1000L;
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize:: reducing " + " pool size by: " + victimCount);
                    }
                    for (i = 0; i < victimCount && (ctx = (EJBContextImpl)this.list.get(0)).getLastTimeUsed() <= allowedIdleTime; ++i) {
                        removeList.add(this.list.remove(0));
                        this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                        ++this.destroyedCount;
                    }
                    ** GOTO lbl104
lbl75:
                    // 1 sources

                    if (curSize >= this.steadyPoolSize) ** GOTO lbl104
                    if (this.maintainSteadySize) ** break block64
                    // MONITOREXIT @DISABLED, blocks:[5, 15] lbl77 : MonitorExitStatement: MONITOREXIT : var10_10
                    if (!enteredResizeBlock) break block65;
                    victimCount = this.list;
                }
                synchronized (victimCount) {
                    this.inResizing = false;
                }
            }
            if (System.getSecurityManager() == null) {
                currentThread.setContextClassLoader(previousClassLoader);
            } else {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            return;
            {
                if (this.resizeQuantity <= 0) {
                    populateCount = this.steadyPoolSize - curSize;
                } else {
                    while ((long)curSize + populateCount < (long)this.steadyPoolSize) {
                        populateCount += (long)this.resizeQuantity;
                    }
                    if ((long)curSize + populateCount > (long)this.maxPoolSize) {
                        populateCount -= (long)curSize + populateCount - (long)this.maxPoolSize;
                    }
                }
lbl104:
                // 6 sources

                // MONITOREXIT @DISABLED, blocks:[7, 8, 15] lbl104 : MonitorExitStatement: MONITOREXIT : var10_10
                {
                    catch (Throwable var18_24) {
                        throw var18_24;
                    }
                }
                if (removeList.size() > 0) {
                    sz = removeList.size();
                    for (i = 0; i < sz; ++i) {
                        try {
                            this.factory.destroy(removeList.get(i));
                            continue;
                        }
                        catch (Throwable th) {
                            NonBlockingPool._logger.log(Level.FINE, "exception in doResize", th);
                        }
                    }
                }
                if (populateCount > 0L) {
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Attempting to preload " + populateCount + " beans. CurSize/MaxPoolSize: " + this.list.size() + "/" + this.maxPoolSize);
                    }
                    this.preload((int)populateCount);
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: After preload " + "CurSize/MaxPoolSize: " + this.list.size() + "/" + this.maxPoolSize);
                    }
                }
                if (!enteredResizeBlock) break block66;
                removeList = this.list;
            }
            synchronized (removeList) {
                this.inResizing = false;
            }
        }
        if (System.getSecurityManager() == null) {
            currentThread.setContextClassLoader(previousClassLoader);
        } else {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        ** GOTO lbl171
        {
            catch (Throwable th) {
                block67: {
                    try {
                        NonBlockingPool._logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Exception during reSize", th);
                        if (!enteredResizeBlock) break block67;
                        th = this.list;
                    }
                    catch (Throwable var21_27) {
                        if (enteredResizeBlock) {
                            var22_28 = this.list;
                            synchronized (var22_28) {
                                this.inResizing = false;
                            }
                        }
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(previousClassLoader);
                        } else {
                            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                        }
                        throw var21_27;
                    }
                    synchronized (th) {
                        this.inResizing = false;
                    }
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
            }
            endTime = System.currentTimeMillis();
            if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize completed at: " + new Date() + "; after reSize: " + this.getAllAttrValues());
                NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize took: " + (double)(endTime - startTime) / 1000.0 + " seconds.");
            }
            return;
        }
    }

    @Override
    public String getAllAttrValues() {
        StringBuffer sbuf = new StringBuffer("[Pool-" + this.poolName + "] ");
        sbuf.append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("CS=").append(this.list.size()).append("; ").append("SS=").append(this.steadyPoolSize).append("; ").append("MS=").append(this.maxPoolSize).append(";");
        return sbuf.toString();
    }

    private class PoolResizeTimerTask
    extends TimerTask {
        PoolResizeTimerTask() {
        }

        @Override
        public void run() {
            try {
                if (NonBlockingPool.this.addedIdleBeanWork) {
                    return;
                }
                NonBlockingPool.this.addedIdleBeanWork = true;
                IdleBeanWork work = new IdleBeanWork();
                EjbContainerUtilImpl.getInstance().addWork(work);
            }
            catch (Exception ex) {
                NonBlockingPool.this.addedIdleBeanWork = false;
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Cannot perform " + " pool idle bean cleanup", ex);
            }
        }
    }

    private class IdleBeanWork
    implements Runnable {
        private IdleBeanWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception exception) {
            }
            finally {
                NonBlockingPool.this.addedIdleBeanWork = false;
            }
        }
    }

    private class ReSizeWork
    implements Runnable {
        private ReSizeWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception ex) {
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Exception during reSize", ex);
            }
            finally {
                ArrayList arrayList = NonBlockingPool.this.list;
                synchronized (arrayList) {
                    NonBlockingPool.this.addedResizeTask = false;
                }
            }
        }
    }
}

