/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node.runtime;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeBundleNode;
import com.sun.enterprise.deployment.node.runtime.common.SecurityRoleMappingNode;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.ejb.deployment.node.EjbBundleNode;
import org.glassfish.ejb.deployment.node.runtime.EntrepriseBeansRuntimeNode;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.Role;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBundleRuntimeNode
extends RuntimeBundleNode<EjbBundleDescriptor> {
    public EjbBundleRuntimeNode(EjbBundleDescriptor descriptor) {
        super((RootDeploymentDescriptor)descriptor);
        this.habitat.getByType(EjbBundleNode.class);
        this.registerElementHandler(new XMLElement("security-role-mapping"), SecurityRoleMappingNode.class);
        this.registerElementHandler(new XMLElement("enterprise-beans"), EntrepriseBeansRuntimeNode.class);
    }

    public EjbBundleRuntimeNode() {
        this(null);
    }

    public String getDocType() {
        return "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 EJB 3.1//EN";
    }

    public String getSystemID() {
        return "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_1-0.dtd";
    }

    public List<String> getSystemIDs() {
        return null;
    }

    protected XMLElement getXMLRootTag() {
        return new XMLElement("sun-ejb-jar");
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 EJB 2.0//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_0-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.1 EJB 2.0//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_0-1.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-1.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 EJB 3.0//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_0-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 EJB 3.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_1-0.dtd");
        if (!EjbBundleRuntimeNode.restrictDTDDeclarations()) {
            publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 EJB 2.1//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_1-0.dtd");
        }
        return "sun-ejb-jar";
    }

    public EjbBundleDescriptor getDescriptor() {
        return (EjbBundleDescriptor)this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if (element.getQName().equals("compatibility")) {
            ((EjbBundleDescriptor)this.descriptor).setCompatibility(value);
        } else if (element.getQName().equals("disable-nonportable-jndi-names")) {
            ((EjbBundleDescriptor)this.descriptor).setDisableNonportableJndiNames(value);
        } else if (element.getQName().equals("keep-state")) {
            ((EjbBundleDescriptor)this.descriptor).setKeepState(value);
        } else if (!element.getQName().equals("version-identifier")) {
            super.setElementValue(element, value);
        }
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof SecurityRoleMapping) {
            SecurityRoleMapping roleMap = (SecurityRoleMapping)newDescriptor;
            ((EjbBundleDescriptor)this.descriptor).addSecurityRoleMapping(roleMap);
            Application app = ((EjbBundleDescriptor)this.descriptor).getApplication();
            if (app != null) {
                Role role = new Role(roleMap.getRoleName());
                SecurityRoleMapper rm = app.getRoleMapper();
                if (rm != null) {
                    List principals = roleMap.getPrincipalNames();
                    for (int i = 0; i < principals.size(); ++i) {
                        rm.assignRole(((PrincipalNameDescriptor)principals.get(i)).getPrincipal(), role, this.descriptor);
                    }
                    List groups = roleMap.getGroupNames();
                    for (int i = 0; i < groups.size(); ++i) {
                        rm.assignRole((Principal)new Group((String)groups.get(i)), role, this.descriptor);
                    }
                }
            }
        }
    }

    public Node writeDescriptor(Node parent, EjbBundleDescriptor bundleDescriptor) {
        Node ejbs = super.writeDescriptor(parent, (Object)bundleDescriptor);
        List roleMappings = bundleDescriptor.getSecurityRoleMappings();
        for (int i = 0; i < roleMappings.size(); ++i) {
            SecurityRoleMappingNode srmn = new SecurityRoleMappingNode();
            srmn.writeDescriptor(ejbs, "security-role-mapping", (SecurityRoleMapping)roleMappings.get(i));
        }
        EntrepriseBeansRuntimeNode ejbsNode = new EntrepriseBeansRuntimeNode();
        ejbsNode.writeDescriptor(ejbs, "enterprise-beans", bundleDescriptor);
        EjbBundleRuntimeNode.appendTextChild((Node)ejbs, (String)"compatibility", (String)bundleDescriptor.getCompatibility());
        Boolean djndi = bundleDescriptor.getDisableNonportableJndiNames();
        if (djndi != null) {
            EjbBundleRuntimeNode.appendTextChild((Node)ejbs, (String)"disable-nonportable-jndi-names", (String)String.valueOf(djndi));
        }
        EjbBundleRuntimeNode.appendTextChild((Node)ejbs, (String)"keep-state", (String)String.valueOf(bundleDescriptor.getKeepState()));
        return ejbs;
    }
}

