/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node.runtime;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.node.PropertiesNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.DefaultResourcePrincipalNode;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.node.runtime.common.RuntimeNameValuePairNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class CmpResourceNode
extends RuntimeDescriptorNode {
    ResourceReferenceDescriptor descriptor = new ResourceReferenceDescriptor();

    public CmpResourceNode() {
        this.registerElementHandler(new XMLElement("default-resource-principal"), DefaultResourcePrincipalNode.class, "setResourcePrincipal");
        this.registerElementHandler(new XMLElement("property"), RuntimeNameValuePairNode.class, "addProperty");
        this.registerElementHandler(new XMLElement("schema-generator-properties"), PropertiesNode.class, "setSchemaGeneratorProperties");
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        table.put("create-tables-at-deploy", "setCreateTablesAtDeploy");
        table.put("drop-tables-at-undeploy", "setDropTablesAtUndeploy");
        table.put("database-vendor-name", "setDatabaseVendorName");
        return table;
    }

    public void postParsing() {
        EjbBundleDescriptor bd = (EjbBundleDescriptor)this.getParentNode().getDescriptor();
        if (bd == null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{this.descriptor});
            return;
        }
        bd.setCMPResourceReference(this.descriptor);
    }

    public Node writeDescriptor(Node parent, String nodeName, ResourceReferenceDescriptor descriptor) {
        Iterator properties;
        Node cmp = super.writeDescriptor(parent, nodeName, (Object)descriptor);
        CmpResourceNode.appendTextChild((Node)cmp, (String)"jndi-name", (String)descriptor.getJndiName());
        if (descriptor.getResourcePrincipal() != null) {
            DefaultResourcePrincipalNode drpNode = new DefaultResourcePrincipalNode();
            drpNode.writeDescriptor(cmp, "default-resource-principal", descriptor.getResourcePrincipal());
        }
        if ((properties = descriptor.getProperties()) != null) {
            RuntimeNameValuePairNode propNode = new RuntimeNameValuePairNode();
            while (properties.hasNext()) {
                NameValuePairDescriptor aProp = (NameValuePairDescriptor)properties.next();
                propNode.writeDescriptor(cmp, "property", aProp);
            }
        }
        if (descriptor.isCreateTablesAtDeploy()) {
            CmpResourceNode.appendTextChild((Node)cmp, (String)"create-tables-at-deploy", (String)"true");
        }
        if (descriptor.isDropTablesAtUndeploy()) {
            CmpResourceNode.appendTextChild((Node)cmp, (String)"drop-tables-at-undeploy", (String)"true");
        }
        CmpResourceNode.appendTextChild((Node)cmp, (String)"database-vendor-name", (String)descriptor.getDatabaseVendorName());
        Properties schemaGeneratorProps = descriptor.getSchemaGeneratorProperties();
        if (schemaGeneratorProps != null) {
            PropertiesNode pn = new PropertiesNode();
            pn.writeDescriptor(cmp, "schema-generator-properties", schemaGeneratorProps);
        }
        return cmp;
    }
}

