/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.TimeoutValueDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.Node;

public class TimeoutValueNode
extends DeploymentDescriptorNode {
    TimeoutValueDescriptor descriptor = null;
    private static final Map<String, TimeUnit> elementToTimeUnit = new HashMap<String, TimeUnit>();
    private static final Map<TimeUnit, String> timeUnitToElement;

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new TimeoutValueDescriptor();
        }
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("timeout".equals(element.getQName())) {
            this.descriptor.setValue(new Long(value).longValue());
        } else if ("unit".equals(element.getQName())) {
            this.descriptor.setUnit(elementToTimeUnit.get(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        if (!(descriptor instanceof TimeoutValueDescriptor)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        TimeoutValueDescriptor desc = (TimeoutValueDescriptor)descriptor;
        Node timeoutNode = super.writeDescriptor(parent, nodeName, (Object)descriptor);
        TimeoutValueNode.appendTextChild((Node)timeoutNode, (String)"timeout", (String)Long.toString(desc.getValue()));
        TimeoutValueNode.appendTextChild((Node)timeoutNode, (String)"unit", (String)timeUnitToElement.get((Object)desc.getUnit()));
        return timeoutNode;
    }

    static {
        elementToTimeUnit.put("Days", TimeUnit.DAYS);
        elementToTimeUnit.put("Hours", TimeUnit.HOURS);
        elementToTimeUnit.put("Minutes", TimeUnit.MINUTES);
        elementToTimeUnit.put("Seconds", TimeUnit.SECONDS);
        elementToTimeUnit.put("Milliseconds", TimeUnit.MILLISECONDS);
        elementToTimeUnit.put("Microseconds", TimeUnit.MICROSECONDS);
        elementToTimeUnit.put("Nanoseconds", TimeUnit.NANOSECONDS);
        timeUnitToElement = new HashMap<TimeUnit, String>();
        for (String next : elementToTimeUnit.keySet()) {
            timeUnitToElement.put(elementToTimeUnit.get(next), next);
        }
    }
}

