/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.InterceptorBindingDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBindingNode
extends DeploymentDescriptorNode {
    private MethodDescriptor businessMethod = null;
    private boolean needsOverloadResolution = false;

    public void startElement(XMLElement element, Attributes attributes) {
        if ("method".equals(element.getQName())) {
            this.businessMethod = new MethodDescriptor();
            this.needsOverloadResolution = true;
        } else if ("method-params".equals(element.getQName())) {
            this.needsOverloadResolution = false;
        }
        super.startElement(element, attributes);
    }

    public void setElementValue(XMLElement element, String value) {
        if ("method-name".equals(element.getQName())) {
            this.businessMethod.setName(value);
        } else if ("method-param".equals(element.getQName())) {
            if (value != null && value.trim().length() > 0) {
                this.businessMethod.addParameterClass(value.trim());
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public boolean endElement(XMLElement element) {
        if ("interceptor-order".equals(element.getQName())) {
            InterceptorBindingDescriptor desc = (InterceptorBindingDescriptor)this.getDescriptor();
            desc.setIsTotalOrdering(true);
        } else if ("method-params".equals(element.getQName())) {
            if (this.businessMethod.getParameterClassNames() == null) {
                this.businessMethod.setEmptyParameterClassNames();
            }
        } else if ("method".equals(element.getQName())) {
            InterceptorBindingDescriptor bindingDesc = (InterceptorBindingDescriptor)this.getDescriptor();
            this.businessMethod.setEjbClassSymbol("Bean");
            bindingDesc.setBusinessMethod(this.businessMethod);
            if (this.needsOverloadResolution) {
                bindingDesc.setNeedsOverloadResolution(true);
            }
            this.businessMethod = null;
            this.needsOverloadResolution = false;
        }
        return super.endElement(element);
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-name", "setEjbName");
        table.put("interceptor-class", "appendInterceptorClass");
        table.put("exclude-default-interceptors", "setExcludeDefaultInterceptors");
        table.put("exclude-class-interceptors", "setExcludeClassInterceptors");
        return table;
    }

    public void writeBindings(Node parent, EjbDescriptor ejbDesc) {
        List classInterceptors = ejbDesc.getInterceptorChain();
        if (classInterceptors.size() > 0) {
            this.writeTotalOrdering(parent, classInterceptors, ejbDesc, null);
        }
        Map methodInterceptorsMap = ejbDesc.getMethodInterceptorsMap();
        for (Map.Entry mapEntry : methodInterceptorsMap.entrySet()) {
            List interceptors = (List)mapEntry.getValue();
            if (interceptors.isEmpty()) {
                this.writeExclusionBinding(parent, ejbDesc, (MethodDescriptor)mapEntry.getKey());
                continue;
            }
            this.writeTotalOrdering(parent, interceptors, ejbDesc, (MethodDescriptor)mapEntry.getKey());
        }
    }

    private void writeTotalOrdering(Node parent, List<EjbInterceptor> interceptors, EjbDescriptor ejbDesc, MethodDescriptor method) {
        Element bindingNode = InterceptorBindingNode.appendChild((Node)parent, (String)"interceptor-binding");
        InterceptorBindingNode.appendTextChild((Node)bindingNode, (String)"ejb-name", (String)ejbDesc.getName());
        Element totalOrderingNode = InterceptorBindingNode.appendChild((Node)bindingNode, (String)"interceptor-order");
        for (EjbInterceptor next : interceptors) {
            InterceptorBindingNode.appendTextChild((Node)totalOrderingNode, (String)"interceptor-class", (String)next.getInterceptorClassName());
        }
        if (method != null) {
            MethodNode methodNode = new MethodNode();
            methodNode.writeJavaMethodDescriptor((Node)bindingNode, "method", method, true);
        }
    }

    private void writeExclusionBinding(Node parent, EjbDescriptor ejbDesc, MethodDescriptor method) {
        Element bindingNode = InterceptorBindingNode.appendChild((Node)parent, (String)"interceptor-binding");
        InterceptorBindingNode.appendTextChild((Node)bindingNode, (String)"ejb-name", (String)ejbDesc.getName());
        InterceptorBindingNode.appendTextChild((Node)bindingNode, (String)"exclude-class-interceptors", (String)"true");
        MethodNode methodNode = new MethodNode();
        methodNode.writeJavaMethodDescriptor((Node)bindingNode, "method", method, true);
    }
}

