/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.ConcurrentMethodDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInitInfo;
import com.sun.enterprise.deployment.EjbRemovalInfo;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.deployment.TimeoutValueDescriptor;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.node.AroundInvokeNode;
import org.glassfish.ejb.deployment.node.AroundTimeoutNode;
import org.glassfish.ejb.deployment.node.ConcurrentMethodNode;
import org.glassfish.ejb.deployment.node.EjbInitNode;
import org.glassfish.ejb.deployment.node.EjbRemoveNode;
import org.glassfish.ejb.deployment.node.InterfaceBasedEjbNode;
import org.glassfish.ejb.deployment.node.ScheduledTimerNode;
import org.glassfish.ejb.deployment.node.TimeoutValueNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class EjbSessionNode
extends InterfaceBasedEjbNode {
    private EjbSessionDescriptor descriptor;
    private boolean inDependsOn = false;
    private List<String> dependsOn = null;

    public EjbSessionNode() {
        this.registerElementHandler(new XMLElement("around-invoke"), AroundInvokeNode.class, "addAroundInvokeDescriptor");
        this.registerElementHandler(new XMLElement("around-timeout"), AroundTimeoutNode.class, "addAroundTimeoutDescriptor");
        this.registerElementHandler(new XMLElement("post-construct"), LifecycleCallbackNode.class, "addPostConstructDescriptor");
        this.registerElementHandler(new XMLElement("pre-destroy"), LifecycleCallbackNode.class, "addPreDestroyDescriptor");
        this.registerElementHandler(new XMLElement("data-source"), DataSourceDefinitionNode.class, "addDataSourceDefinitionDescriptor");
        this.registerElementHandler(new XMLElement("post-activate"), LifecycleCallbackNode.class, "addPostActivateDescriptor");
        this.registerElementHandler(new XMLElement("pre-passivate"), LifecycleCallbackNode.class, "addPrePassivateDescriptor");
        this.registerElementHandler(new XMLElement("timeout-method"), MethodNode.class, "setEjbTimeoutMethod");
        this.registerElementHandler(new XMLElement("init-method"), EjbInitNode.class, "addInitMethod");
        this.registerElementHandler(new XMLElement("remove-method"), EjbRemoveNode.class, "addRemoveMethod");
        this.registerElementHandler(new XMLElement("stateful-timeout"), TimeoutValueNode.class, "addStatefulTimeoutDescriptor");
        this.registerElementHandler(new XMLElement("after-begin-method"), MethodNode.class, "addAfterBeginDescriptor");
        this.registerElementHandler(new XMLElement("before-completion-method"), MethodNode.class, "addBeforeCompletionDescriptor");
        this.registerElementHandler(new XMLElement("after-completion-method"), MethodNode.class, "addAfterCompletionDescriptor");
        this.registerElementHandler(new XMLElement("async-method"), MethodNode.class, "addAsynchronousMethod");
        this.registerElementHandler(new XMLElement("concurrent-method"), ConcurrentMethodNode.class, "addConcurrentMethodFromXml");
    }

    public EjbDescriptor getEjbDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (EjbSessionDescriptor)DescriptorFactory.getDescriptor((String)this.getXMLPath());
            this.descriptor.setEjbBundleDescriptor((EjbBundleDescriptor)this.getParentNode().getDescriptor());
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("session-type", "setSessionType");
        table.put("transaction-type", "setTransactionType");
        table.put("init-on-startup", "setInitOnStartup");
        return table;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        if ("local-bean".equals(element.getQName())) {
            this.descriptor.setLocalBean(true);
        } else if ("depends-on".equals(element.getQName())) {
            this.inDependsOn = true;
            this.dependsOn = new ArrayList<String>();
        }
        super.startElement(element, attributes);
    }

    public void setElementValue(XMLElement element, String value) {
        if (this.inDependsOn && "ejb-name".equals(element.getQName())) {
            this.dependsOn.add(value);
        } else if ("concurrency-management-type".equals(element.getQName())) {
            this.descriptor.setConcurrencyManagementType(EjbSessionDescriptor.ConcurrencyManagementType.valueOf((String)value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public boolean endElement(XMLElement element) {
        if ("depends-on".equals(element.getQName())) {
            this.inDependsOn = false;
            this.descriptor.setDependsOn(this.dependsOn.toArray(new String[this.dependsOn.size()]));
            this.dependsOn = null;
        }
        return super.endElement(element);
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        MethodDescriptor afterCompletionMethod;
        MethodDescriptor beforeCompletionMethod;
        ConcurrentMethodDescriptor cDesc;
        if (!(descriptor instanceof EjbSessionDescriptor)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        EjbSessionDescriptor ejbDesc = (EjbSessionDescriptor)descriptor;
        Node ejbNode = super.writeDescriptor(parent, nodeName, (Object)descriptor);
        this.writeDisplayableComponentInfo(ejbNode, descriptor);
        this.writeCommonHeaderEjbDescriptor(ejbNode, (EjbDescriptor)ejbDesc);
        EjbSessionNode.appendTextChild((Node)ejbNode, (String)"session-type", (String)ejbDesc.getSessionType());
        if (ejbDesc.hasStatefulTimeout()) {
            TimeoutValueNode timeoutValueNode = new TimeoutValueNode();
            TimeoutValueDescriptor timeoutDesc = new TimeoutValueDescriptor();
            timeoutDesc.setValue(ejbDesc.getStatefulTimeoutValue().longValue());
            timeoutDesc.setUnit(ejbDesc.getStatefulTimeoutUnit());
            timeoutValueNode.writeDescriptor(ejbNode, "stateful-timeout", (Descriptor)timeoutDesc);
        }
        MethodNode methodNode = new MethodNode();
        if (ejbDesc.isTimedObject()) {
            if (ejbDesc.getEjbTimeoutMethod() != null) {
                methodNode.writeJavaMethodDescriptor(ejbNode, "timeout-method", ejbDesc.getEjbTimeoutMethod());
            }
            for (ScheduledTimerDescriptor timerDesc : ejbDesc.getScheduledTimerDescriptors()) {
                ScheduledTimerNode timerNode = new ScheduledTimerNode();
                timerNode.writeDescriptor(ejbNode, "timer", (Descriptor)timerDesc);
            }
        }
        if (ejbDesc.isSingleton()) {
            EjbSessionNode.appendTextChild((Node)ejbNode, (String)"init-on-startup", (String)Boolean.toString(ejbDesc.getInitOnStartup()));
        }
        if (!ejbDesc.isStateless()) {
            EjbSessionNode.appendTextChild((Node)ejbNode, (String)"concurrency-management-type", (String)ejbDesc.getConcurrencyManagementType().toString());
        }
        for (EjbSessionDescriptor.AccessTimeoutHolder next : ejbDesc.getAccessTimeoutInfo()) {
            cDesc = new ConcurrentMethodDescriptor();
            cDesc.setConcurrentMethod(next.method);
            TimeoutValueDescriptor timeoutDesc = new TimeoutValueDescriptor();
            timeoutDesc.setValue(next.value);
            timeoutDesc.setUnit(next.unit);
            cDesc.setAccessTimeout(timeoutDesc);
            ConcurrentMethodNode cNode = new ConcurrentMethodNode();
            cNode.writeDescriptor(ejbNode, "concurrent-method", (Descriptor)cDesc);
        }
        for (MethodDescriptor nextReadLock : ejbDesc.getReadLockMethods()) {
            cDesc = new ConcurrentMethodDescriptor();
            cDesc.setConcurrentMethod(nextReadLock);
            cDesc.setWriteLock(false);
            ConcurrentMethodNode cNode = new ConcurrentMethodNode();
            cNode.writeDescriptor(ejbNode, "concurrent-method", (Descriptor)cDesc);
        }
        if (ejbDesc.hasDependsOn()) {
            Element dependsOnNode = EjbSessionNode.appendChild((Node)ejbNode, (String)"depends-on");
            for (String depend : ejbDesc.getDependsOn()) {
                EjbSessionNode.appendTextChild((Node)dependsOnNode, (String)"ejb-name", (String)depend);
            }
        }
        if (ejbDesc.hasInitMethods()) {
            EjbInitNode initNode = new EjbInitNode();
            for (EjbInitInfo next : ejbDesc.getInitMethods()) {
                initNode.writeDescriptor(ejbNode, "init-method", next);
            }
        }
        if (ejbDesc.hasRemoveMethods()) {
            EjbRemoveNode removeNode = new EjbRemoveNode();
            for (EjbRemovalInfo next : ejbDesc.getAllRemovalInfo()) {
                removeNode.writeDescriptor(ejbNode, "remove-method", next);
            }
        }
        for (MethodDescriptor nextDesc : ejbDesc.getAsynchronousMethods()) {
            methodNode.writeDescriptor(ejbNode, "async-method", nextDesc, ejbDesc.getName());
        }
        EjbSessionNode.appendTextChild((Node)ejbNode, (String)"transaction-type", (String)ejbDesc.getTransactionType());
        MethodDescriptor afterBeginMethod = ejbDesc.getAfterBeginMethod();
        if (afterBeginMethod != null) {
            methodNode.writeJavaMethodDescriptor(ejbNode, "after-begin-method", afterBeginMethod);
        }
        if ((beforeCompletionMethod = ejbDesc.getBeforeCompletionMethod()) != null) {
            methodNode.writeJavaMethodDescriptor(ejbNode, "before-completion-method", beforeCompletionMethod);
        }
        if ((afterCompletionMethod = ejbDesc.getAfterCompletionMethod()) != null) {
            methodNode.writeJavaMethodDescriptor(ejbNode, "after-completion-method", afterCompletionMethod);
        }
        EjbSessionNode.writeAroundInvokeDescriptors(ejbNode, ejbDesc.getAroundInvokeDescriptors().iterator());
        EjbSessionNode.writeAroundTimeoutDescriptors(ejbNode, ejbDesc.getAroundTimeoutDescriptors().iterator());
        this.writeEnvEntryDescriptors(ejbNode, ejbDesc.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(ejbNode, ejbDesc.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(ejbNode, ejbDesc.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(ejbNode, ejbDesc.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(ejbNode, ejbDesc.getResourceEnvReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(ejbNode, ejbDesc.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(ejbNode, ejbDesc.getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(ejbNode, ejbDesc.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writePostConstructDescriptors(ejbNode, ejbDesc.getPostConstructDescriptors().iterator());
        this.writePreDestroyDescriptors(ejbNode, ejbDesc.getPreDestroyDescriptors().iterator());
        this.writeDataSourceDefinitionDescriptors(ejbNode, ejbDesc.getDataSourceDefinitionDescriptors().iterator());
        this.writePostActivateDescriptors(ejbNode, ejbDesc.getPostActivateDescriptors().iterator());
        this.writePrePassivateDescriptors(ejbNode, ejbDesc.getPrePassivateDescriptors().iterator());
        this.writeRoleReferenceDescriptors(ejbNode, ejbDesc.getRoleReferences().iterator());
        this.writeSecurityIdentityDescriptor(ejbNode, (EjbDescriptor)ejbDesc);
        return ejbNode;
    }
}

