/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.JndiEnvRefNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.SecurityRoleRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.node.AroundInvokeNode;
import org.glassfish.ejb.deployment.node.AroundTimeoutNode;
import org.glassfish.ejb.deployment.node.ScheduledTimerNode;
import org.glassfish.ejb.deployment.node.SecurityIdentityNode;
import org.w3c.dom.Node;

public abstract class EjbNode
extends DisplayableComponentNode {
    public EjbNode() {
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class, "addEnvironmentProperty");
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        JndiEnvRefNode serviceRefNode = (JndiEnvRefNode)this.habitat.getComponent(JndiEnvRefNode.class, "service-ref");
        if (serviceRefNode != null) {
            this.registerElementHandler(new XMLElement("service-ref"), serviceRefNode.getClass(), "addServiceReferenceDescriptor");
        }
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("data-source"), DataSourceDefinitionNode.class, "addDataSourceDefinitionDescriptor");
        this.registerElementHandler(new XMLElement("security-identity"), SecurityIdentityNode.class);
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addResourceEnvReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class);
        this.registerElementHandler(new XMLElement("persistence-context-ref"), EntityManagerReferenceNode.class, "addEntityManagerReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceNode.class, "addEntityManagerFactoryReferenceDescriptor");
        this.registerElementHandler(new XMLElement("timer"), ScheduledTimerNode.class, "addScheduledTimerDescriptorFromDD");
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbReference) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding ejb ref " + newDescriptor);
            }
            this.getEjbDescriptor().addEjbReferenceDescriptor((EjbReference)newDescriptor);
        } else if (newDescriptor instanceof RunAsIdentityDescriptor) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding security-identity" + newDescriptor);
            }
            this.getEjbDescriptor().setUsesCallerIdentity(false);
            this.getEjbDescriptor().setRunAsIdentity((RunAsIdentityDescriptor)newDescriptor);
        } else if (newDescriptor instanceof MessageDestinationReferenceDescriptor) {
            MessageDestinationReferenceDescriptor msgDestRef = (MessageDestinationReferenceDescriptor)newDescriptor;
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)this.getParentNode().getDescriptor();
            msgDestRef.setReferringBundleDescriptor((BundleDescriptor)ejbBundle);
            this.getEjbDescriptor().addMessageDestinationReferenceDescriptor(msgDestRef);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public Object getDescriptor() {
        return this.getEjbDescriptor();
    }

    public abstract EjbDescriptor getEjbDescriptor();

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-name", "setName");
        table.put("ejb-class", "setEjbClassName");
        table.put("mapped-name", "setMappedName");
        return table;
    }

    protected void writeCommonHeaderEjbDescriptor(Node ejbNode, EjbDescriptor descriptor) {
        EjbNode.appendTextChild((Node)ejbNode, (String)"ejb-name", (String)descriptor.getName());
        EjbNode.appendTextChild((Node)ejbNode, (String)"mapped-name", (String)descriptor.getMappedName());
    }

    protected void writeSecurityIdentityDescriptor(Node parent, EjbDescriptor descriptor) {
        if (!descriptor.getUsesCallerIdentity().booleanValue() && descriptor.getRunAsIdentity() == null) {
            return;
        }
        SecurityIdentityNode node = new SecurityIdentityNode();
        node.writeDescriptor(parent, "security-identity", descriptor);
    }

    protected void writeRoleReferenceDescriptors(Node parentNode, Iterator refs) {
        SecurityRoleRefNode node = new SecurityRoleRefNode();
        while (refs.hasNext()) {
            RoleReference roleRef = (RoleReference)refs.next();
            node.writeDescriptor(parentNode, "security-role-ref", (Descriptor)roleRef);
        }
    }

    protected static void writeAroundInvokeDescriptors(Node parentNode, Iterator aroundInvokeDescs) {
        if (aroundInvokeDescs == null || !aroundInvokeDescs.hasNext()) {
            return;
        }
        AroundInvokeNode subNode = new AroundInvokeNode();
        while (aroundInvokeDescs.hasNext()) {
            LifecycleCallbackDescriptor next = (LifecycleCallbackDescriptor)aroundInvokeDescs.next();
            subNode.writeDescriptor(parentNode, "around-invoke", next);
        }
    }

    protected static void writeAroundTimeoutDescriptors(Node parentNode, Iterator aroundTimeoutDescs) {
        if (aroundTimeoutDescs == null || !aroundTimeoutDescs.hasNext()) {
            return;
        }
        AroundTimeoutNode subNode = new AroundTimeoutNode();
        while (aroundTimeoutDescs.hasNext()) {
            LifecycleCallbackDescriptor next = (LifecycleCallbackDescriptor)aroundTimeoutDescs.next();
            subNode.writeDescriptor(parentNode, "around-timeout", next);
        }
    }
}

