/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.MethodPermissionDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.node.AbstractBundleNode;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.ejb.deployment.node.ContainerTransactionNode;
import org.glassfish.ejb.deployment.node.EjbApplicationExceptionNode;
import org.glassfish.ejb.deployment.node.EjbEntityNode;
import org.glassfish.ejb.deployment.node.EjbInterceptorNode;
import org.glassfish.ejb.deployment.node.EjbNode;
import org.glassfish.ejb.deployment.node.EjbSessionNode;
import org.glassfish.ejb.deployment.node.ExcludeListNode;
import org.glassfish.ejb.deployment.node.InterceptorBindingNode;
import org.glassfish.ejb.deployment.node.MessageDrivenBeanNode;
import org.glassfish.ejb.deployment.node.MethodPermissionNode;
import org.glassfish.ejb.deployment.node.RelationshipsNode;
import org.glassfish.ejb.deployment.node.runtime.EjbBundleRuntimeNode;
import org.glassfish.ejb.deployment.node.runtime.GFEjbBundleRuntimeNode;
import org.glassfish.security.common.Role;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EjbBundleNode
extends AbstractBundleNode<EjbBundleDescriptor> {
    public static final XMLElement tag = new XMLElement("ejb-jar");
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/ejb-jar_1_1.dtd";
    public static final String SCHEMA_ID_21 = "ejb-jar_2_1.xsd";
    public static final String SCHEMA_ID_30 = "ejb-jar_3_0.xsd";
    public static final String SCHEMA_ID = "ejb-jar_3_1.xsd";
    public static final String SPEC_VERSION = "3.1";
    private static final List<String> systemIDs = EjbBundleNode.initSystemIDs();
    private EjbBundleDescriptor descriptor;

    public String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    public Map<String, Class> registerRuntimeBundle(Map<String, String> publicIDToDTD) {
        HashMap<String, Class> result = new HashMap<String, Class>();
        result.put(EjbBundleRuntimeNode.registerBundle(publicIDToDTD), EjbBundleRuntimeNode.class);
        result.put(GFEjbBundleRuntimeNode.registerBundle(publicIDToDTD), GFEjbBundleRuntimeNode.class);
        return result;
    }

    private static List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        systemIDs.add(SCHEMA_ID_30);
        systemIDs.add(SCHEMA_ID_21);
        return Collections.unmodifiableList(systemIDs);
    }

    public EjbBundleNode() {
        this.registerElementHandler(new XMLElement("session"), EjbSessionNode.class);
        this.registerElementHandler(new XMLElement("entity"), EjbEntityNode.class);
        this.registerElementHandler(new XMLElement("message-driven"), MessageDrivenBeanNode.class);
        this.registerElementHandler(new XMLElement("method-permission"), MethodPermissionNode.class);
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addRole");
        this.registerElementHandler(new XMLElement("container-transaction"), ContainerTransactionNode.class);
        this.registerElementHandler(new XMLElement("exclude-list"), ExcludeListNode.class);
        this.registerElementHandler(new XMLElement("relationships"), RelationshipsNode.class);
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
        this.registerElementHandler(new XMLElement("application-exception"), EjbApplicationExceptionNode.class, "addApplicationException");
        this.registerElementHandler(new XMLElement("interceptor"), EjbInterceptorNode.class, "addInterceptor");
        this.registerElementHandler(new XMLElement("interceptor-binding"), InterceptorBindingNode.class, "appendInterceptorBinding");
        SaxParserHandler.registerBundleNode((BundleNode)this, (String)"ejb-jar");
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbDescriptor) {
            this.descriptor.addEjb((EjbDescriptor)newDescriptor);
        } else if (newDescriptor instanceof RelationshipDescriptor) {
            this.descriptor.addRelationship((RelationshipDescriptor)newDescriptor);
        } else if (newDescriptor instanceof MethodPermissionDescriptor) {
            MethodPermissionDescriptor nd = (MethodPermissionDescriptor)newDescriptor;
            MethodDescriptor[] array = nd.getMethods();
            for (int i = 0; i < array.length; ++i) {
                EjbDescriptor target = this.descriptor.getEjbByName(array[i].getEjbName());
                MethodPermission[] mps = nd.getMethodPermissions();
                for (int j = 0; j < mps.length; ++j) {
                    DOLUtils.getDefaultLogger().fine("Adding mp " + mps[j] + " to " + array[i] + " for ejb " + array[i].getEjbName());
                    target.addPermissionedMethod(mps[j], array[i]);
                }
            }
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public void setElementValue(XMLElement element, String value) {
        if ("module-name".equals(element.getQName())) {
            EjbBundleDescriptor bundleDesc = this.getDescriptor();
            if (bundleDesc.getModuleDescriptor().getDescriptor() instanceof EjbBundleDescriptor) {
                bundleDesc.getModuleDescriptor().setModuleName(value);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public EjbBundleDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (EjbBundleDescriptor)DescriptorFactory.getDescriptor((String)this.getXMLPath());
        }
        return this.descriptor;
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-client-jar", "setEjbClientJarUri");
        return table;
    }

    public Node writeDescriptor(Node parent, EjbBundleDescriptor ejbDesc) {
        Node jarNode = super.writeDescriptor(parent, (RootDeploymentDescriptor)ejbDesc);
        Element entrepriseBeansNode = EjbBundleNode.appendChild((Node)jarNode, (String)"enterprise-beans");
        for (EjbDescriptor ejb : ejbDesc.getEjbs()) {
            EjbNode subNode;
            if ("Session".equals(ejb.getType())) {
                subNode = new EjbSessionNode();
                ((EjbSessionNode)subNode).writeDescriptor(entrepriseBeansNode, "session", (Descriptor)ejb);
                continue;
            }
            if ("Entity".equals(ejb.getType())) {
                subNode = new EjbEntityNode();
                ((EjbEntityNode)subNode).writeDescriptor(entrepriseBeansNode, "entity", (Descriptor)ejb);
                continue;
            }
            if ("Message-driven".equals(ejb.getType())) {
                subNode = new MessageDrivenBeanNode();
                ((MessageDrivenBeanNode)subNode).writeDescriptor(entrepriseBeansNode, "message-driven", (Descriptor)ejb);
                continue;
            }
            throw new IllegalStateException("Unknow ejb type " + ejb.getType());
        }
        if (ejbDesc.hasInterceptors()) {
            Element interceptorsNode = EjbBundleNode.appendChild((Node)jarNode, (String)"interceptors");
            EjbInterceptorNode interceptorNode = new EjbInterceptorNode();
            for (EjbInterceptor next : ejbDesc.getInterceptors()) {
                interceptorNode.writeDescriptor(interceptorsNode, "interceptor", next);
            }
        }
        if (ejbDesc.hasRelationships()) {
            new RelationshipsNode().writeDescriptor(jarNode, "relationships", ejbDesc);
        }
        this.writeAssemblyDescriptor(jarNode, ejbDesc);
        EjbBundleNode.appendTextChild((Node)jarNode, (String)"ejb-client-jar", (String)ejbDesc.getEjbClientJarUri());
        return jarNode;
    }

    public String getDocType() {
        return null;
    }

    public String getSystemID() {
        return SCHEMA_ID;
    }

    public List<String> getSystemIDs() {
        return systemIDs;
    }

    private void writeAssemblyDescriptor(Node parentNode, EjbBundleDescriptor bundleDescriptor) {
        Element assemblyNode = parentNode.getOwnerDocument().createElement("assembly-descriptor");
        SecurityRoleNode roleNode = new SecurityRoleNode();
        Iterator e = bundleDescriptor.getRoles().iterator();
        while (e.hasNext()) {
            roleNode.writeDescriptor((Node)assemblyNode, "security-role", (Role)e.next());
        }
        HashMap excludedMethodsByEjb = new HashMap();
        MethodPermissionNode mpNode = new MethodPermissionNode();
        for (EjbDescriptor ejbDesc : bundleDescriptor.getEjbs()) {
            if (ejbDesc instanceof EjbMessageBeanDescriptor) continue;
            Vector excludedMethods = new Vector();
            this.addMethodPermissions(ejbDesc, ejbDesc.getPermissionedMethodsByPermission(), excludedMethods, mpNode, assemblyNode);
            this.addMethodPermissions(ejbDesc, ejbDesc.getStyledPermissionedMethodsByPermission(), excludedMethods, mpNode, assemblyNode);
            if (excludedMethods.size() <= 0) continue;
            excludedMethodsByEjb.put(ejbDesc, excludedMethods);
        }
        ContainerTransactionNode ctNode = new ContainerTransactionNode();
        for (EjbDescriptor ejbDesc : bundleDescriptor.getEjbs()) {
            ctNode.writeDescriptor(assemblyNode, "container-transaction", ejbDesc);
        }
        Set ejbsForInterceptors = bundleDescriptor.getEjbs();
        InterceptorBindingNode interceptorBindingNode = new InterceptorBindingNode();
        for (EjbDescriptor ejbDesc : ejbsForInterceptors) {
            if (ejbDesc.getInterceptorClasses().size() <= 0) continue;
            interceptorBindingNode.writeBindings(assemblyNode, ejbDesc);
        }
        this.writeMessageDestinations(assemblyNode, bundleDescriptor.getMessageDestinations().iterator());
        if (excludedMethodsByEjb.size() > 0) {
            Element excludeListNode = EjbBundleNode.appendChild((Node)assemblyNode, (String)"exclude-list");
            for (EjbDescriptor ejbDesc : excludedMethodsByEjb.keySet()) {
                Vector excludedMethods = (Vector)excludedMethodsByEjb.get(ejbDesc);
                MethodPermissionDescriptor mpd = new MethodPermissionDescriptor();
                mpd.addMethodPermission(MethodPermission.getExcludedMethodPermission());
                mpd.addMethods((Collection)excludedMethods);
                mpNode.writeDescriptorInNode(excludeListNode, mpd, ejbDesc);
            }
        }
        for (EjbApplicationExceptionInfo next : bundleDescriptor.getApplicationExceptions().values()) {
            EjbApplicationExceptionNode node = new EjbApplicationExceptionNode();
            node.writeDescriptor(assemblyNode, "application-exception", next);
        }
        if (assemblyNode.hasChildNodes()) {
            parentNode.appendChild(assemblyNode);
        }
    }

    private void addMethodPermissions(EjbDescriptor ejb, Map mpToMethods, Vector excludedMethods, MethodPermissionNode mpNode, Node assemblyNode) {
        if (mpToMethods == null || mpToMethods.size() == 0) {
            return;
        }
        for (MethodPermission mp : mpToMethods.keySet()) {
            if (mp.isExcluded()) {
                Set methods = (Set)mpToMethods.get(mp);
                excludedMethods.addAll(methods);
                continue;
            }
            MethodPermissionDescriptor mpd = new MethodPermissionDescriptor();
            mpd.addMethodPermission(mp);
            mpd.addMethods((Collection)((Set)mpToMethods.get(mp)));
            mpNode.writeDescriptor(assemblyNode, "method-permission", mpd, ejb);
        }
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

