/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.EjbComponentAnnotationScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.EjbBundleValidator;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
@ArchivistFor(value="ejb")
public class EjbArchivist
extends Archivist<EjbBundleDescriptor> {
    @Inject
    @Named(value="EjbDeploymentDescriptorFile")
    Provider<DeploymentDescriptorFile> standardDD;
    @Inject
    @Named(value="EjbRuntimeDDFile")
    Provider<DeploymentDescriptorFile> ejbRuntimeDD;
    @Inject
    @Named(value="GFEjbRuntimeDDFile")
    Provider<DeploymentDescriptorFile> gfEjbRuntimeDD;

    public ArchiveType getModuleType() {
        return DeploymentUtils.ejbType();
    }

    public void setDescriptor(Application descriptor) {
        Set ejbBundles = descriptor.getBundleDescriptors(EjbBundleDescriptor.class);
        if (ejbBundles.size() > 0) {
            this.descriptor = (EjbBundleDescriptor)ejbBundles.iterator().next();
            if (((EjbBundleDescriptor)this.descriptor).getModuleDescriptor().isStandalone()) {
                return;
            }
            this.descriptor = null;
        }
    }

    public DeploymentDescriptorFile getStandardDDFile() {
        return (DeploymentDescriptorFile)this.standardDD.get();
    }

    public DeploymentDescriptorFile getGFConfigurationDDFile() {
        return (DeploymentDescriptorFile)this.gfEjbRuntimeDD.get();
    }

    public DeploymentDescriptorFile getSunConfigurationDDFile() {
        return (DeploymentDescriptorFile)this.ejbRuntimeDD.get();
    }

    public String getWebServicesDeploymentDescriptorPath() {
        return "META-INF/webservices.xml";
    }

    public EjbBundleDescriptor getDefaultBundleDescriptor() {
        return new EjbBundleDescriptor();
    }

    protected void postOpen(EjbBundleDescriptor descriptor, ReadableArchive archive) throws IOException {
        super.postOpen((RootDeploymentDescriptor)descriptor, archive);
        this.postValidate((BundleDescriptor)descriptor, archive);
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((EjbBundleDescriptor)this.descriptor).setClassLoader(cl);
        ((EjbBundleDescriptor)this.descriptor).visit((ComponentVisitor)new EjbBundleValidator());
    }

    protected String getArchiveExtension() {
        return ".jar";
    }

    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        AnnotationDetector detector = new AnnotationDetector((AnnotationScanner)new EjbComponentAnnotationScanner());
        return !DeploymentUtils.isWebArchive((ReadableArchive)abstractArchive) && detector.hasAnnotationInArchiveWithNoScanning(abstractArchive);
    }
}

