/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractEjbHandler;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=Singleton.class)
public class SingletonHandler
extends AbstractEjbHandler {
    protected String getAnnotatedName(Annotation annotation) {
        Singleton slAn = (Singleton)annotation;
        return slAn.name();
    }

    protected boolean isValidEjbDescriptor(EjbDescriptor ejbDesc, Annotation annotation) {
        EjbSessionDescriptor sessionDesc;
        boolean isValid = "Session".equals(ejbDesc.getType());
        if (isValid && (sessionDesc = (EjbSessionDescriptor)ejbDesc).isSessionTypeSet() && !sessionDesc.isSingleton()) {
            isValid = false;
        }
        return isValid;
    }

    protected EjbDescriptor createEjbDescriptor(String elementName, AnnotationInfo ainfo) throws AnnotationProcessorException {
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        Class ejbClass = (Class)ae;
        EjbSessionDescriptor newDescriptor = new EjbSessionDescriptor();
        newDescriptor.setName(elementName);
        newDescriptor.setEjbClassName(ejbClass.getName());
        newDescriptor.setSessionType("Singleton");
        this.doSingletonSpecificProcessing(newDescriptor, ejbClass);
        return newDescriptor;
    }

    protected HandlerProcessingResult setEjbDescriptorInfo(EjbDescriptor ejbDesc, AnnotationInfo ainfo) throws AnnotationProcessorException {
        EjbSessionDescriptor ejbSingletonDescriptor = (EjbSessionDescriptor)ejbDesc;
        Class ejbClass = (Class)ainfo.getAnnotatedElement();
        Singleton singleton = (Singleton)ainfo.getAnnotation();
        if (!ejbSingletonDescriptor.isSessionTypeSet()) {
            ejbSingletonDescriptor.setSessionType("Singleton");
        }
        this.doDescriptionProcessing(singleton.description(), ejbDesc);
        this.doMappedNameProcessing(singleton.mappedName(), ejbDesc);
        this.doSingletonSpecificProcessing(ejbSingletonDescriptor, ejbClass);
        return this.setBusinessAndHomeInterfaces(ejbDesc, ainfo);
    }

    private void doSingletonSpecificProcessing(EjbSessionDescriptor desc, Class ejbClass) {
        DependsOn dep;
        Class clz = ejbClass;
        Startup st = clz.getAnnotation(Startup.class);
        if (st != null) {
            desc.setInitOnStartupIfNotAlreadySet(true);
        }
        if ((dep = clz.getAnnotation(DependsOn.class)) != null) {
            desc.setDependsOnIfNotSet(dep.value());
        }
    }
}

