/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment;

import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.loader.ASURLClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="ejb")
public class EjbJarHandler
extends AbstractArchiveHandler {
    @Inject
    @Named(value="ejb")
    private ArchiveDetector detector;

    public String getArchiveType() {
        return "ejb";
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    public String getVersionIdentifier(ReadableArchive archive) {
        String versionIdentifier = null;
        try {
            GFEjbJarXMLParser gfXMLParser = new GFEjbJarXMLParser(null);
            versionIdentifier = gfXMLParser.extractVersionIdentifierValue(archive);
        }
        catch (XMLStreamException e) {
            _logger.log(Level.SEVERE, e.getMessage());
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, e.getMessage());
        }
        return versionIdentifier;
    }

    public ClassLoader getClassLoader(final ClassLoader parent, DeploymentContext context) {
        ASURLClassLoader cloader = AccessController.doPrivileged(new PrivilegedAction<ASURLClassLoader>(){

            @Override
            public ASURLClassLoader run() {
                return new ASURLClassLoader(parent);
            }
        });
        try {
            SunEjbJarXMLParser sunEjbJarXMLParser;
            GFEjbJarXMLParser gfEjbJarXMLParser;
            String compatProp = context.getAppProps().getProperty("compatibility");
            if (compatProp == null && (compatProp = (gfEjbJarXMLParser = new GFEjbJarXMLParser(context.getSourceDir())).getCompatibilityValue()) != null) {
                context.getAppProps().put("compatibility", compatProp);
            }
            if (compatProp == null && (compatProp = (sunEjbJarXMLParser = new SunEjbJarXMLParser(context.getSourceDir())).getCompatibilityValue()) != null) {
                context.getAppProps().put("compatibility", compatProp);
            }
            if (compatProp != null && compatProp.equals("v2")) {
                List moduleRootLibraries = ASClassLoaderUtil.getURLsAsList(null, (File[])new File[]{context.getSourceDir()}, (boolean)true);
                for (URL url : moduleRootLibraries) {
                    cloader.addURL(url);
                }
            }
            cloader.addURL(context.getSource().getURI().toURL());
            cloader.addURL(context.getScratchDir("ejb").toURI().toURL());
            for (URL url : this.getManifestLibraries(context)) {
                cloader.addURL(url);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
        return cloader;
    }

    private static class SunEjbJarXMLParser {
        private XMLStreamReader parser = null;
        private String compatValue = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SunEjbJarXMLParser(File baseDir) throws XMLStreamException, FileNotFoundException {
            FileInputStream input = null;
            File f = new File(baseDir, "META-INF/sun-ejb-jar.xml");
            if (f.exists()) {
                Exception ex22;
                block12: {
                    input = new FileInputStream(f);
                    try {
                        this.read(input);
                        Object var5_4 = null;
                        if (this.parser == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Exception ex22;
                        Object var5_5 = null;
                        if (this.parser != null) {
                            try {
                                this.parser.close();
                            }
                            catch (Exception ex22) {
                                // empty catch block
                            }
                        }
                        if (input != null) {
                            try {
                                ((InputStream)input).close();
                            }
                            catch (Exception ex22) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        this.parser.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                }
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Exception ex22) {}
                }
            }
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = EjbJarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean done = false;
            this.skipRoot("sun-ejb-jar");
            while (!done && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("compatibility".equals(name)) {
                    this.compatValue = this.parser.getElementText();
                    done = true;
                    continue;
                }
                this.skipSubTree(name);
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getCompatibilityValue() {
            return this.compatValue;
        }
    }

    private static class GFEjbJarXMLParser {
        private XMLStreamReader parser = null;
        private String compatValue = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GFEjbJarXMLParser(File baseDir) throws XMLStreamException, FileNotFoundException {
            FileInputStream input = null;
            File f = new File(baseDir, "META-INF/glassfish-ejb-jar.xml");
            if (f.exists()) {
                Exception ex22;
                block12: {
                    input = new FileInputStream(f);
                    try {
                        this.read(input);
                        Object var5_4 = null;
                        if (this.parser == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Exception ex22;
                        Object var5_5 = null;
                        if (this.parser != null) {
                            try {
                                this.parser.close();
                            }
                            catch (Exception ex22) {
                                // empty catch block
                            }
                        }
                        if (input != null) {
                            try {
                                ((InputStream)input).close();
                            }
                            catch (Exception ex22) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        this.parser.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                }
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Exception ex22) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String extractVersionIdentifierValue(ReadableArchive archive) throws XMLStreamException, IOException {
            String versionIdentifierValue;
            InputStream input;
            block14: {
                input = null;
                versionIdentifierValue = null;
                String rootElement = null;
                try {
                    rootElement = "glassfish-ejb-jar";
                    input = archive.getEntry("META-INF/glassfish-ejb-jar.xml");
                    if (input != null) {
                        this.parser = EjbJarHandler.getXMLInputFactory().createXMLStreamReader(input);
                        int event = 0;
                        this.skipRoot(rootElement);
                        while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                            if (event != 1) continue;
                            String name = this.parser.getLocalName();
                            if ("version-identifier".equals(name)) {
                                versionIdentifierValue = this.parser.getElementText();
                                continue;
                            }
                            this.skipSubTree(name);
                        }
                    }
                    Object var8_7 = null;
                    if (this.parser == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    this.parser.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {}
            }
            return versionIdentifierValue;
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = EjbJarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean done = false;
            this.skipRoot("glassfish-ejb-jar");
            while (!done && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("compatibility".equals(name)) {
                    this.compatValue = this.parser.getElementText();
                    done = true;
                    continue;
                }
                this.skipSubTree(name);
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getCompatibilityValue() {
            return this.compatValue;
        }
    }
}

