/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.builder;

import com.sun.ejb.base.container.util.CacheProperties;
import com.sun.ejb.base.sfsb.util.CheckpointPolicyImpl;
import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.base.sfsb.util.ScrambledKeyGenerator;
import com.sun.ejb.base.sfsb.util.SimpleKeyGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.builder.BaseContainerBuilder;
import com.sun.ejb.containers.builder.CachePassivatorTask;
import com.sun.ejb.containers.builder.ExpiredSessionsRemovalTask;
import com.sun.ejb.containers.util.cache.FIFOSessionCache;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.containers.util.cache.NRUSessionCache;
import com.sun.ejb.containers.util.cache.UnBoundedSessionCache;
import com.sun.ejb.spi.container.SFSBContainerInitialization;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.deployment.EjbDescriptor;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbContainerAvailability;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.glassfish.hk2.Services;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class StatefulContainerBuilder
extends BaseContainerBuilder {
    private static final Level TRACE_LEVEL = Level.FINE;
    private StatefulSessionContainer sfsbContainer;
    private SFSBContainerInitialization containerInitialization;
    @Inject
    private Services services;
    @Inject
    private CacheProperties cacheProps;
    @Inject
    private EJBServerConfigLookup ejbConfigLookup;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    private AvailabilityService availabilityService;
    @Inject
    @Optional
    private EjbContainerAvailability ejbAvailability;
    @Inject
    @Named(value="default-instance-name")
    EjbContainer ejbContainerConfig;
    @Inject
    @Optional
    GMSAdapterService gmsAdapterService;
    private LruSessionCache sessionCache;
    private BackingStore<Serializable, SimpleMetadata> backingStore;
    private boolean HAEnabled = false;
    private boolean asyncReplication = true;
    private SimpleKeyGenerator keyGen;

    public BaseContainer createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader) throws Exception {
        this.cacheProps.init(ejbDescriptor);
        this.ejbConfigLookup.initWithEjbDescriptor(ejbDescriptor);
        this.sfsbContainer = new StatefulSessionContainer(ejbDescriptor, loader);
        this.containerInitialization = this.sfsbContainer;
        return this.sfsbContainer;
    }

    public void buildComponents() throws Exception {
        if (this.availabilityService != null) {
            this.HAEnabled = Boolean.valueOf(this.availabilityService.getAvailabilityEnabled());
            _logger.log(Level.INFO, "ejb.sfsb_builder_top_level_availability_service_enabled", this.HAEnabled);
            if (this.HAEnabled && this.ejbAvailability != null) {
                this.HAEnabled = Boolean.valueOf(this.ejbAvailability.getAvailabilityEnabled());
                _logger.log(Level.INFO, "ejb.sfsb_builder_ejb_availability_service_enabled", this.HAEnabled);
            }
            boolean appLevelHAEnabled = false;
            try {
                if (this.HAEnabled) {
                    DeployCommandParameters params;
                    DeploymentContext dc = this.getDynamicDeploymentContext();
                    if (dc != null && (params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)) != null) {
                        appLevelHAEnabled = params.availabilityenabled;
                        this.asyncReplication = params.asyncreplication;
                    }
                    _logger.log(Level.INFO, "ejb.sfsb_builder_global_and_app_availability_enabled", new Object[]{this.HAEnabled, appLevelHAEnabled});
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "ejb.sfsb_builder_determine_availability_exception", ex);
                appLevelHAEnabled = false;
            }
            this.HAEnabled = this.HAEnabled && appLevelHAEnabled;
            _logger.log(Level.INFO, "ejb.sfsb_builder_resolved_availability_enabled", this.HAEnabled);
        }
        this.buildCheckpointPolicy(this.HAEnabled);
        this.buildSFSBUUIDUtil();
        this.buildStoreManager();
        this.buildCache();
        this.scheduleTimerTasks(this.sfsbContainer);
    }

    private final void buildCheckpointPolicy(boolean haEnabled) {
        this.containerInitialization.setCheckpointPolicy(new CheckpointPolicyImpl(haEnabled));
    }

    private void buildSFSBUUIDUtil() {
        this.keyGen = this.HAEnabled ? new ScrambledKeyGenerator(this.getIPAddress(), this.getPort()) : new SimpleKeyGenerator(this.getIPAddress(), this.getPort());
        this.containerInitialization.setSFSBUUIDUtil(this.keyGen);
    }

    private void buildStoreManager() throws BackingStoreException {
        GMSAdapter gmsAdapter;
        String persistenceStoreType = "file";
        if (this.ejbAvailability != null) {
            String string = persistenceStoreType = this.HAEnabled ? this.ejbAvailability.getSfsbHaPersistenceType() : this.ejbAvailability.getSfsbPersistenceType();
            if ("ha".equals(persistenceStoreType)) {
                persistenceStoreType = "replicated";
            } else if ("memory".equals(persistenceStoreType)) {
                persistenceStoreType = "file";
            }
        }
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        String storeName = this.ejbDescriptor.getName() + "-" + this.ejbDescriptor.getUniqueId() + "-BackingStore";
        _logger.log(Level.INFO, "ejb.sfsb_builder_store_name", storeName);
        String subDirName = "";
        subDirName = subDirName + this.ejbDescriptor.getName() + "-" + this.ejbDescriptor.getUniqueId();
        conf.setShortUniqueName("" + this.ejbDescriptor.getUniqueId()).setStoreName(storeName).setStoreType(persistenceStoreType).setBaseDirectory(new File(this.ejbContainerConfig.getSessionStore(), subDirName)).setKeyClazz(Serializable.class).setValueClazz(SimpleMetadata.class).setClassLoader(StatefulContainerBuilder.class.getClassLoader());
        Map vendorMap = conf.getVendorSpecificSettings();
        vendorMap.put("local.caching", true);
        vendorMap.put("start.gms", false);
        vendorMap.put("async.replication", this.asyncReplication);
        vendorMap.put("broadcast.remove.expired", false);
        vendorMap.put("value.class.is.thread.safe", true);
        vendorMap.put("key.transformer", this.keyGen);
        if (this.gmsAdapterService != null && (gmsAdapter = this.gmsAdapterService.getGMSAdapter()) != null) {
            conf.setClusterName(gmsAdapter.getClusterName());
            conf.setInstanceName(gmsAdapter.getModule().getInstanceName());
        }
        BackingStoreFactory factory = null;
        try {
            factory = (BackingStoreFactory)this.services.forContract(BackingStoreFactory.class).named(persistenceStoreType).get();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_builder_instantiate_backing_store_exception", persistenceStoreType);
            _logger.log(Level.WARNING, "", ex);
        }
        try {
            if (factory == null) {
                factory = (BackingStoreFactory)this.services.forContract(BackingStoreFactory.class).named("noop").get();
            }
            this.backingStore = factory.createBackingStore(conf);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_builder_instantiate_backing_store_exception", persistenceStoreType);
            _logger.log(Level.WARNING, "", ex);
            throw new BackingStoreException(_logger.getResourceBundle().getString("ejb.sfsb_builder_instantiate_backing_store_exception"), (Throwable)ex);
        }
        _logger.log(Level.INFO, "ejb.sfsb_builder_instantiated_backing_store", new Object[]{this.backingStore, this.HAEnabled, conf});
    }

    private void buildCache() {
        String cacheName = this.ejbDescriptor.getEjbClassName();
        String victimPolicy = this.cacheProps.getVictimSelectionPolicy();
        this.sessionCache = this.cacheProps.getMaxCacheSize() <= 0 ? new UnBoundedSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("lru".equalsIgnoreCase(victimPolicy) ? new LruSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("fifo".equalsIgnoreCase(victimPolicy) ? new FIFOSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : new NRUSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds())));
        float ratio = (float)(1.0 * (double)this.cacheProps.getNumberOfVictimsToSelect() / (double)this.cacheProps.getMaxCacheSize());
        float loadFactor = (float)(1.0 - (double)ratio);
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            loadFactor = 0.75f;
        }
        if (this.cacheProps.getMaxCacheSize() <= 0) {
            this.sessionCache.init(16384, loadFactor, null);
        } else {
            this.sessionCache.init(this.cacheProps.getMaxCacheSize(), loadFactor, null);
        }
        this.sessionCache.addCacheListener(this.sfsbContainer);
        this.sfsbContainer.setSessionCache(this.sessionCache);
        this.sessionCache.setBackingStore(this.backingStore);
        this.sfsbContainer.setBackingStore(this.backingStore);
        if (this.cacheProps.getNumberOfVictimsToSelect() > 8) {
            this.sfsbContainer.setPassivationBatchCount(this.cacheProps.getNumberOfVictimsToSelect());
        }
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "ejb.sfsb_builder_created_cache", new Object[]{this.ejbDescriptor.getName(), this.cacheProps, Float.valueOf(loadFactor), this.backingStore});
        }
    }

    private void scheduleTimerTasks(StatefulSessionContainer container) {
        long timeout;
        String ejbName = this.ejbDescriptor.getEjbClassName();
        if (this.cacheProps.getCacheIdleTimeoutInSeconds() > 0) {
            timeout = (long)this.cacheProps.getCacheIdleTimeoutInSeconds() * 1000L;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new CachePassivatorTask(ejbName, this.sessionCache, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "ejb.sfsb_builder_added_cache_passivator", new Object[]{ejbName, timeout});
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "ejb.sfsb_helper_add_idle_passivator_task_failed", th);
            }
        }
        if (this.cacheProps.getRemovalTimeoutInSeconds() > 0) {
            timeout = (long)this.cacheProps.getRemovalTimeoutInSeconds() * 1000L;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new ExpiredSessionsRemovalTask(ejbName, this.sfsbContainer, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "ejb.sfsb_builder_added_store_passivator", new Object[]{ejbName, timeout});
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "ejb.sfsb_helper_add_remove_passivator_task_failed", th);
            }
        }
    }
}

